/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.wizards;

import java.net.MalformedURLException;
import java.text.ParseException;
import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.ISVNRemoteFile;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.history.ILogEntry;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.dialogs.ChooseUrlDialog;
import org.tigris.subversion.subclipse.ui.dialogs.HistoryDialog;
import org.tigris.subversion.subclipse.ui.util.UrlCombo;
import org.tigris.subversion.subclipse.ui.wizards.SVNWizardPage;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class ReplaceWithBranchTagWizardMainPage
extends SVNWizardPage {
    private IResource[] resources;
    private UrlCombo urlCombo;
    private Text revisionText;
    private Button logButton;
    private Button headButton;
    private Button switchButton;
    private Button replaceButton;
    private String[] urlStrings;
    private String commonRoot;
    private SVNUrl url;
    private SVNRevision revision;
    private long revisionNumber;
    private IDialogSettings settings = SVNUIPlugin.getPlugin().getDialogSettings();
    public static final String REPLACE_CONTENTS = "ReplaceWithBranchTagWizardMainPage.replaceContents";
    private static final int REVISION_WIDTH_HINT = 40;

    public ReplaceWithBranchTagWizardMainPage(IResource[] resources) {
        super("mainPage", Policy.bind("ReplaceWithBranchTagWizardMainPage.1"), SVNUIPlugin.getPlugin().getImageDescriptor("wizban/svn_wizban.png"), Policy.bind("ReplaceWithBranchTagWizardMainPage.2"));
        this.resources = resources;
    }

    public void createControl(Composite parent) {
        Composite outerContainer = new Composite(parent, 0);
        GridLayout outerLayout = new GridLayout();
        outerLayout.numColumns = 1;
        outerLayout.marginHeight = 0;
        outerLayout.marginWidth = 0;
        outerContainer.setLayout((Layout)outerLayout);
        outerContainer.setLayoutData((Object)new GridData(768));
        Group urlGroup = new Group(outerContainer, 0);
        GridLayout urlLayout = new GridLayout();
        urlLayout.numColumns = 3;
        urlGroup.setLayout((Layout)urlLayout);
        urlGroup.setLayoutData((Object)new GridData(768));
        urlGroup.setText(Policy.bind("ReplaceWithBranchTagWizardMainPage.3"));
        Label urlLabel = new Label((Composite)urlGroup, 0);
        urlLabel.setText(Policy.bind("ReplaceWithBranchTagWizardMainPage.0"));
        this.urlCombo = new UrlCombo((Composite)urlGroup, 0);
        this.urlCombo.init(this.resources[0].getProject().getName());
        this.urlCombo.setLayoutData(new GridData(768));
        this.commonRoot = this.getCommonRoot();
        if (this.commonRoot != null) {
            this.urlCombo.setText(this.commonRoot);
        }
        this.urlCombo.getCombo().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ReplaceWithBranchTagWizardMainPage.this.setPageComplete(ReplaceWithBranchTagWizardMainPage.this.canFinish());
            }
        });
        Button browseButton = new Button((Composite)urlGroup, 8);
        browseButton.setText(Policy.bind("SwitchDialog.browse"));
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChooseUrlDialog dialog = new ChooseUrlDialog(ReplaceWithBranchTagWizardMainPage.this.getShell(), ReplaceWithBranchTagWizardMainPage.this.resources[0]);
                dialog.setIncludeBranchesAndTags(ReplaceWithBranchTagWizardMainPage.this.resources.length == 1);
                if (dialog.open() == 0 && dialog.getUrl() != null) {
                    ReplaceWithBranchTagWizardMainPage.this.urlCombo.setText(dialog.getUrl());
                    ReplaceWithBranchTagWizardMainPage.this.setPageComplete(ReplaceWithBranchTagWizardMainPage.this.canFinish());
                }
            }
        });
        Composite revisionGroup = new Composite((Composite)urlGroup, 0);
        GridLayout revisionLayout = new GridLayout();
        revisionLayout.numColumns = 3;
        revisionLayout.marginWidth = 0;
        revisionLayout.marginHeight = 0;
        revisionGroup.setLayout((Layout)revisionLayout);
        GridData data = new GridData(768);
        data.horizontalSpan = 3;
        revisionGroup.setLayoutData((Object)data);
        this.headButton = new Button(revisionGroup, 32);
        this.headButton.setText(Policy.bind("ReplaceWithBranchTagWizardMainPage.5"));
        data = new GridData();
        data.horizontalSpan = 3;
        this.headButton.setLayoutData((Object)data);
        Label revisionLabel = new Label(revisionGroup, 0);
        revisionLabel.setText(Policy.bind("SvnWizardSwitchPage.revision"));
        this.revisionText = new Text(revisionGroup, 2048);
        data = new GridData();
        data.widthHint = 40;
        this.revisionText.setLayoutData((Object)data);
        if (this.revisionNumber == 0L) {
            this.headButton.setSelection(true);
            this.revisionText.setEnabled(false);
        } else {
            this.revisionText.setText("" + this.revisionNumber);
        }
        this.revisionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ReplaceWithBranchTagWizardMainPage.this.setPageComplete(ReplaceWithBranchTagWizardMainPage.this.canFinish());
            }
        });
        FocusAdapter focusListener = new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ((Text)e.getSource()).selectAll();
            }

            public void focusLost(FocusEvent e) {
                ((Text)e.getSource()).setText(((Text)e.getSource()).getText());
            }
        };
        this.revisionText.addFocusListener((FocusListener)focusListener);
        this.logButton = new Button(revisionGroup, 8);
        this.logButton.setText(Policy.bind("MergeDialog.showLog"));
        this.logButton.setEnabled(false);
        this.logButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReplaceWithBranchTagWizardMainPage.this.showLog();
            }
        });
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReplaceWithBranchTagWizardMainPage.this.revisionText.setEnabled(!ReplaceWithBranchTagWizardMainPage.this.headButton.getSelection());
                ReplaceWithBranchTagWizardMainPage.this.logButton.setEnabled(!ReplaceWithBranchTagWizardMainPage.this.headButton.getSelection());
                ReplaceWithBranchTagWizardMainPage.this.setPageComplete(ReplaceWithBranchTagWizardMainPage.this.canFinish());
                if (!ReplaceWithBranchTagWizardMainPage.this.headButton.getSelection()) {
                    ReplaceWithBranchTagWizardMainPage.this.revisionText.selectAll();
                    ReplaceWithBranchTagWizardMainPage.this.revisionText.setFocus();
                }
            }
        };
        this.headButton.addSelectionListener((SelectionListener)listener);
        Group typeGroup = new Group(outerContainer, 0);
        GridLayout typeLayout = new GridLayout();
        typeLayout.numColumns = 1;
        typeGroup.setLayout((Layout)typeLayout);
        typeGroup.setLayoutData((Object)new GridData(768));
        typeGroup.setText(Policy.bind("ReplaceWithBranchTagWizardMainPage.6"));
        this.switchButton = new Button((Composite)typeGroup, 16);
        this.switchButton.setText(Policy.bind("ReplaceWithBranchTagWizardMainPage.7"));
        Label switchLabel = new Label((Composite)typeGroup, 64);
        switchLabel.setText(Policy.bind("ReplaceWithBranchTagWizardMainPage.8"));
        data = new GridData(768);
        data.widthHint = 500;
        data.horizontalIndent = 15;
        switchLabel.setLayoutData((Object)data);
        this.replaceButton = new Button((Composite)typeGroup, 16);
        this.replaceButton.setText(Policy.bind("ReplaceWithBranchTagWizardMainPage.9"));
        data = new GridData();
        data.verticalIndent = 15;
        this.replaceButton.setLayoutData((Object)data);
        Label contentsLabel = new Label((Composite)typeGroup, 64);
        contentsLabel.setText(Policy.bind("ReplaceWithBranchTagWizardMainPage.10"));
        data = new GridData(768);
        data.widthHint = 500;
        data.horizontalIndent = 15;
        contentsLabel.setLayoutData((Object)data);
        if (this.settings.getBoolean(REPLACE_CONTENTS)) {
            this.replaceButton.setSelection(true);
        } else {
            this.switchButton.setSelection(true);
        }
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReplaceWithBranchTagWizardMainPage.this.settings.put(ReplaceWithBranchTagWizardMainPage.REPLACE_CONTENTS, ReplaceWithBranchTagWizardMainPage.this.replaceButton.getSelection());
                ReplaceWithBranchTagWizardMainPage.this.setPageComplete(ReplaceWithBranchTagWizardMainPage.this.canFinish());
            }
        };
        this.replaceButton.addSelectionListener((SelectionListener)selectionListener);
        this.switchButton.addSelectionListener((SelectionListener)selectionListener);
        this.setControl((Control)outerContainer);
    }

    public boolean performFinish() {
        this.urlCombo.saveUrl();
        try {
            this.url = new SVNUrl(this.urlCombo.getText());
        }
        catch (MalformedURLException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Replace with Branch/Tag", (String)e.getMessage());
            return false;
        }
        if (this.headButton.getSelection()) {
            this.revision = SVNRevision.HEAD;
        } else {
            try {
                this.revision = SVNRevision.getRevision((String)this.revisionText.getText().trim());
            }
            catch (ParseException parseException) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Replace with Branch/Tag", (String)Policy.bind("SwitchDialog.invalid"));
                return false;
            }
        }
        return true;
    }

    public boolean isReplace() {
        return this.replaceButton.getSelection();
    }

    protected void showLog() {
        ISVNRemoteFile remoteResource = null;
        try {
            remoteResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)this.resources[0]).getRepository().getRemoteFile(new SVNUrl(this.urlCombo.getText()));
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)Policy.bind("MergeDialog.showLog"), (String)e.toString());
            return;
        }
        if (remoteResource == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)Policy.bind("MergeDialog.showLog"), (String)(String.valueOf(Policy.bind("MergeDialog.urlError")) + " " + this.urlCombo.getText()));
            return;
        }
        HistoryDialog dialog = new HistoryDialog(this.getShell(), (ISVNRemoteResource)remoteResource);
        if (dialog.open() == 1) {
            return;
        }
        ILogEntry[] selectedEntries = dialog.getSelectedLogEntries();
        if (selectedEntries.length == 0) {
            return;
        }
        this.revisionText.setText(Long.toString(selectedEntries[selectedEntries.length - 1].getRevision().getNumber()));
        this.setPageComplete(this.canFinish());
    }

    public boolean canFinish() {
        this.setErrorMessage(null);
        return this.urlCombo.getText().length() > 0 && (this.headButton.getSelection() || this.revisionText.getText().trim().length() > 0);
    }

    public SVNUrl getUrl() {
        return this.url;
    }

    public SVNRevision getRevision() {
        return this.revision;
    }

    private String getCommonRoot() {
        ArrayList<String> urlList = new ArrayList<String>();
        IResource[] iResourceArray = this.resources;
        int n = this.resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)resource);
            try {
                String anUrl = svnResource.getStatus().getUrlString();
                if (anUrl != null) {
                    urlList.add(anUrl);
                }
            }
            catch (SVNException sVNException) {}
            ++n2;
        }
        this.urlStrings = new String[urlList.size()];
        urlList.toArray(this.urlStrings);
        if (this.urlStrings.length == 0) {
            return null;
        }
        String urlString = this.urlStrings[0];
        if (this.urlStrings.length == 1) {
            return urlString;
        }
        String commonRoot = null;
        int i = 0;
        block3: while (i < urlString.length()) {
            String partialPath = urlString.substring(0, i + 1);
            if (partialPath.endsWith("/")) {
                int j = 1;
                while (j < this.urlStrings.length) {
                    if (!this.urlStrings[j].startsWith(partialPath)) break block3;
                    ++j;
                }
                commonRoot = partialPath.substring(0, i);
            }
            ++i;
        }
        return commonRoot;
    }
}

