/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.samples;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.sf.jasperreports.eclipse.util.BundleCommonUtils;
import net.sf.jasperreports.samples.ISamplesProvider;
import net.sf.jasperreports.samples.messages.Messages;
import org.apache.commons.io.FileUtils;

public class JasperReportsSamplesProvider
implements ISamplesProvider {
    private static File tmpJRSamplesLocation = null;
    private Set<File> sourceFolders = null;
    private Set<File> additionalLibraries = null;
    private Set<File> samplesFolders = null;

    static {
        try {
            tmpJRSamplesLocation = new File(FileUtils.getTempDirectory(), "jrSamples" + System.currentTimeMillis());
            tmpJRSamplesLocation.mkdir();
            tmpJRSamplesLocation.deleteOnExit();
            String samplesZipLocation = BundleCommonUtils.getFileLocation((String)"net.sf.jasperreports.samples", (String)"resources/jrsamples.zip");
            net.sf.jasperreports.eclipse.util.FileUtils.unZip((File)new File(samplesZipLocation), (File)tmpJRSamplesLocation);
        }
        catch (IOException e) {
            BundleCommonUtils.logError((String)"net.sf.jasperreports.samples", (String)Messages.JasperReportsSamplesProvider_UnzipSamplesError, (Throwable)e);
        }
    }

    @Override
    public Set<File> getSourceFolders() {
        if (this.sourceFolders == null && tmpJRSamplesLocation != null) {
            this.sourceFolders = new HashSet<File>(1);
            this.sourceFolders.add(new File(tmpJRSamplesLocation, "src"));
        }
        return this.sourceFolders;
    }

    @Override
    public Set<File> getAdditionalLibraries() {
        if (this.additionalLibraries == null && tmpJRSamplesLocation != null) {
            File libFolder = new File(tmpJRSamplesLocation, "lib");
            File[] jars = libFolder.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".jar");
                }
            });
            this.additionalLibraries = new HashSet<File>(Arrays.asList(jars));
        }
        return this.additionalLibraries;
    }

    @Override
    public Set<File> getSampleFolders() {
        if (this.samplesFolders == null && tmpJRSamplesLocation != null) {
            File[] files = tmpJRSamplesLocation.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    if (new File(dir, name).isDirectory()) {
                        return !"src".equals(name) && !"lib".equals(name);
                    }
                    return false;
                }
            });
            this.samplesFolders = new HashSet<File>(Arrays.asList(files));
        }
        return this.samplesFolders;
    }
}

