/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.AbstractJRXMLEditor;
import com.jaspersoft.studio.editor.gef.selection.SelectElementCommand;
import com.jaspersoft.studio.editor.report.AbstractVisualEditor;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.MLockableRefresh;
import com.jaspersoft.studio.model.MRoot;
import com.jaspersoft.studio.utils.SelectionHelper;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignElement;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.ui.IEditorPart;

public class JSSCompoundCommand
extends CompoundCommand {
    public static final String REFRESH_UI_EVENT = "refreshUIEvent";
    private ANode referenceNode = null;
    private boolean restoreSelection = false;
    private SelectElementCommand restoreSelectionCommand = null;

    public JSSCompoundCommand(CompoundCommand cmd, ANode node) {
        this.setLabel(cmd.getLabel());
        for (Object item : cmd.getCommands()) {
            this.add((Command)item);
        }
        this.referenceNode = node;
    }

    public JSSCompoundCommand(ANode node) {
        this.referenceNode = node;
    }

    public JSSCompoundCommand(String name, ANode node) {
        super(name);
        this.referenceNode = node;
    }

    protected void setReferenceNode(ANode referenceNode) {
        this.referenceNode = referenceNode;
    }

    public void setReferenceNodeIfNull(ANode referenceNode) {
        if (this.referenceNode == null) {
            ANode root;
            ANode newReferenceNode = referenceNode;
            if (newReferenceNode != null && (root = (ANode)newReferenceNode.getRoot()) != null) {
                newReferenceNode = root;
            }
            this.referenceNode = newReferenceNode;
        }
    }

    public void setReferenceNodeIfNull(Object referenceNode) {
        if (this.referenceNode == null && referenceNode instanceof ANode) {
            ANode root;
            ANode newReferenceNode = (ANode)referenceNode;
            if (newReferenceNode != null && (root = (ANode)newReferenceNode.getRoot()) != null) {
                newReferenceNode = root;
            }
            this.referenceNode = newReferenceNode;
        }
    }

    public static boolean isRefreshEventsIgnored(ANode node) {
        ANode mainNode = JSSCompoundCommand.getMainNode(node);
        if (mainNode == null) {
            mainNode = JSSCompoundCommand.getMainNode(SelectionHelper.getOpenedRoot());
        }
        if (mainNode instanceof MLockableRefresh) {
            return ((MLockableRefresh)mainNode).isRefreshEventIgnored();
        }
        return false;
    }

    public static ANode getMainNode(INode startNode) {
        if (startNode != null) {
            if (startNode instanceof MLockableRefresh) {
                return (MLockableRefresh)startNode;
            }
            if (startNode instanceof MRoot) {
                return JSSCompoundCommand.getMainNode(startNode.getChildren().get(0));
            }
            INode node = startNode.getParent();
            if (node instanceof MRoot) {
                return null;
            }
            return JSSCompoundCommand.getMainNode(node);
        }
        return null;
    }

    public ANode getReferenceNode() {
        return this.referenceNode;
    }

    protected ANode getNode() {
        if (this.referenceNode != null) {
            if (this.referenceNode instanceof MLockableRefresh) {
                return this.referenceNode;
            }
            if (this.referenceNode instanceof MRoot) {
                this.referenceNode = (ANode)this.referenceNode.getChildren().get(0);
                return this.getNode();
            }
            this.referenceNode = this.referenceNode.getParent();
            if (this.referenceNode instanceof MRoot) {
                this.referenceNode = null;
                return null;
            }
            return this.getNode();
        }
        return null;
    }

    protected void refreshVisuals() {
        try {
            ANode report = this.getNode();
            if (report != null) {
                PropertyChangeEvent event = new PropertyChangeEvent(report.getJasperDesign(), REFRESH_UI_EVENT, null, null);
                report.getPropertyChangeSupport().firePropertyChange(event);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JaspersoftStudioPlugin.getInstance().logError(ex);
        }
    }

    public static void forceRefreshVisuals(ANode node) {
        if (node != null && node.getValue() != null) {
            PropertyChangeEvent event = new PropertyChangeEvent(node.getValue(), REFRESH_UI_EVENT, null, null);
            node.getPropertyChangeSupport().firePropertyChange(event);
        }
    }

    protected void setIgnoreEvents(boolean value) {
        ANode rootNode = this.getNode();
        if (rootNode != null && rootNode instanceof MLockableRefresh) {
            ((MLockableRefresh)rootNode).setIgnoreEvents(value, (Object)this);
        }
    }

    protected boolean isIgnoreEvents() {
        ANode rootNode = this.getNode();
        if (rootNode != null && rootNode instanceof MLockableRefresh) {
            return ((MLockableRefresh)rootNode).isRefreshEventIgnored();
        }
        return false;
    }

    protected void backupSelection() {
        AbstractVisualEditor visaulEditor;
        GraphicalViewer viewer;
        IEditorPart designEditor;
        AbstractJRXMLEditor editor;
        if (this.restoreSelection && (editor = (AbstractJRXMLEditor)SelectionHelper.getActiveJRXMLEditor()) != null && (designEditor = editor.getActiveInnerEditor()) instanceof AbstractVisualEditor && (viewer = (visaulEditor = (AbstractVisualEditor)designEditor).getGraphicalViewer()) != null) {
            List selectedParts = viewer.getSelectedEditParts();
            ArrayList<JRChild> oldSelection = new ArrayList<JRChild>();
            for (Object obj : selectedParts) {
                ANode model;
                EditPart part = (EditPart)obj;
                if (!(part.getModel() instanceof ANode) || !((model = (ANode)part.getModel()).getValue() instanceof JRDesignElement) && !(model.getValue() instanceof JRDesignBand)) continue;
                oldSelection.add((JRChild)model.getValue());
            }
            this.restoreSelectionCommand = new SelectElementCommand(oldSelection);
        }
    }

    protected void restoreSelection() {
        if (this.restoreSelection && this.restoreSelectionCommand != null) {
            this.restoreSelectionCommand.execute();
        }
    }

    public void execute() {
        if (this.size() > 0) {
            this.backupSelection();
            List<Command> commands = this.getCommands();
            this.setIgnoreEvents(true);
            int i = 0;
            while (i < this.size()) {
                Command cmd = commands.get(i);
                cmd.execute();
                ++i;
            }
            this.setIgnoreEvents(false);
            if (!this.isIgnoreEvents()) {
                this.refreshVisuals();
            }
            this.restoreSelection();
        }
    }

    public void undo() {
        if (this.size() > 0) {
            List<Command> commands = this.getCommands();
            this.setIgnoreEvents(true);
            int i = this.size() - 1;
            while (i >= 0) {
                commands.get(i).undo();
                --i;
            }
            this.setIgnoreEvents(false);
            if (!this.isIgnoreEvents()) {
                this.refreshVisuals();
            }
            if (this.restoreSelectionCommand != null) {
                this.restoreSelectionCommand.undo();
                this.restoreSelectionCommand = null;
            }
        }
    }

    public void redo() {
        if (this.size() > 0) {
            this.backupSelection();
            List<Command> commands = this.getCommands();
            this.setIgnoreEvents(true);
            int i = 0;
            while (i < this.size()) {
                commands.get(i).redo();
                ++i;
            }
            this.setIgnoreEvents(false);
            if (!this.isIgnoreEvents()) {
                this.refreshVisuals();
            }
            this.restoreSelection();
        }
    }

    public void addFirst(Command command) {
        List<Command> commands = this.getCommands();
        commands.add(0, command);
    }

    public void addAll(List<Command> commands) {
        this.getCommands().addAll(commands);
    }

    public List<Command> getCommands() {
        return super.getCommands();
    }

    public void enableSelectionRestore(boolean enabled) {
        this.restoreSelection = enabled;
    }
}

