/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.utils.XMLUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.jasperreports.eclipse.util.FileUtils;
import org.apache.commons.io.input.ReaderInputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.ITextContentDescriber;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class JrxmlContentDescriber
implements ITextContentDescriber {
    public int describe(InputStream contents, IContentDescription description) throws IOException {
        return JrxmlContentDescriber.validateStandardJRXML(contents);
    }

    public QualifiedName[] getSupportedOptions() {
        return null;
    }

    public int describe(Reader contents, IContentDescription description) throws IOException {
        try (ReaderInputStream contentsIS = null;){
            contentsIS = new ReaderInputStream(contents, "UTF-8");
            int n = JrxmlContentDescriber.validateStandardJRXML((InputStream)contentsIS);
            return n;
        }
    }

    public static boolean isStandardJRXML(InputStream contents) {
        try {
            int validationResult = JrxmlContentDescriber.validateStandardJRXML(contents);
            boolean bl = 2 == validationResult;
            return bl;
        }
        catch (IOException e) {
            JaspersoftStudioPlugin.getInstance().logError(e);
            return false;
        }
        finally {
            FileUtils.closeStream((Closeable)contents);
        }
    }

    public static boolean isStandardJRXML(IFile file) {
        try {
            return JrxmlContentDescriber.isStandardJRXML(file.getContents());
        }
        catch (CoreException e) {
            JaspersoftStudioPlugin.getInstance().logError(e);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int validateStandardJRXML(InputStream in) throws IOException {
        try {
            if (in.markSupported()) {
                try {
                    in.mark(0);
                    int firstRead = in.read();
                    if (firstRead == -1) {
                        return 0;
                    }
                }
                finally {
                    in.reset();
                }
            }
            Document document = XMLUtils.parseNoValidation(in);
            document.getDocumentElement().normalize();
            NodeList bookParts = document.getElementsByTagName("part");
            if (bookParts == null) return 2;
            if (bookParts.getLength() != 0) return 0;
            return 2;
        }
        catch (ParserConfigurationException e) {
            JaspersoftStudioPlugin.getInstance().logError(e);
            return 0;
        }
        catch (SAXException e) {
            JaspersoftStudioPlugin.getInstance().logError(e);
        }
        return 0;
    }
}

