/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.background;

import com.jaspersoft.studio.background.BackgroundFeedbackFigure;
import com.jaspersoft.studio.background.BackgroundImageFigure;
import com.jaspersoft.studio.background.BackgroundResizeHandles;
import com.jaspersoft.studio.background.MBackgrounImage;
import com.jaspersoft.studio.editor.JrxmlEditor;
import com.jaspersoft.studio.editor.gef.parts.RedrawingEditPolicy;
import com.jaspersoft.studio.editor.gef.parts.ReportPageEditPart;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.property.SetValueCommand;
import com.jaspersoft.studio.utils.SelectionHelper;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.tools.DragEditPartsTracker;
import org.eclipse.ui.IEditorPart;

public class BackgroundImageEditPart
extends AbstractGraphicalEditPart
implements PropertyChangeListener {
    protected IFigure createFigure() {
        MBackgrounImage model = (MBackgrounImage)this.getModel();
        BackgroundImageFigure figure = new BackgroundImageFigure(model);
        figure.setSize(model.getDefaultWidth(), model.getDefaultHeight());
        return figure;
    }

    public void activate() {
        super.activate();
        if (this.getModel() != null) {
            ((ANode)this.getModel()).getPropertyChangeSupport().addPropertyChangeListener(this);
        }
    }

    public void deactivate() {
        if (this.getModel() != null) {
            ((ANode)this.getModel()).getPropertyChangeSupport().removePropertyChangeListener(this);
        }
        super.deactivate();
    }

    protected void createEditPolicies() {
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new RedrawingEditPolicy(){

            protected Command getResizeCommand(ChangeBoundsRequest request) {
                MBackgrounImage model = (MBackgrounImage)BackgroundImageEditPart.this.getModel();
                this.getFeedbackLayer();
                Rectangle newBounds = this.getFeedbackSize(request);
                CompoundCommand cc = new CompoundCommand();
                SetValueCommand setCommand = new SetValueCommand();
                setCommand.setTarget(model);
                setCommand.setPropertyId("background.image.widht");
                setCommand.setPropertyValue(newBounds.width);
                cc.add((Command)setCommand);
                setCommand = new SetValueCommand();
                setCommand.setTarget(model);
                setCommand.setPropertyId("background.image.height");
                setCommand.setPropertyValue(newBounds.height);
                cc.add((Command)setCommand);
                int dir = request.getResizeDirection();
                if (dir == 1 || dir == 17 || dir == 9) {
                    int delta_y = model.getDefaultHeight() - newBounds.height;
                    int current_y = model.getDefaultY();
                    setCommand = new SetValueCommand();
                    setCommand.setTarget(model);
                    setCommand.setPropertyId("background.image.y");
                    setCommand.setPropertyValue(current_y + delta_y);
                    cc.add((Command)setCommand);
                }
                if (dir == 8 || dir == 12 || dir == 9) {
                    int delta_x = model.getDefaultWidth() - newBounds.width;
                    int current_x = model.getDefaultX();
                    setCommand = new SetValueCommand();
                    setCommand.setTarget(model);
                    setCommand.setPropertyId("background.image.x");
                    setCommand.setPropertyValue(current_x + delta_x);
                    cc.add((Command)setCommand);
                }
                return cc;
            }

            protected Command getMoveCommand(ChangeBoundsRequest request) {
                MBackgrounImage model = (MBackgrounImage)BackgroundImageEditPart.this.getModel();
                Rectangle oldBounds = model.getBounds();
                ZoomManager zoomMgr = (ZoomManager)BackgroundImageEditPart.this.getViewer().getProperty(ZoomManager.class.toString());
                Point delta = request.getMoveDelta().getScaled(1.0 / zoomMgr.getZoom());
                Rectangle newBounds = new Rectangle(oldBounds.x + delta.x, oldBounds.y + delta.y, oldBounds.width, oldBounds.height);
                CompoundCommand cc = new CompoundCommand();
                SetValueCommand setCommand = new SetValueCommand();
                setCommand.setTarget(model);
                setCommand.setPropertyId("background.image.x");
                setCommand.setPropertyValue(newBounds.x);
                cc.add((Command)setCommand);
                setCommand = new SetValueCommand();
                setCommand.setTarget(model);
                setCommand.setPropertyId("background.image.y");
                setCommand.setPropertyValue(newBounds.y);
                cc.add((Command)setCommand);
                return cc;
            }

            private Rectangle getFeedbackSize(ChangeBoundsRequest request) {
                MBackgrounImage model = (MBackgrounImage)BackgroundImageEditPart.this.getModel();
                Rectangle oldBounds = model.getBounds();
                PrecisionRectangle rect2 = new PrecisionRectangle(new Rectangle(request.getMoveDelta().x, request.getMoveDelta().y, request.getSizeDelta().width, request.getSizeDelta().height));
                this.getHostFigure().translateToRelative((Translatable)rect2);
                oldBounds.translate(rect2.x, rect2.y);
                oldBounds.resize(rect2.width, rect2.height);
                return oldBounds;
            }

            @Override
            protected void showChangeBoundsFeedback(ChangeBoundsRequest request) {
                if (!BackgroundImageEditPart.this.isImageEditable()) {
                    return;
                }
                IFigure feedback = this.getDragSourceFeedbackFigure();
                MBackgrounImage model = (MBackgrounImage)BackgroundImageEditPart.this.getModel();
                PrecisionRectangle rect = new PrecisionRectangle(this.getInitialFeedbackBounds().getCopy());
                this.getHostFigure().translateToAbsolute((Translatable)rect);
                rect.translate(request.getMoveDelta());
                rect.resize(request.getSizeDelta());
                String s = "";
                int scaleH = 0;
                int scaleW = 0;
                Rectangle oldBounds = this.getFeedbackSize(request);
                ZoomManager zoomMgr = (ZoomManager)BackgroundImageEditPart.this.getViewer().getProperty(ZoomManager.class.toString());
                Point delta = request.getMoveDelta().getScaled(1.0 / zoomMgr.getZoom());
                Rectangle currentBounds = model.getBounds();
                s = String.valueOf(s) + (currentBounds.x + delta.x) + ", " + (model.getBounds().y + delta.y) + ", " + oldBounds.width + ", " + oldBounds.height;
                if (oldBounds.width != 0) {
                    scaleW = rect.width / oldBounds.width - 1;
                }
                if (oldBounds.height != 0) {
                    scaleH = rect.height / oldBounds.height - 1;
                }
                feedback.translateToRelative((Translatable)rect);
                ((BackgroundFeedbackFigure)feedback).setText(s);
                feedback.setBounds(rect.resize(-scaleW, -scaleH));
                super.showChangeBoundsFeedback(request);
            }

            protected IFigure createDragSourceFeedbackFigure() {
                BackgroundFeedbackFigure r = new BackgroundFeedbackFigure();
                r.setLineStyle(3);
                r.setForegroundColor(ColorConstants.black);
                r.setBounds(this.getInitialFeedbackBounds().resize(-1, -1));
                this.addFeedback((IFigure)r);
                return r;
            }

            protected void showSelection() {
                if (BackgroundImageEditPart.this.isImageEditable()) {
                    this.addSelectionHandles();
                }
            }

            protected void createResizeHandle(List handles, int direction) {
                BackgroundResizeHandles handle = new BackgroundResizeHandles((GraphicalEditPart)this.getHost(), direction);
                handle.setDragTracker((DragTracker)this.getResizeTracker(direction));
                handle.setCursor(Cursors.getDirectionalCursor((int)direction, (boolean)this.getHostFigure().isMirrored()));
                handles.add(handle);
            }
        });
    }

    private boolean isImageEditable() {
        IEditorPart currentEditor = SelectionHelper.getActiveJRXMLEditor();
        if (currentEditor instanceof JrxmlEditor) {
            return ((JrxmlEditor)currentEditor).getReportContainer().isBackgroundImageEditable();
        }
        return false;
    }

    public DragTracker getDragTracker(Request request) {
        if (!this.isImageEditable()) {
            return null;
        }
        return new DragEditPartsTracker((EditPart)this){

            protected EditPart getTargetEditPart() {
                EditPart currentPart = super.getTargetEditPart();
                while (currentPart != null && !(currentPart instanceof ReportPageEditPart)) {
                    currentPart = currentPart.getParent();
                }
                return currentPart;
            }

            protected void performSelection() {
                if (BackgroundImageEditPart.this.isSelectable()) {
                    super.performSelection();
                }
            }
        };
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }
}

