/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.background;

import com.jaspersoft.studio.background.MBackgrounImage;
import com.jaspersoft.studio.editor.gef.figures.ComponentFigure;
import com.jaspersoft.studio.editor.gef.parts.JSSScalableFreeformRootEditPart;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.ui.progress.WorkbenchJob;
import org.eclipse.wb.swt.ResourceManager;

public class BackgroundImageFigure
extends RectangleFigure {
    protected static int MAXIMUM_WIDTH = 8000;
    protected static int MAXIMUM_HEIGHT = 8000;
    private boolean showBackgroundImage = true;
    private MBackgrounImage model;
    private BufferedImage image = null;
    private Map<String, Image> scaledImages = new HashMap<String, Image>();
    private String lastPath = null;
    private ZoomManager zoomManager;
    private UpdatePanelJob updatePanelJob = null;
    private static final int UPDATE_DELAY = 500;

    public BackgroundImageFigure(MBackgrounImage model) {
        this.model = model;
        this.setOutline(false);
        ToolbarLayout layout = new ToolbarLayout(false);
        layout.setMinorAlignment(0);
        layout.setSpacing(5);
        this.setLayoutManager((LayoutManager)layout);
        this.setBackgroundColor(ResourceManager.getColor((int)255, (int)255, (int)255));
        this.loadImage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadImage() {
        String path = (String)this.model.getPropertyValue("background.image.path");
        BackgroundImageFigure backgroundImageFigure = this;
        synchronized (backgroundImageFigure) {
            if (this.updatePanelJob != null) {
                this.updatePanelJob.cancel();
                this.updatePanelJob = null;
            }
            if (path == null) {
                this.image = null;
                this.lastPath = null;
                this.scaledImages.clear();
            } else if (!path.equals(this.lastPath)) {
                BufferedImage img = null;
                this.scaledImages.clear();
                try {
                    img = ImageIO.read(new File(path));
                    this.lastPath = path;
                }
                catch (IOException iOException) {}
                this.image = img;
            }
        }
    }

    public void paint(Graphics graphics) {
        this.loadImage();
        this.updateSize();
        Graphics2D graphics2d = ComponentFigure.getG2D(graphics);
        if (this.image != null) {
            int scaledWidth;
            int scaledHeight;
            Composite oldComposite = graphics2d.getComposite();
            float alpha = this.model.getAlpha();
            int type = 3;
            AlphaComposite composite = AlphaComposite.getInstance(type, alpha);
            graphics2d.setComposite(composite);
            if (this.model.isKeepRatio()) {
                Point ratioSize = this.calculateWidestRation();
                scaledHeight = ratioSize.y;
                scaledWidth = ratioSize.x;
            } else {
                scaledWidth = this.getSize().width;
                scaledHeight = this.getSize().height;
            }
            graphics2d.drawImage(this.getScaledImage(scaledWidth, scaledHeight), this.getLocation().x, this.getLocation().y, scaledWidth, scaledHeight, null);
            graphics2d.setComposite(oldComposite);
        }
    }

    private void updateSize() {
        this.setSize(this.model.getDefaultWidth(), this.model.getDefaultHeight());
        this.setLocation(new Point(this.model.getDefaultX(), this.model.getDefaultY()));
    }

    protected double getZoom() {
        if (this.zoomManager == null) {
            EditPartViewer viewer = this.model.getFigureEditPart().getViewer();
            this.zoomManager = (ZoomManager)viewer.getProperty(ZoomManager.class.toString());
            if (this.zoomManager == null) {
                this.zoomManager = ((JSSScalableFreeformRootEditPart)viewer.getRootEditPart()).getZoomManager();
            }
        }
        return this.zoomManager != null ? this.zoomManager.getZoom() : 1.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Image getScaledImage(int width, int height) {
        Dimension zoomedSize = this.getZoomedImage(width, height);
        BackgroundImageFigure backgroundImageFigure = this;
        synchronized (backgroundImageFigure) {
            Image scaledImage = this.scaledImages.get(this.getImageKey(zoomedSize.width, zoomedSize.height));
            if (scaledImage == null) {
                if (this.updatePanelJob == null) {
                    this.updatePanelJob = new UpdatePanelJob(zoomedSize.width, zoomedSize.height);
                    this.updatePanelJob.schedule(500L);
                } else if (this.updatePanelJob.width != zoomedSize.width || this.updatePanelJob.height != zoomedSize.height) {
                    this.updatePanelJob.cancel();
                    this.updatePanelJob = new UpdatePanelJob(zoomedSize.width, zoomedSize.height);
                    this.updatePanelJob.schedule(500L);
                }
                return this.image;
            }
            return scaledImage;
        }
    }

    private String getImageKey(int width, int height) {
        return String.valueOf(String.valueOf(width)) + "-" + String.valueOf(height);
    }

    protected Dimension getZoomedImage(int width, int height) {
        double zoom = this.getZoom();
        double zoomedWidth = (double)width * zoom;
        double zoomedHeight = (double)height * zoom;
        if (zoomedWidth > (double)MAXIMUM_WIDTH && zoomedHeight > (double)MAXIMUM_HEIGHT) {
            if (zoomedWidth > zoomedHeight) {
                zoomedHeight = zoomedHeight * (double)MAXIMUM_WIDTH / zoomedWidth;
                zoomedWidth = MAXIMUM_WIDTH;
            } else {
                zoomedWidth = zoomedWidth * (double)MAXIMUM_HEIGHT / zoomedHeight;
                zoomedHeight = MAXIMUM_HEIGHT;
            }
        }
        while (zoomedWidth > (double)MAXIMUM_WIDTH || zoomedHeight > (double)MAXIMUM_HEIGHT) {
            if (zoomedWidth > (double)MAXIMUM_WIDTH) {
                zoomedHeight = zoomedHeight * (double)MAXIMUM_WIDTH / zoomedWidth;
                zoomedWidth = MAXIMUM_WIDTH;
                continue;
            }
            zoomedWidth = zoomedWidth * (double)MAXIMUM_HEIGHT / zoomedHeight;
            zoomedHeight = MAXIMUM_HEIGHT;
        }
        return new Dimension((int)Math.round(zoomedWidth), (int)Math.round(zoomedHeight));
    }

    private Point calculateWidestRation() {
        int originalWidth = this.image.getWidth(null);
        int originalHeight = this.image.getHeight(null);
        int maxWidth = this.getSize().width;
        int maxHeight = this.getSize().height;
        int newWidth1 = Math.round((float)(originalWidth * maxHeight) / (float)originalHeight);
        int newHeight1 = maxHeight;
        int newHeight2 = Math.round((float)originalHeight * (float)maxWidth / (float)originalWidth);
        int newWidth2 = maxWidth;
        if (newWidth1 > maxWidth) {
            return new Point(newWidth2, newHeight2);
        }
        if (newHeight2 > maxHeight) {
            return new Point(newWidth1, newHeight1);
        }
        if (newWidth1 * newHeight1 > newWidth2 * newHeight2) {
            return new Point(newWidth1, newHeight1);
        }
        return new Point(newWidth2, newHeight2);
    }

    public boolean isVisible() {
        this.loadImage();
        return this.image != null && this.showBackgroundImage;
    }

    protected void setModel(MBackgrounImage model) {
        this.lastPath = null;
        this.image = null;
        this.model = model;
    }

    public boolean hasImage() {
        this.loadImage();
        return this.image != null;
    }

    public boolean isBackgroundImageVisible() {
        return this.showBackgroundImage;
    }

    public void setBackgroundImageVisible(boolean value) {
        this.showBackgroundImage = value;
    }

    private BufferedImage resizeImageWithHint(BufferedImage originalImage, int imageNewWidth, int imageNewHeight) {
        int width = imageNewWidth;
        int height = imageNewHeight;
        BufferedImage resizedImage = new BufferedImage(width, height, 2);
        Graphics2D g = resizedImage.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setComposite(AlphaComposite.Src);
        g.drawImage(originalImage, 0, 0, width, height, null);
        g.dispose();
        return resizedImage;
    }

    private class UpdatePanelJob
    extends WorkbenchJob {
        private int width;
        private int height;

        public UpdatePanelJob(int width, int height) {
            super("Update Scaled Image");
            this.setSystem(true);
            this.width = width;
            this.height = height;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus runInUIThread(IProgressMonitor monitor) {
            try {
                try {
                    BufferedImage newImage = BackgroundImageFigure.this.resizeImageWithHint(BackgroundImageFigure.this.image, this.width, this.height);
                    BackgroundImageFigure backgroundImageFigure = BackgroundImageFigure.this;
                    synchronized (backgroundImageFigure) {
                        if (!monitor.isCanceled()) {
                            BackgroundImageFigure.this.scaledImages.put(BackgroundImageFigure.this.getImageKey(this.width, this.height), newImage);
                        }
                    }
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    MAXIMUM_WIDTH -= MAXIMUM_WIDTH / 10;
                    MAXIMUM_HEIGHT -= MAXIMUM_HEIGHT / 10;
                    BackgroundImageFigure.this.updatePanelJob = null;
                    BackgroundImageFigure.this.model.getFigureEditPart().refresh();
                }
            }
            finally {
                BackgroundImageFigure.this.updatePanelJob = null;
                BackgroundImageFigure.this.model.getFigureEditPart().refresh();
            }
            return Status.OK_STATUS;
        }
    }
}

