/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.background;

import com.jaspersoft.studio.background.BackgroundImageEditPart;
import com.jaspersoft.studio.background.JSSBackgroundPixelLocationValidator;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.DefaultValue;
import com.jaspersoft.studio.model.IGraphicElement;
import com.jaspersoft.studio.model.util.IIconDescriptor;
import com.jaspersoft.studio.property.descriptor.checkbox.CheckBoxPropertyDescriptor;
import com.jaspersoft.studio.property.descriptors.PixelPropertyDescriptor;
import com.jaspersoft.studio.property.descriptors.TransparencyPropertyDescriptor;
import com.jaspersoft.studio.property.section.AbstractSection;
import com.jaspersoft.studio.property.section.widgets.ASPropertyWidget;
import com.jaspersoft.studio.property.section.widgets.SPPixel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class MBackgrounImage
extends APropertyNode
implements IGraphicElement {
    public static final String PROPERTY_ALPHA = "background.image.alpha";
    public static final String PROPERTY_PATH = "background.image.path";
    public static final String PROPERTY_WIDTH = "background.image.widht";
    public static final String PROPERTY_HEIGHT = "background.image.height";
    public static final String PROPERTY_X = "background.image.x";
    public static final String PROPERTY_Y = "background.image.y";
    public static final String PROPERTY_KEEP_RATIO = "background.image.keep_ratio";
    private IPropertyDescriptor[] descriptors;
    private String lastPath;
    private ImageData lastImageData;
    private static final long serialVersionUID = 757632360685857870L;

    public MBackgrounImage(ANode parent) {
        super(parent, -1);
        this.setValue(this.getJasperDesign());
    }

    public static IIconDescriptor getIconDescriptor() {
        return null;
    }

    @Override
    public ImageDescriptor getImagePath() {
        return null;
    }

    @Override
    public String getDisplayText() {
        return "Background";
    }

    @Override
    public String getToolTip() {
        return "Image shown on the background";
    }

    @Override
    public IPropertyDescriptor[] getDescriptors() {
        return this.descriptors;
    }

    @Override
    public void setDescriptors(IPropertyDescriptor[] descriptors1) {
        this.descriptors = descriptors1;
    }

    @Override
    public void createPropertyDescriptors(List<IPropertyDescriptor> desc) {
        JSSBackgroundPixelLocationValidator heightValidator = new JSSBackgroundPixelLocationValidator(PROPERTY_HEIGHT);
        heightValidator.setTargetNode(this);
        PixelPropertyDescriptor heightD = new PixelPropertyDescriptor(PROPERTY_HEIGHT, Messages.common_height);
        heightD.setCategory(Messages.common_size);
        heightD.setDescription(Messages.MGraphicElement_height_description);
        heightD.setValidator(heightValidator);
        desc.add((IPropertyDescriptor)heightD);
        JSSBackgroundPixelLocationValidator widthValidator = new JSSBackgroundPixelLocationValidator(PROPERTY_WIDTH);
        widthValidator.setTargetNode(this);
        PixelPropertyDescriptor widthD = new PixelPropertyDescriptor(PROPERTY_WIDTH, Messages.MGraphicElement_width);
        widthD.setCategory(Messages.common_size);
        widthD.setDescription(Messages.MGraphicElement_width_description);
        widthD.setValidator(widthValidator);
        desc.add((IPropertyDescriptor)widthD);
        JSSBackgroundPixelLocationValidator xValidator = new JSSBackgroundPixelLocationValidator(PROPERTY_X);
        xValidator.setTargetNode(this);
        PixelPropertyDescriptor xD = new PixelPropertyDescriptor(PROPERTY_X, Messages.common_left){

            @Override
            public ASPropertyWidget<PixelPropertyDescriptor> createWidget(Composite parent, AbstractSection section) {
                SPPixel spNumber = new SPPixel(parent, section, this){

                    @Override
                    protected int getPixelOffset() {
                        return -10;
                    }
                };
                return spNumber;
            }
        };
        xD.setCategory(Messages.MGraphicElement_location_category);
        xD.setDescription(Messages.MGraphicElement_left_description);
        xD.setValidator(xValidator);
        desc.add((IPropertyDescriptor)xD);
        JSSBackgroundPixelLocationValidator yValidator = new JSSBackgroundPixelLocationValidator(PROPERTY_Y);
        yValidator.setTargetNode(this);
        PixelPropertyDescriptor yD = new PixelPropertyDescriptor(PROPERTY_Y, Messages.common_top){

            @Override
            public ASPropertyWidget<PixelPropertyDescriptor> createWidget(Composite parent, AbstractSection section) {
                SPPixel spNumber = new SPPixel(parent, section, this){

                    @Override
                    protected int getPixelOffset() {
                        return -10;
                    }
                };
                return spNumber;
            }
        };
        yD.setCategory(Messages.MGraphicElement_location_category);
        yD.setDescription(Messages.MGraphicElement_top_description);
        yD.setValidator(yValidator);
        desc.add((IPropertyDescriptor)yD);
        TransparencyPropertyDescriptor transparency = new TransparencyPropertyDescriptor(PROPERTY_ALPHA, Messages.MBackgrounImage_labelTransparency);
        transparency.setCategory(Messages.MBackgrounImage_labelCategory);
        transparency.setDescription(Messages.MBackgrounImage_descriptionTransparency);
        desc.add((IPropertyDescriptor)transparency);
        CheckBoxPropertyDescriptor keepRatio = new CheckBoxPropertyDescriptor(PROPERTY_KEEP_RATIO, Messages.MBackgrounImage_labelKeepRatio);
        keepRatio.setCategory(Messages.MBackgrounImage_labelCategory);
        keepRatio.setDescription(Messages.MBackgrounImage_descriptionKeepRatio);
        desc.add((IPropertyDescriptor)keepRatio);
    }

    @Override
    protected Map<String, DefaultValue> createDefaultsMap() {
        Map<String, DefaultValue> defaultsMap = super.createDefaultsMap();
        defaultsMap.put(PROPERTY_KEEP_RATIO, new DefaultValue(false, false));
        defaultsMap.put(PROPERTY_ALPHA, new DefaultValue(Float.valueOf(0.5f), false));
        defaultsMap.put(PROPERTY_HEIGHT, new DefaultValue(100, false));
        defaultsMap.put(PROPERTY_WIDTH, new DefaultValue(100, false));
        defaultsMap.put(PROPERTY_X, new DefaultValue(10, false));
        defaultsMap.put(PROPERTY_Y, new DefaultValue(10, false));
        return defaultsMap;
    }

    public Object getPropertyValue(Object id) {
        JasperDesign jrObj = this.getValue();
        if (id.equals(PROPERTY_ALPHA)) {
            String value = jrObj.getProperty(PROPERTY_ALPHA);
            if (value == null) {
                return null;
            }
            return Float.valueOf(Float.parseFloat(value));
        }
        if (id.equals(PROPERTY_PATH)) {
            return jrObj.getProperty(PROPERTY_PATH);
        }
        if (id.equals(PROPERTY_X)) {
            String value = jrObj.getProperty(PROPERTY_X);
            if (value == null) {
                return 10;
            }
            return Integer.parseInt(value);
        }
        if (id.equals(PROPERTY_Y)) {
            String value = jrObj.getProperty(PROPERTY_Y);
            if (value == null) {
                return 10;
            }
            return Integer.parseInt(value);
        }
        if (id.equals(PROPERTY_HEIGHT)) {
            String value = jrObj.getProperty(PROPERTY_HEIGHT);
            if (value == null) {
                ImageData image = this.getImageData();
                if (image != null) {
                    return image.height;
                }
                return 100;
            }
            return Integer.parseInt(value);
        }
        if (id.equals(PROPERTY_WIDTH)) {
            String value = jrObj.getProperty(PROPERTY_WIDTH);
            if (value == null) {
                ImageData image = this.getImageData();
                if (image != null) {
                    return image.width;
                }
                return 100;
            }
            return Integer.parseInt(value);
        }
        if (id.equals(PROPERTY_KEEP_RATIO)) {
            String value = jrObj.getProperty(PROPERTY_KEEP_RATIO);
            if (value == null) {
                return null;
            }
            return Boolean.parseBoolean(value);
        }
        return null;
    }

    public void setPropertyValue(Object id, Object value) {
        JasperDesign jrObj = this.getValue();
        if (id.equals(PROPERTY_ALPHA)) {
            jrObj.setProperty(PROPERTY_ALPHA, Float.toString(((Float)value).floatValue()));
        } else if (id.equals(PROPERTY_PATH)) {
            if (value == null) {
                jrObj.removeProperty(PROPERTY_PATH);
            } else {
                jrObj.setProperty(PROPERTY_PATH, (String)value);
            }
        } else if (id.equals(PROPERTY_X)) {
            jrObj.setProperty(PROPERTY_X, Integer.toString((Integer)value));
        } else if (id.equals(PROPERTY_Y)) {
            jrObj.setProperty(PROPERTY_Y, Integer.toString((Integer)value));
        } else if (id.equals(PROPERTY_HEIGHT)) {
            jrObj.setProperty(PROPERTY_HEIGHT, Integer.toString((Integer)value));
        } else if (id.equals(PROPERTY_WIDTH)) {
            jrObj.setProperty(PROPERTY_WIDTH, Integer.toString((Integer)value));
        } else if (id.equals(PROPERTY_KEEP_RATIO)) {
            jrObj.setProperty(PROPERTY_KEEP_RATIO, Boolean.toString((Boolean)value));
        }
    }

    protected ImageData getImageData() {
        String fileName = (String)this.getPropertyValue(PROPERTY_PATH);
        if (fileName == null) {
            return null;
        }
        if (fileName.equals(this.lastPath)) {
            return this.lastImageData;
        }
        this.lastPath = fileName;
        this.lastImageData = null;
        try {
            FileInputStream stream = new FileInputStream(fileName);
            Image tempImage = new Image(null, (InputStream)stream);
            this.lastImageData = tempImage.getImageData();
            tempImage.dispose();
            stream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.lastImageData;
    }

    public float getAlpha() {
        Float alpha = (Float)this.getPropertyValue(PROPERTY_ALPHA);
        if (alpha != null) {
            return alpha.floatValue();
        }
        return 0.5f;
    }

    @Override
    public Rectangle getBounds() {
        return new Rectangle(this.getDefaultX(), this.getDefaultY(), this.getDefaultWidth(), this.getDefaultHeight());
    }

    @Override
    public int getDefaultWidth() {
        return (Integer)this.getPropertyValue(PROPERTY_WIDTH);
    }

    @Override
    public int getDefaultHeight() {
        return (Integer)this.getPropertyValue(PROPERTY_HEIGHT);
    }

    public int getDefaultX() {
        return (Integer)this.getPropertyValue(PROPERTY_X);
    }

    public int getDefaultY() {
        return (Integer)this.getPropertyValue(PROPERTY_Y);
    }

    public boolean isKeepRatio() {
        Boolean keepRatio = (Boolean)this.getPropertyValue(PROPERTY_KEEP_RATIO);
        if (keepRatio != null) {
            return keepRatio;
        }
        return false;
    }

    @Override
    public JRDesignElement createJRElement(JasperDesign jasperDesign) {
        return null;
    }

    @Override
    public EditPart getFigureEditPart() {
        PropertyChangeListener[] propertyChangeListenerArray = this.getPropertyChangeSupport().getPropertyChangeListeners();
        int n = propertyChangeListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyChangeListener o = propertyChangeListenerArray[n2];
            if (o instanceof BackgroundImageEditPart) {
                return (EditPart)o;
            }
            ++n2;
        }
        return null;
    }

    public JasperDesign getValue() {
        return (JasperDesign)super.getValue();
    }

    @Override
    public void setValue(Object value) {
        JRPropertiesMap pmap;
        JRDesignDataset jrDesignDataset;
        JasperDesign jasperDesign;
        if (this.getValue() != null) {
            jasperDesign = this.getValue();
            jrDesignDataset = (JRDesignDataset)jasperDesign.getMainDataset();
            pmap = jrDesignDataset.getPropertiesMap();
            pmap.getEventSupport().removePropertyChangeListener((PropertyChangeListener)this);
        }
        if (value != null) {
            jasperDesign = (JasperDesign)value;
            jrDesignDataset = (JRDesignDataset)jasperDesign.getMainDataset();
            pmap = jrDesignDataset.getPropertiesMap();
            pmap.getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
        }
        super.setValue(value);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        EditPart figureEditPart = this.getFigureEditPart();
        if (figureEditPart != null) {
            figureEditPart.refresh();
        }
        if (PROPERTY_ALPHA.equals(evt.getPropertyName()) || PROPERTY_PATH.equals(evt.getPropertyName()) || PROPERTY_WIDTH.equals(evt.getPropertyName()) || PROPERTY_HEIGHT.equals(evt.getPropertyName()) || PROPERTY_X.equals(evt.getPropertyName()) || PROPERTY_Y.equals(evt.getPropertyName()) || PROPERTY_KEEP_RATIO.equals(evt.getPropertyName())) {
            this.firePropertyChange(evt);
        }
    }
}

