/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.background.commands;

import com.jaspersoft.studio.background.BackgroundImageFigure;
import com.jaspersoft.studio.editor.JrxmlEditor;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.utils.SelectionHelper;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IEditorPart;

public class SelectBackgroundHandler
extends AbstractHandler {
    private static final String[] FILTER_EXTS = new String[]{"*.jpg", "*.png", "*.bmp", "*.*"};

    public Object execute(ExecutionEvent event) throws ExecutionException {
        JrxmlEditor jrxmlEditor;
        Object value;
        IEditorPart editor;
        FileDialog dialog = new FileDialog(UIUtils.getShell());
        dialog.setText(Messages.MBackgrounImage_imageDialogTitle);
        String homefolder = System.getProperty("user.home");
        dialog.setFilterPath(homefolder);
        dialog.setFilterExtensions(FILTER_EXTS);
        String path = dialog.open();
        if (path != null && (editor = SelectionHelper.getActiveJRXMLEditor()) instanceof JrxmlEditor && (value = (jrxmlEditor = (JrxmlEditor)editor).getReportContainer().getModel().getValue()) instanceof JasperDesign) {
            JasperDesign jd = (JasperDesign)value;
            this.setFigureVisible();
            jrxmlEditor.getReportContainer().setBackgroundImageEditable(false);
            jd.setProperty("background.image.path", path);
        }
        return null;
    }

    protected void setFigureVisible() {
        EditPart backgroundPart = SelectionHelper.getBackgroundEditPart();
        if (backgroundPart != null) {
            BackgroundImageFigure figure = (BackgroundImageFigure)((AbstractGraphicalEditPart)backgroundPart).getFigure();
            figure.setBackgroundImageVisible(true);
        }
    }

    public boolean isEnabled() {
        IEditorPart currentEditor = SelectionHelper.getActiveJRXMLEditor();
        return currentEditor instanceof JrxmlEditor;
    }
}

