/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.background.commands;

import com.jaspersoft.studio.background.BackgroundImageFigure;
import com.jaspersoft.studio.editor.JrxmlEditor;
import com.jaspersoft.studio.editor.report.ReportContainer;
import com.jaspersoft.studio.utils.SelectionHelper;
import java.util.Map;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.UIElement;

public class ShowBackgroundHandler
extends AbstractHandler
implements IElementUpdater {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        BackgroundImageFigure figure = this.getBackgroundFigure();
        if (figure != null) {
            figure.setBackgroundImageVisible(!figure.isBackgroundImageVisible());
            ReportContainer currentContainer = this.getReportContainer();
            if (currentContainer != null) {
                Object value;
                if (!figure.isBackgroundImageVisible()) {
                    currentContainer.setBackgroundImageEditable(false);
                    SelectionHelper.deselectBackground();
                }
                if ((value = currentContainer.getModel().getValue()) instanceof JasperDesign) {
                    JasperDesign jd = (JasperDesign)value;
                    jd.getEventSupport().firePropertyChange("value", !figure.isBackgroundImageVisible(), figure.isBackgroundImageVisible());
                }
            }
        }
        return null;
    }

    public void updateElement(UIElement element, Map parameters) {
        BackgroundImageFigure figure = this.getBackgroundFigure();
        if (figure != null) {
            element.setChecked(figure.isBackgroundImageVisible());
        }
    }

    protected BackgroundImageFigure getBackgroundFigure() {
        EditPart backgroundPart = SelectionHelper.getBackgroundEditPart();
        if (backgroundPart != null) {
            return (BackgroundImageFigure)((AbstractGraphicalEditPart)backgroundPart).getFigure();
        }
        return null;
    }

    protected ReportContainer getReportContainer() {
        IEditorPart currentEditor = SelectionHelper.getActiveJRXMLEditor();
        if (currentEditor instanceof JrxmlEditor) {
            JrxmlEditor editor = (JrxmlEditor)currentEditor;
            ReportContainer currentContainer = editor.getReportContainer();
            return currentContainer;
        }
        return null;
    }

    public boolean isEnabled() {
        EditPart part;
        IEditorPart currentEditor = SelectionHelper.getActiveJRXMLEditor();
        if (currentEditor instanceof JrxmlEditor && (part = SelectionHelper.getBackgroundEditPart()) != null) {
            BackgroundImageFigure figure = (BackgroundImageFigure)((AbstractGraphicalEditPart)part).getFigure();
            return figure.hasImage();
        }
        return false;
    }
}

