/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.backward.wizard;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.backward.JRBackwardManager;
import com.jaspersoft.studio.backward.wizard.JRVersionPathDialog;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.swt.widgets.table.DeleteButton;
import com.jaspersoft.studio.swt.widgets.table.EditButton;
import com.jaspersoft.studio.swt.widgets.table.IEditElement;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.eclipse.builder.JRDefinition;
import net.sf.jasperreports.eclipse.ui.ATitledDialog;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.apache.commons.io.FileUtils;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public class JRRuntimeDialog
extends ATitledDialog {
    private TableViewer viewer;

    public JRRuntimeDialog(Shell parentShell) {
        super(parentShell);
        this.setTitle(Messages.ShowInstallationsWizardPage_pageTitle);
        this.setDescription(Messages.ShowInstallationsWizardPage_pageDescription);
        this.setDefaultSize(700, 450);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected Control createDialogArea(final Composite parent) {
        Composite cmp = (Composite)super.createDialogArea(parent);
        cmp.setLayout((Layout)new GridLayout(2, false));
        this.viewer = new TableViewer(cmp, 68354);
        this.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                JRDefinition t1 = (JRDefinition)e1;
                JRDefinition t2 = (JRDefinition)e2;
                return -t1.getVersion().compareTo(t2.getVersion());
            }
        });
        TableViewerColumn colFirstName = new TableViewerColumn(this.viewer, 0);
        colFirstName.getColumn().setWidth(100);
        colFirstName.getColumn().setText(Messages.JRVersionPage_1);
        colFirstName.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((JRDefinition)element).getVersion();
            }
        });
        colFirstName = new TableViewerColumn(this.viewer, 0);
        colFirstName.getColumn().setWidth(1000);
        colFirstName.getColumn().setText(Messages.JRVersionPage_2);
        colFirstName.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((JRDefinition)element).getResourceURL();
            }
        });
        Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        GridData gd = new GridData(1808);
        gd.widthHint = 300;
        gd.heightHint = 300;
        table.setLayoutData((Object)gd);
        Composite c = new Composite(cmp, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        c.setLayout((Layout)layout);
        gd = new GridData(2);
        gd.widthHint = 140;
        c.setLayoutData((Object)gd);
        Button bPath = new Button(c, 8);
        bPath.setText(Messages.JRVersionPage_4);
        bPath.setLayoutData((Object)new GridData(770));
        bPath.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JRVersionPathDialog d = new JRVersionPathDialog(parent.getShell(), new JRDefinition("", ""));
                if (d.open() == 0) {
                    JRDefinition newDefinition = d.getValue();
                    JRRuntimeDialog.this.setVersion(newDefinition);
                    JRRuntimeDialog.this.viewer.refresh();
                    JRRuntimeDialog.this.viewer.setSelection((ISelection)new StructuredSelection((Object)newDefinition));
                    JRRuntimeDialog.this.viewer.reveal((Object)newDefinition);
                    JRBackwardManager.copyJRToolkitUtility(new File(newDefinition.getResourceURL()));
                    JRRuntimeDialog.this.save();
                }
            }
        });
        EditButton<JRDefinition> eb = new EditButton<JRDefinition>(){

            @Override
            public void setEnabled(boolean enable) {
                StructuredSelection s = (StructuredSelection)JRRuntimeDialog.this.viewer.getSelection();
                if (s.isEmpty()) {
                    enable = false;
                } else {
                    String rurl = ((JRDefinition)s.getFirstElement()).getResourceURL();
                    if (enable && (rurl.equals(Messages.JRVersionPage_5) || rurl.startsWith(String.valueOf(JRBackwardManager.storage.getAbsolutePath()) + "/"))) {
                        enable = false;
                    }
                }
                super.setEnabled(enable);
            }

            @Override
            protected void afterElementModified(JRDefinition element, List<JRDefinition> inlist, int ind) {
                JRRuntimeDialog.this.save();
            }
        };
        eb.createEditButtons(c, this.viewer, new IEditElement<JRDefinition>(){

            @Override
            public void editElement(List<JRDefinition> input, int pos) {
                JRVersionPathDialog d = new JRVersionPathDialog(parent.getShell(), input.get(pos));
                if (d.open() == 0) {
                    JRRuntimeDialog.this.setVersion(d.getValue());
                }
            }
        });
        eb.editOnDoubleClick();
        new DeleteButton(){

            @Override
            protected boolean canRemove(Object obj) {
                if (((JRDefinition)obj).getResourceURL().equals(Messages.JRVersionPage_5)) {
                    return false;
                }
                return super.canRemove(obj);
            }

            @Override
            protected void afterElementDeleted(Object element) {
                File f;
                JRDefinition d = (JRDefinition)element;
                if (d.getResourceURL().startsWith(String.valueOf(JRBackwardManager.storage.getAbsolutePath()) + "/") && (f = new File(d.getResourceURL())).exists()) {
                    try {
                        FileUtils.deleteDirectory((File)f);
                    }
                    catch (IOException e) {
                        UIUtils.showError((Throwable)e);
                    }
                }
                JRRuntimeDialog.this.save();
            }
        }.createDeleteButton(c, this.viewer);
        this.fill();
        return cmp;
    }

    private void setVersion(JRDefinition d) {
        List vals = (List)this.viewer.getInput();
        int i = 0;
        while (i < vals.size()) {
            if (((JRDefinition)vals.get(i)).getVersion().equals(d.getVersion())) {
                vals.set(i, d);
                return;
            }
            ++i;
        }
        vals.add(d);
    }

    private void fill() {
        ArrayList<JRDefinition> values = new ArrayList<JRDefinition>();
        values.add(new JRDefinition(Messages.JRVersionPage_5, JasperDesign.class.getPackage().getImplementationVersion()));
        values.addAll(JRRuntimeDialog.getJRDefinitions());
        this.viewer.setInput(values);
    }

    public static List<JRDefinition> getJRDefinitions() {
        List<Object> list = new ArrayList<JRDefinition>();
        IPreferenceStore pstore = JaspersoftStudioPlugin.getInstance().getPreferenceStore();
        String versions = pstore.getString("com.jaspersoft.studio.jr.runtime.versions");
        if (!Misc.isNullOrEmpty((String)versions)) {
            ObjectMapper mapper = new ObjectMapper();
            try {
                list = (List)mapper.readValue(versions, (TypeReference)new TypeReference<List<JRDefinition>>(){});
            }
            catch (JsonParseException e) {
                e.printStackTrace();
            }
            catch (JsonMappingException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    public List<JRDefinition> getVersions() {
        ArrayList<JRDefinition> list = new ArrayList<JRDefinition>();
        int i = 0;
        while (i < ((List)this.viewer.getInput()).size()) {
            JRDefinition d = (JRDefinition)this.viewer.getElementAt(i);
            if (!d.getResourceURL().equals(Messages.JRVersionPage_5)) {
                list.add(d);
            }
            ++i;
        }
        return list;
    }

    private void save() {
        IPreferenceStore pstore = JaspersoftStudioPlugin.getInstance().getPreferenceStore();
        try {
            String v = new ObjectMapper().writeValueAsString(this.getVersions());
            pstore.setValue("com.jaspersoft.studio.jr.runtime.versions", v);
        }
        catch (JsonParseException e) {
            e.printStackTrace();
        }
        catch (JsonMappingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

