/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.callout;

import com.jaspersoft.studio.callout.CalloutEditPart;
import com.jaspersoft.studio.callout.MCallout;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.ZoomListener;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.CellEditorActionHandler;

public class CalloutEditManager
extends DirectEditManager {
    private IActionBars actionBars;
    private MCallout textElement;
    private CellEditorActionHandler actionHandler;
    private IAction copy;
    private IAction cut;
    private IAction paste;
    private IAction undo;
    private IAction redo;
    private IAction find;
    private IAction selectAll;
    private IAction delete;
    private Font scaledFont;
    private ZoomListener zoomListener = new ZoomListener(){

        public void zoomChanged(double newZoom) {
            CalloutEditManager.this.updateScaledFont(newZoom, CalloutEditManager.this.textElement);
        }
    };

    public CalloutEditManager(GraphicalEditPart source, CellEditorLocator locator) {
        super(source, null, locator);
    }

    protected void bringDown() {
        ZoomManager zoomMgr = (ZoomManager)this.getEditPart().getViewer().getProperty(ZoomManager.class.toString());
        if (zoomMgr != null) {
            zoomMgr.removeZoomListener(this.zoomListener);
        }
        if (this.actionHandler != null) {
            this.actionHandler.dispose();
            this.actionHandler = null;
        }
        if (this.actionBars != null) {
            this.restoreSavedActions(this.actionBars);
            this.actionBars.updateActionBars();
            this.actionBars = null;
        }
        super.bringDown();
    }

    protected CellEditor createCellEditorOn(Composite composite) {
        return new TextCellEditor(composite, 66){

            protected Control createControl(Composite parent) {
                Shell shell = new Shell(parent.getShell(), 8);
                final Text text = (Text)super.createControl((Composite)shell);
                shell.setData((Object)parent);
                shell.setLayout(new Layout(){

                    protected void layout(Composite composite, boolean flushCache) {
                        Rectangle availableSize = composite.getClientArea();
                        text.setBounds(1, 1, availableSize.width - 2, availableSize.height - 2);
                    }

                    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
                        return text.computeSize(wHint, hHint);
                    }
                });
                shell.addPaintListener(new PaintListener(){

                    public void paintControl(PaintEvent e) {
                        Rectangle bounds = ((Shell)e.widget).getBounds();
                        int w = bounds.width - 1;
                        int h = bounds.height - 1;
                        e.gc.setForeground(ColorConstants.orange);
                        e.gc.drawRectangle(0, 0, w, h);
                    }
                });
                text.setBackground(ColorConstants.white);
                return shell;
            }
        };
    }

    public void showFeedback() {
        this.getEditPart().showSourceFeedback((Request)this.getDirectEditRequest());
    }

    public void dispose() {
        this.disposeScaledFont();
    }

    private void disposeScaledFont() {
        if (this.scaledFont != null) {
            this.scaledFont.dispose();
            this.scaledFont = null;
        }
    }

    protected void initCellEditor() {
        try {
            MCallout model = ((CalloutEditPart)this.getEditPart()).getModel();
            this.getCellEditor().setValue(model.getPropertyValue("TEXT"));
            this.getCellEditor().getControl().setBackground(Display.getCurrent().getSystemColor(1));
            ZoomManager zoomMgr = (ZoomManager)this.getEditPart().getViewer().getProperty(ZoomManager.class.toString());
            if (zoomMgr != null) {
                this.updateScaledFont(zoomMgr.getZoom(), model);
                zoomMgr.addZoomListener(this.zoomListener);
            }
            this.actionBars = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getEditorSite().getActionBars();
            this.saveCurrentActions(this.actionBars);
            this.actionHandler = new CellEditorActionHandler(this.actionBars);
            this.actionHandler.addCellEditor(this.getCellEditor());
            this.actionBars.updateActionBars();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void restoreSavedActions(IActionBars actionBars) {
        actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), this.copy);
        actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), this.paste);
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), this.delete);
        actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), this.selectAll);
        actionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), this.cut);
        actionBars.setGlobalActionHandler(ActionFactory.FIND.getId(), this.find);
        actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), this.undo);
        actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), this.redo);
    }

    private void saveCurrentActions(IActionBars actionBars) {
        this.copy = actionBars.getGlobalActionHandler(ActionFactory.COPY.getId());
        this.paste = actionBars.getGlobalActionHandler(ActionFactory.PASTE.getId());
        this.delete = actionBars.getGlobalActionHandler(ActionFactory.DELETE.getId());
        this.selectAll = actionBars.getGlobalActionHandler(ActionFactory.SELECT_ALL.getId());
        this.cut = actionBars.getGlobalActionHandler(ActionFactory.CUT.getId());
        this.find = actionBars.getGlobalActionHandler(ActionFactory.FIND.getId());
        this.undo = actionBars.getGlobalActionHandler(ActionFactory.UNDO.getId());
        this.redo = actionBars.getGlobalActionHandler(ActionFactory.REDO.getId());
    }

    private void updateScaledFont(double zoom, MCallout model) {
        int fontSize = 1;
        Object fontSizeValue = model == null ? null : model.getPropertyValue("fontSize");
        try {
            if (fontSizeValue != null) {
                if (fontSizeValue instanceof String) {
                    fontSize = Integer.parseInt((String)fontSizeValue);
                } else if (fontSizeValue instanceof Number) {
                    fontSize = ((Number)fontSizeValue).intValue();
                }
            }
        }
        catch (Exception exception) {}
        String fontName = model == null ? null : (String)model.getPropertyValue("fontName");
        Shell shell = (Shell)this.getCellEditor().getControl();
        Text text = (Text)shell.getChildren()[0];
        Font font = this.getEditPart().getFigure().getFont();
        this.disposeScaledFont();
        try {
            FontData fd = font.getFontData()[0];
            fd.setHeight((int)(zoom * (double)fontSize * 0.75));
            if (fontName != null && fontName.length() > 0) {
                fd.setName(fontName);
            }
            this.scaledFont = new Font(null, fd);
            text.setFont(this.scaledFont);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

