/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.custom.adapter.wizard;

import com.jaspersoft.studio.custom.adapter.AdapterInfo;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.wizards.ContextHelpIDs;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class DataAdapterInformationPage
extends WizardPage {
    private Text projectName;
    private Text dataAdapterName;
    private Text dataAdapterDescription;
    private Text packageText;
    private Text imagePath;
    private Button openImage;
    private Button dummyAdapterButton;
    private Button customJarAdapterButton;
    private boolean usingCustomJar = false;
    private AdapterInfo resultInfo = null;
    private ModifyListener fieldModified = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            DataAdapterInformationPage.this.doStatusUpdate();
        }
    };

    protected DataAdapterInformationPage() {
        super("dataAdapterInformationPage");
        this.setTitle(Messages.DataAdapterInformationPage_title);
        this.setDescription(Messages.DataAdapterInformationPage_description);
    }

    public boolean isPageComplete() {
        if (this.dataAdapterName.getText().trim().isEmpty() || this.packageText.getText().trim().isEmpty()) {
            this.setErrorMessage(Messages.DataAdapterInformationPage_errorEmpty);
            return false;
        }
        if (this.packageText.getText().indexOf(" ") != -1) {
            this.setErrorMessage(Messages.DataAdapterInformationPage_errorInvalidChar);
            return false;
        }
        Path pathContainer = new Path(this.projectName.getText());
        if (!pathContainer.isValidPath(this.projectName.getText())) {
            this.setErrorMessage(Messages.DataAdapterInformationPage_errorInvalidGeneric);
            return false;
        }
        if (pathContainer.segmentCount() < 1) {
            this.setErrorMessage(Messages.DataAdapterInformationPage_errorEmpty2);
            return false;
        }
        if (this.projectExists(pathContainer.segment(0))) {
            this.setErrorMessage(Messages.DataAdapterInformationPage_errorProjectExist);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    protected boolean projectExists(String projectName) {
        Path containerNamePath;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)(containerNamePath = new Path("/" + projectName)));
        if (resource == null) {
            return false;
        }
        return resource.exists();
    }

    protected void doStatusUpdate() {
        boolean isPageComplete = this.isPageComplete();
        this.resultInfo = isPageComplete ? new AdapterInfo(this.projectName.getText(), this.dataAdapterName.getText(), this.dataAdapterDescription.getText(), this.packageText.getText(), this.imagePath.getText()) : null;
        this.setPageComplete(isPageComplete);
    }

    public AdapterInfo getAdapterInfo() {
        return this.resultInfo;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        int cols = 4;
        GridLayout layout = new GridLayout();
        layout.numColumns = cols;
        composite.setLayout((Layout)layout);
        this.createProjectControls(composite, cols);
        this.createPackageControls(composite, cols);
        this.createAdapterNameControls(composite, cols);
        this.createAdapterDescriptionControls(composite, cols);
        this.createImageControls(composite, cols);
        this.createSampleControls(composite, cols);
        this.setControl((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, ContextHelpIDs.WIZARD_NEW_FUNCTIONS_LIBRARY);
    }

    public boolean isUsingCustomJar() {
        return this.usingCustomJar;
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete() && this.customJarAdapterButton.getSelection();
    }

    private void createAdapterNameControls(Composite parent, int cols) {
        Label adapterNameLbl = new Label(parent, 0);
        adapterNameLbl.setText(Messages.DataAdapterInformationPage_adapterNameLabel);
        adapterNameLbl.setToolTipText(Messages.DataAdapterInformationPage_adapterNameTooltip);
        adapterNameLbl.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.dataAdapterName = new Text(parent, 2048);
        this.dataAdapterName.setLayoutData((Object)new GridData(4, 4, true, false, cols - 1, 1));
        this.dataAdapterName.addModifyListener(this.fieldModified);
    }

    private void createSampleControls(Composite parent, int cols) {
        Composite container = new Composite(parent, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, false, cols, 1));
        container.setLayout((Layout)new GridLayout(1, false));
        SelectionAdapter selectionChanged = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataAdapterInformationPage.this.getWizard().getContainer().updateButtons();
                DataAdapterInformationPage.this.usingCustomJar = DataAdapterInformationPage.this.customJarAdapterButton.getSelection();
            }
        };
        this.dummyAdapterButton = new Button(container, 16);
        this.dummyAdapterButton.setText(Messages.DataAdapterInformationPage_dummyDataAdapterOption);
        this.dummyAdapterButton.addSelectionListener((SelectionListener)selectionChanged);
        this.customJarAdapterButton = new Button(container, 16);
        this.customJarAdapterButton.setText(Messages.DataAdapterInformationPage_customDataAdapterOption);
        this.customJarAdapterButton.addSelectionListener((SelectionListener)selectionChanged);
        this.dummyAdapterButton.setSelection(true);
    }

    private void createAdapterDescriptionControls(Composite parent, int cols) {
        Label adapterDescriptionLbl = new Label(parent, 0);
        adapterDescriptionLbl.setText(Messages.DataAdapterInformationPage_adapterDescriptionLabel);
        adapterDescriptionLbl.setToolTipText(Messages.DataAdapterInformationPage_adapterDescriptionTooltip);
        adapterDescriptionLbl.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.dataAdapterDescription = new Text(parent, 2048);
        this.dataAdapterDescription.setLayoutData((Object)new GridData(4, 4, true, false, cols - 1, 1));
        this.dataAdapterDescription.addModifyListener(this.fieldModified);
    }

    protected void createProjectControls(Composite parent, int nColumns) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(16384, 128, false, false));
        label.setText(Messages.DataAdapterInformationPage_pliugnNameLabel);
        label.setToolTipText(Messages.DataAdapterInformationPage_pluginNameTooltip);
        this.projectName = new Text(parent, 2048);
        this.projectName.setLayoutData((Object)new GridData(4, 4, true, false, nColumns - 1, 1));
        this.projectName.addModifyListener(this.fieldModified);
    }

    protected void createPackageControls(Composite parent, int nColumns) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(16384, 128, false, false));
        label.setText(Messages.DataAdapterInformationPage_packageLabel);
        label.setToolTipText(Messages.DataAdapterInformationPage_packageTooltip);
        this.packageText = new Text(parent, 2048);
        this.packageText.setLayoutData((Object)new GridData(4, 4, true, false, nColumns - 1, 1));
        this.packageText.addModifyListener(this.fieldModified);
    }

    protected void createImageControls(Composite parent, int cols) {
        Label adapterNameLbl = new Label(parent, 0);
        adapterNameLbl.setText(Messages.DataAdapterInformationPage_imageLabel);
        adapterNameLbl.setToolTipText(Messages.DataAdapterInformationPage_imageTooltip);
        adapterNameLbl.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.imagePath = new Text(parent, 2048);
        this.imagePath.setLayoutData((Object)new GridData(4, 128, true, false, cols - 2, 1));
        this.imagePath.addModifyListener(this.fieldModified);
        this.openImage = new Button(parent, 0);
        this.openImage.setText(Messages.common_browse);
        this.openImage.setLayoutData((Object)new GridData(4, 128, false, false));
        this.openImage.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fd = new FileDialog(DataAdapterInformationPage.this.getShell(), 4096);
                fd.setText(Messages.common_open);
                String[] filterExt = new String[]{"*.jpg", "*.png", ".gif", "*.*"};
                fd.setFilterExtensions(filterExt);
                String selected = fd.open();
                if (selected != null) {
                    DataAdapterInformationPage.this.imagePath.setText(selected);
                }
            }
        });
    }
}

