/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.data.DataAdapterDescriptor;
import com.jaspersoft.studio.data.DataAdapterFactory;
import com.jaspersoft.studio.data.customadapters.ConfigurableDataAdapterFactory;
import com.jaspersoft.studio.data.customadapters.ui.AdapterWidgetsDescriptor;
import com.jaspersoft.studio.data.storage.ADataAdapterStorage;
import com.jaspersoft.studio.data.storage.FileDataAdapterStorage;
import com.jaspersoft.studio.data.storage.JRDefaultDataAdapterStorage;
import com.jaspersoft.studio.data.storage.PreferencesDataAdapterStorage;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.widgets.framework.manager.StandardJSONWidgetsDescriptorResolver;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import net.sf.jasperreports.data.DataAdapter;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.eclipse.wizard.project.ProjectUtil;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.util.CastorUtil;
import net.sf.jasperreports.util.JacksonRuntimException;
import net.sf.jasperreports.util.JacksonUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class DataAdapterManager {
    private static Map<String, DataAdapterFactory> dataAdapterFactories = new HashMap<String, DataAdapterFactory>();
    private static Map<String, DataAdapterFactory> customFactories = new HashMap<String, DataAdapterFactory>();
    private static Map<Object, ADataAdapterStorage> storages = new HashMap<Object, ADataAdapterStorage>();

    static {
        JaspersoftStudioPlugin.getInstance().getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("om.jaspersoft.studio.data.customadapters.adapters")) {
                    customFactories.clear();
                    DataAdapterManager.loadCustomFactories();
                }
            }
        });
        DataAdapterManager.loadCustomFactories();
    }

    protected static void loadCustomFactories() {
        String definitions = JaspersoftStudioPlugin.getInstance().getPreferenceStore().getString("om.jaspersoft.studio.data.customadapters.adapters");
        StringTokenizer st = new StringTokenizer(definitions, String.valueOf(File.pathSeparator) + "\n\r");
        LinkedHashSet<String> pathsList = new LinkedHashSet<String>();
        while (st.hasMoreTokens()) {
            pathsList.add(st.nextToken());
        }
        if (!pathsList.isEmpty()) {
            StandardJSONWidgetsDescriptorResolver resolver = new StandardJSONWidgetsDescriptorResolver(AdapterWidgetsDescriptor.class);
            for (String definition : pathsList) {
                AdapterWidgetsDescriptor loadedDecriptor;
                File file = new File(definition);
                if (!file.exists() || (loadedDecriptor = (AdapterWidgetsDescriptor)resolver.loadDescriptor(JasperReportsConfiguration.getDefaultInstance(), file.getAbsolutePath())) == null) continue;
                ConfigurableDataAdapterFactory factory = new ConfigurableDataAdapterFactory(loadedDecriptor);
                customFactories.put(loadedDecriptor.getAdapterClass(), factory);
            }
        }
    }

    public static void addDataAdapterFactory(DataAdapterFactory factory) {
        if (!dataAdapterFactories.containsKey(factory.getDataAdapterClassName())) {
            dataAdapterFactories.put(factory.getDataAdapterClassName(), factory);
        }
    }

    public static void removeDataAdapterFactory(DataAdapterFactory factory) {
        String cl = factory.getDataAdapterClassName();
        DataAdapterFactory f = dataAdapterFactories.get(cl);
        if (f != null && factory == f) {
            dataAdapterFactories.remove(cl);
        }
    }

    public static synchronized List<DataAdapterFactory> getDataAdapterFactories() {
        DataAdapterFactory[] factories = dataAdapterFactories.values().toArray(new DataAdapterFactory[dataAdapterFactories.size()]);
        Arrays.sort(factories, new Comparator<DataAdapterFactory>(){

            @Override
            public int compare(DataAdapterFactory df1, DataAdapterFactory df2) {
                String name1 = df1 == null ? "" : df1.getLabel();
                String name2 = df2 == null ? "" : df2.getLabel();
                return name1.compareTo(name2);
            }
        });
        ArrayList<DataAdapterFactory> listOfDataAdapterFactories = new ArrayList<DataAdapterFactory>();
        listOfDataAdapterFactories.addAll(Arrays.asList(factories));
        listOfDataAdapterFactories.addAll(customFactories.values());
        return listOfDataAdapterFactories;
    }

    public static DataAdapterFactory findFactoryByDataAdapterClass(String adapterClassName) {
        if (Misc.isNullOrEmpty((String)adapterClassName)) {
            return null;
        }
        DataAdapterFactory factory = dataAdapterFactories.get(adapterClassName);
        if (factory != null) {
            return factory;
        }
        return customFactories.get(adapterClassName);
    }

    public static ADataAdapterStorage[] getDataAdapter(IFile file, IProject project, JasperReportsConfiguration jConfig) {
        ArrayList<ADataAdapterStorage> st = new ArrayList<ADataAdapterStorage>();
        st.add(DataAdapterManager.getPreferencesStorage());
        if (file != null) {
            project = file.getProject();
        }
        if (project != null) {
            st.add(DataAdapterManager.getProjectStorage(project));
        }
        if (jConfig != null && jConfig.getJasperDesign() != null) {
            st.add(DataAdapterManager.getJRDefaultStorage(jConfig));
        }
        return st.toArray(new ADataAdapterStorage[st.size()]);
    }

    public static ADataAdapterStorage[] getDataAdapter(IFile file, JasperReportsConfiguration jConfig) {
        return DataAdapterManager.getDataAdapter(file, null, jConfig);
    }

    public static ADataAdapterStorage getProjectStorage(IProject key) {
        ADataAdapterStorage s = storages.get(key);
        if (s == null) {
            s = new FileDataAdapterStorage(key);
            storages.put(key, s);
            s.findAll();
            s.getDataAdapterDescriptors();
        }
        return s;
    }

    public static void removeProject(IProject prj) {
        storages.remove(prj);
    }

    public static JRDefaultDataAdapterStorage getJRDefaultStorage(JasperReportsConfiguration key) {
        ADataAdapterStorage s = storages.get((Object)key);
        if (s == null) {
            s = new JRDefaultDataAdapterStorage(key);
            s.getDataAdapterDescriptors();
            storages.put((Object)key, s);
        }
        return (JRDefaultDataAdapterStorage)s;
    }

    public static ADataAdapterStorage getPreferencesStorage() {
        ADataAdapterStorage s = storages.get("PREFERENCES");
        if (s == null) {
            s = new PreferencesDataAdapterStorage();
            storages.put("PREFERENCES", s);
            s.getDataAdapterDescriptors();
        }
        return s;
    }

    public static List<ADataAdapterStorage> getProjectStorages() {
        ArrayList<ADataAdapterStorage> das = new ArrayList<ADataAdapterStorage>();
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject prj = iProjectArray[n2];
            if (ProjectUtil.isOpen((IProject)prj)) {
                das.add(DataAdapterManager.getProjectStorage(prj));
            }
            ++n2;
        }
        return das;
    }

    public static String toDataAdapterFile(DataAdapterDescriptor dataAdapter, JasperReportsContext jrContext) {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n" + dataAdapter.toXml(jrContext);
    }

    public static DataAdapterDescriptor cloneDataAdapter(DataAdapterDescriptor src, JasperReportsContext jrContext) {
        DataAdapter srcDataAdapter = src.getDataAdapter();
        DataAdapterFactory factory = DataAdapterManager.findFactoryByDataAdapterClass(srcDataAdapter.getClass().getName());
        DataAdapterDescriptor copy = factory.createDataAdapter();
        copy.setName(src.name);
        DataAdapter copyDataAdapter = null;
        byte[] bytes = src.toXml(jrContext).getBytes();
        try {
            copyDataAdapter = (DataAdapter)JacksonUtil.getInstance((JasperReportsContext)jrContext).loadXml((InputStream)new ByteArrayInputStream(bytes), DataAdapter.class);
        }
        catch (JacksonRuntimException jacksonRuntimException) {
            copyDataAdapter = (DataAdapter)CastorUtil.getInstance((JasperReportsContext)jrContext).read((InputStream)new ByteArrayInputStream(bytes));
        }
        copy.setDataAdapter(copyDataAdapter);
        return copy;
    }
}

