/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.actions;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.data.DataAdapterDescriptor;
import com.jaspersoft.studio.data.DataAdapterManager;
import com.jaspersoft.studio.data.MDataAdapter;
import com.jaspersoft.studio.data.MDataAdapters;
import com.jaspersoft.studio.data.actions.EditDataAdapterAction;
import com.jaspersoft.studio.data.storage.ADataAdapterStorage;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.util.ArrayList;
import net.sf.jasperreports.engine.JasperReportsContext;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;

public class DuplicateDataAdapterAction
extends Action {
    public static final String COPY_OF = Messages.DuplicateDataAdapterAction_newAdapterPrefix;
    public static final String ID = "duplicatedataAdapteraction";
    private TreeViewer treeViewer;
    private EditDataAdapterAction editAction;

    public DuplicateDataAdapterAction(TreeViewer treeViewer) {
        this.treeViewer = treeViewer;
        this.setId(ID);
        this.setText(Messages.DuplicateDataAdapterAction_duplicateName);
        this.setDescription(Messages.DuplicateDataAdapterAction_duplicateDescription);
        this.setToolTipText(Messages.DuplicateDataAdapterAction_duplicateToolTip);
        this.setImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("IMG_TOOL_COPY"));
        this.setDisabledImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("IMG_TOOL_COPY"));
    }

    public boolean isEnabled() {
        Object firstElement = ((TreeSelection)this.treeViewer.getSelection()).getFirstElement();
        return firstElement != null && firstElement instanceof MDataAdapter;
    }

    public void run() {
        TreeSelection s = (TreeSelection)this.treeViewer.getSelection();
        TreePath[] p = s.getPaths();
        ArrayList<DataAdapterDescriptor> copies = new ArrayList<DataAdapterDescriptor>();
        MDataAdapters mdas = null;
        int i = 0;
        while (i < p.length) {
            Object obj = p[i].getLastSegment();
            if (obj instanceof MDataAdapter) {
                MDataAdapter mDataAdapter = (MDataAdapter)obj;
                mdas = (MDataAdapters)mDataAdapter.getParent();
                ADataAdapterStorage storage = ((MDataAdapters)mDataAdapter.getParent()).getValue();
                DataAdapterDescriptor copyDataAdapter = DataAdapterManager.cloneDataAdapter(mDataAdapter.getValue(), (JasperReportsContext)JasperReportsConfiguration.getDefaultInstance());
                JaspersoftStudioPlugin.getInstance().getUsageManager().audit(copyDataAdapter.getClass().getName(), "DataAdapter");
                String name = String.valueOf(COPY_OF) + copyDataAdapter.getName();
                int j = 1;
                while (j < 1000) {
                    if (storage.isDataAdapterNameValid(name)) break;
                    name = String.valueOf(COPY_OF) + copyDataAdapter.getName() + j;
                    ++j;
                }
                copyDataAdapter.getDataAdapter().setName(name);
                storage.addDataAdapter(copyDataAdapter);
                copies.add(copyDataAdapter);
            }
            ++i;
        }
        if (!copies.isEmpty()) {
            this.treeViewer.refresh(true);
            if (copies.size() == 1) {
                DataAdapterDescriptor copy = (DataAdapterDescriptor)copies.get(0);
                for (INode mDataAdapter : mdas.getChildren()) {
                    if (mDataAdapter.getValue() != copy) continue;
                    this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)mDataAdapter));
                    this.treeViewer.reveal((Object)mDataAdapter);
                    this.runEditAction();
                    break;
                }
            }
        }
    }

    private void runEditAction() {
        if (this.editAction == null) {
            this.editAction = new EditDataAdapterAction(this.treeViewer);
        }
        this.editAction.run();
    }
}

