/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.adapter;

import com.jaspersoft.studio.data.DataAdapterDescriptor;
import com.jaspersoft.studio.data.DataAdapterFactory;
import com.jaspersoft.studio.data.DataAdapterManager;
import com.jaspersoft.studio.data.adapter.IDataAdapterCreator;
import com.jaspersoft.studio.data.adapter.IReportDescriptor;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.swt.SWT;
import org.w3c.dom.Document;

public class ImportUtility {
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static final String configurationPrefix = FILE_SEPARATOR.concat("config").concat(FILE_SEPARATOR).concat("Preferences").concat(FILE_SEPARATOR).concat("com").concat(FILE_SEPARATOR).concat("jaspersoft");
    private static HashMap<String, IDataAdapterCreator> importManager = null;

    private static void createImportManager() {
        importManager = new HashMap();
        for (DataAdapterFactory factory : DataAdapterManager.getDataAdapterFactories()) {
            IDataAdapterCreator creator = factory.iReportConverter();
            if (creator == null) continue;
            importManager.put(creator.getID(), creator);
        }
    }

    public static OperativeSystem GetPlatform() {
        String platform = SWT.getPlatform();
        if (platform.equals("cocoa") || platform.equals("carbon")) {
            return OperativeSystem.MacOS;
        }
        if (platform.toLowerCase().startsWith("win")) {
            return OperativeSystem.Windows;
        }
        return OperativeSystem.Linux;
    }

    private static List<IReportDescriptor> getVersions(String path, boolean isPro) {
        ArrayList<IReportDescriptor> result = new ArrayList<IReportDescriptor>();
        String versionExpression = "[0-9]\\.[0-9]\\.[0-9]";
        File destination = new File(path);
        if (destination.exists()) {
            File[] children;
            File[] fileArray = children = destination.listFiles();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                String confPath;
                File confFile;
                File child = fileArray[n2];
                if (child.isDirectory() && child.getName().matches(versionExpression) && (confFile = new File(confPath = child.getAbsolutePath().concat(FILE_SEPARATOR).concat(configurationPrefix))).exists()) {
                    result.add(new IReportDescriptor(confFile, child.getName(), isPro));
                }
                ++n2;
            }
        }
        return result;
    }

    public static boolean hasAdapter(String className) {
        if (importManager == null) {
            ImportUtility.createImportManager();
        }
        return importManager.containsKey(className);
    }

    public static DataAdapterDescriptor getAdapter(Document xml, String className) {
        IDataAdapterCreator creator;
        if (importManager == null) {
            ImportUtility.createImportManager();
        }
        if ((creator = importManager.get(className)) != null) {
            return creator.buildFromXML(xml);
        }
        return null;
    }

    public static IReportDescriptor GetDescriptor(String path) {
        File propFile = new File(path);
        if (propFile.exists() && propFile.getName().equals("ireport.properties")) {
            IReportDescriptor newDesc = new IReportDescriptor(propFile.getParentFile(), "", false);
            return newDesc;
        }
        return null;
    }

    public static List<IReportDescriptor> getIReportConfigurationFolder() {
        ArrayList<IReportDescriptor> result = new ArrayList<IReportDescriptor>();
        String iReportFolder = System.getProperty("user.home");
        String iReportProFolder = System.getProperty("user.home");
        OperativeSystem platform = ImportUtility.GetPlatform();
        switch (platform) {
            case MacOS: {
                iReportFolder = iReportFolder.concat("/Library/Application Support/ireport");
                iReportProFolder = iReportProFolder.concat("/Library/Application Support/ireportpro");
                break;
            }
            case Windows: {
                iReportFolder = iReportFolder.concat("\\.ireport");
                iReportProFolder = iReportProFolder.concat("\\.ireportpro");
                break;
            }
            case Linux: {
                iReportFolder = iReportFolder.concat("/.ireport");
                iReportProFolder = iReportProFolder.concat("/.ireportpro");
            }
        }
        result.addAll(ImportUtility.getVersions(iReportFolder, false));
        result.addAll(ImportUtility.getVersions(iReportProFolder, true));
        return result;
    }

    public static enum OperativeSystem {
        MacOS,
        Windows,
        Linux;

    }
}

