/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.customadapters;

import com.jaspersoft.studio.data.DataAdapterDescriptor;
import com.jaspersoft.studio.data.DataAdapterEditor;
import com.jaspersoft.studio.data.customadapters.ConfigurableDataAdapterEditor;
import com.jaspersoft.studio.data.customadapters.IAdapterPropertyHandler;
import com.jaspersoft.studio.data.customadapters.ui.AdapterWidgetsDescriptor;
import com.jaspersoft.studio.data.fields.IFieldsProvider;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.lang.reflect.Constructor;
import java.util.List;
import net.sf.jasperreports.data.DataAdapter;
import net.sf.jasperreports.data.DataAdapterService;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.design.JRDesignField;

public class ConfigurableDataAdapterDescriptor
extends DataAdapterDescriptor
implements IFieldsProvider {
    private static final long serialVersionUID = 4348212451493471479L;
    private AdapterWidgetsDescriptor descriptor;

    public ConfigurableDataAdapterDescriptor(AdapterWidgetsDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    @Override
    public DataAdapter getDataAdapter() {
        if (this.dataAdapter == null) {
            try {
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(this.descriptor.getAdapterClass());
                Constructor<?> ctor = clazz.getConstructor(new Class[0]);
                this.dataAdapter = (DataAdapter)ctor.newInstance(new Object[0]);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return this.dataAdapter;
    }

    @Override
    public DataAdapter getDataAdapter(JasperReportsConfiguration jConfig) {
        if (this.dataAdapter == null) {
            try {
                Class<?> clazz = jConfig.getClassLoader().loadClass(this.descriptor.getAdapterClass());
                Constructor<?> ctor = clazz.getConstructor(new Class[0]);
                this.dataAdapter = (DataAdapter)ctor.newInstance(new Object[0]);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return this.dataAdapter;
    }

    @Override
    public DataAdapterEditor getEditor() {
        return new ConfigurableDataAdapterEditor(this.descriptor);
    }

    @Override
    public boolean supportsGetFieldsOperation(JasperReportsConfiguration jConfig, JRDataset jDataset) {
        IAdapterPropertyHandler setter = this.descriptor.getAdapterPropertyHandler(jConfig);
        if (setter != null && setter instanceof IFieldsProvider) {
            return ((IFieldsProvider)((Object)setter)).supportsGetFieldsOperation(jConfig, jDataset);
        }
        return false;
    }

    @Override
    public List<JRDesignField> getFields(DataAdapterService con, JasperReportsConfiguration jConfig, JRDataset jDataset) throws JRException, UnsupportedOperationException {
        IAdapterPropertyHandler setter = this.descriptor.getAdapterPropertyHandler(jConfig);
        if (setter != null && setter instanceof IFieldsProvider) {
            return ((IFieldsProvider)((Object)setter)).getFields(con, jConfig, jDataset);
        }
        return null;
    }
}

