/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.customadapters;

import com.jaspersoft.studio.backward.JRVersionPreferencesPages;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.VersionComparator;
import net.sf.jasperreports.util.CastorMapping;
import net.sf.jasperreports.util.JacksonUtil;
import org.apache.commons.collections4.map.AbstractReferenceMap;
import org.apache.commons.collections4.map.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.XMLContext;
import org.xml.sax.InputSource;

public class JSSCastorUtil {
    private static final Log log = LogFactory.getLog(JSSCastorUtil.class);
    public static final String EXCEPTION_MESSAGE_KEY_MAPPINGS_LOADING_ERROR = "util.castor.mappings.loading.error";
    private static final String CASTOR_READ_XML_CONTEXT_KEY = "net.sf.jasperreports.castor.read.xml.context";
    private static final String CASTOR_WRITE_XML_CONTEXT_KEY = "net.sf.jasperreports.castor.write.xml.context";
    private JasperReportsConfiguration jasperReportsContext;
    private VersionComparator versionComparator;

    private JSSCastorUtil(JasperReportsConfiguration jasperReportsContext) {
        this.jasperReportsContext = jasperReportsContext;
        this.versionComparator = new VersionComparator();
    }

    public static void clearCache(JasperReportsConfiguration jConfig) {
        jConfig.removeValue(CASTOR_READ_XML_CONTEXT_KEY);
        jConfig.removeValue(CASTOR_WRITE_XML_CONTEXT_KEY);
    }

    public static JSSCastorUtil getInstance(JasperReportsConfiguration jasperReportsContext) {
        return new JSSCastorUtil(jasperReportsContext);
    }

    private XMLContext getReadXmlContext() {
        return this.getXmlContext(CASTOR_READ_XML_CONTEXT_KEY, null);
    }

    private XMLContext getWriteXmlContext() {
        String targetVersion = JRPropertiesUtil.getInstance((JasperReportsContext)this.jasperReportsContext).getProperty("net.sf.jasperreports.report.version");
        if (log.isDebugEnabled()) {
            log.debug((Object)("using write mappings for version " + targetVersion));
        }
        return this.getXmlContext(CASTOR_WRITE_XML_CONTEXT_KEY, targetVersion);
    }

    private XMLContext getXmlContext(String contextCacheKey, String version) {
        ClassLoader cacheKey = this.jasperReportsContext.getClassLoader();
        Map<Object, XMLContext> xmlContextCache = this.getXmlContextCache(contextCacheKey);
        XMLContext xmlContext = xmlContextCache.get(cacheKey);
        if (xmlContext == null) {
            xmlContext = new XMLContext();
            xmlContext.setClassLoader(this.jasperReportsContext.getClassLoader());
            Mapping mapping = new Mapping(this.jasperReportsContext.getClassLoader());
            List<CastorMapping> castorMappings = this.getMappings(version);
            for (CastorMapping castorMapping : castorMappings) {
                this.loadMapping(mapping, castorMapping.getPath());
            }
            try {
                xmlContext.addMapping(mapping);
            }
            catch (MappingException e) {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_MAPPINGS_LOADING_ERROR, null, (Throwable)e);
            }
            xmlContextCache.put(cacheKey, xmlContext);
            this.jasperReportsContext.setValue(contextCacheKey, xmlContextCache);
        }
        return xmlContext;
    }

    protected Map<Object, XMLContext> getXmlContextCache(String contextCacheKey) {
        Map xmlContextCache = (Map)this.jasperReportsContext.getOwnValue(contextCacheKey);
        if (xmlContextCache == null) {
            xmlContextCache = Collections.synchronizedMap(new ReferenceMap(AbstractReferenceMap.ReferenceStrength.WEAK, AbstractReferenceMap.ReferenceStrength.SOFT));
            this.jasperReportsContext.setValue(contextCacheKey, xmlContextCache);
        }
        return xmlContextCache;
    }

    protected List<CastorMapping> getMappings(String version) {
        List<CastorMapping> castorMappings = this.jasperReportsContext.getExtensions(CastorMapping.class);
        HashMap<String, CastorMapping> keyMappings = new HashMap<String, CastorMapping>();
        for (CastorMapping mapping : castorMappings) {
            CastorMapping existingMapping;
            String key = mapping.getKey();
            if (key == null || !this.isEligversionible(mapping, version) || (existingMapping = (CastorMapping)keyMappings.get(key)) != null && !this.newerThan(mapping, existingMapping)) continue;
            keyMappings.put(key, mapping);
        }
        ArrayList<CastorMapping> activeMappings = new ArrayList<CastorMapping>(castorMappings.size());
        for (CastorMapping mapping : castorMappings) {
            String key = mapping.getKey();
            if (key != null && !((CastorMapping)keyMappings.get(key)).equals(mapping)) continue;
            activeMappings.add(mapping);
        }
        return activeMappings;
    }

    protected boolean isEligversionible(CastorMapping castorMapping, String targetVersion) {
        String mappingVersion = this.getVersion(castorMapping);
        return this.versionComparator.compare(targetVersion, mappingVersion) >= 0;
    }

    private boolean newerThan(CastorMapping mapping, CastorMapping existingMapping) {
        String existingVersion;
        String version = this.getVersion(mapping);
        return this.versionComparator.compare(version, existingVersion = this.getVersion(existingMapping)) > 0;
    }

    protected String getVersion(CastorMapping castorMapping) {
        String mappingVersion = castorMapping.getVersion();
        if (mappingVersion == null) {
            mappingVersion = "0";
        }
        return mappingVersion;
    }

    private void loadMapping(Mapping mapping, String mappingFile) {
        try {
            byte[] mappingFileData = JRLoader.loadBytesFromResource((String)mappingFile, (ClassLoader)this.jasperReportsContext.getClassLoader());
            InputSource mappingSource = new InputSource(new ByteArrayInputStream(mappingFileData));
            mapping.loadMapping(mappingSource);
        }
        catch (JRException e) {
            throw new JRRuntimeException((Throwable)e);
        }
    }

    public Object read(InputStream is) {
        try {
            Unmarshaller unmarshaller = this.getReadXmlContext().createUnmarshaller();
            unmarshaller.setClassLoader(this.jasperReportsContext.getClassLoader());
            unmarshaller.setWhitespacePreserve(true);
            Object object = unmarshaller.unmarshal(new InputSource(is));
            return object;
        }
        catch (MarshalException | ValidationException e) {
            throw new JRRuntimeException(e);
        }
    }

    public String writeToString(Object object) {
        StringWriter writer = new StringWriter();
        this.write(object, writer);
        return writer.toString();
    }

    public void writeToFile(Object object, String filename) {
        BufferedOutputStream output = null;
        boolean closed = false;
        try {
            try {
                output = new BufferedOutputStream(new FileOutputStream(filename));
                this.write(object, output);
                ((OutputStream)output).close();
                closed = true;
            }
            catch (IOException e) {
                throw new JRRuntimeException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            if (output != null && !closed) {
                try {
                    ((OutputStream)output).close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (output != null && !closed) {
            try {
                ((OutputStream)output).close();
            }
            catch (IOException iOException) {}
        }
    }

    public void write(Object object, OutputStream output) {
        try {
            OutputStreamWriter writer = new OutputStreamWriter(output, "UTF-8");
            this.write(object, writer);
        }
        catch (UnsupportedEncodingException e) {
            throw new JRRuntimeException((Throwable)e);
        }
    }

    public void write(Object object, Writer writer) {
        String jssCompatibilityVersion = JRVersionPreferencesPages.fixCompatibilityVersion((JasperReportsContext)this.jasperReportsContext);
        if (this.versionComparator.compare(jssCompatibilityVersion, "6.19.0") >= 0) {
            String xml = JacksonUtil.getInstance((JasperReportsContext)this.jasperReportsContext).getXmlString(object);
            try {
                writer.write(xml);
            }
            catch (IOException e) {
                throw new JRRuntimeException((Throwable)e);
            }
        }
        Marshaller marshaller = this.getWriteXmlContext().createMarshaller();
        try {
            marshaller.setWriter(writer);
            marshaller.setMarshalAsDocument(false);
            marshaller.marshal(object);
        }
        catch (IOException | MarshalException | ValidationException e) {
            throw new JRRuntimeException(e);
        }
    }
}

