/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.designer;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.data.designer.AQueryDesigner;
import com.jaspersoft.studio.data.designer.IFilterQuery;
import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.swt.widgets.WTextExpression;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.eclipse.ui.ATitledDialog;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SelectParameterDialog
extends ATitledDialog {
    protected String pname = null;
    protected JRDesignParameter prm;
    protected AQueryDesigner designer;
    protected JRDesignDataset dataset;
    protected IFilterQuery fq;
    protected Map<String, JRDesignParameter> parameters = new HashMap<String, JRDesignParameter>();
    protected WTextExpression wdef;
    protected Combo cmb;
    protected Set<JRDesignParameter> dirty = new HashSet<JRDesignParameter>();

    public SelectParameterDialog(Shell parentShell, AQueryDesigner designer, IFilterQuery fq) {
        super(parentShell, false);
        this.setTitle(Messages.SelectParameterDialog_0);
        this.designer = designer;
        this.fq = fq;
        this.dataset = (JRDesignDataset)designer.getjDataset().clone();
    }

    public SelectParameterDialog(Shell parentShell, AQueryDesigner designer, JRDesignParameter prm, IFilterQuery fq) {
        this(parentShell, designer, fq);
        this.prm = prm;
        if (prm != null) {
            this.pname = prm.getName();
        }
    }

    public AQueryDesigner getDesigner() {
        return this.designer;
    }

    protected void addParameter() {
        if (!this.dataset.getParametersMap().containsValue(this.prm)) {
            try {
                this.dataset.addParameter((JRParameter)this.prm);
            }
            catch (JRException e) {
                UIUtils.showError((Throwable)e);
            }
        }
    }

    protected void okPressed() {
        this.commitValues();
        super.okPressed();
    }

    public String getPname() {
        return this.prm.getName();
    }

    protected void commitValues() {
        if (this.dirty.isEmpty()) {
            return;
        }
        JRDesignDataset ds = this.designer.getjDataset();
        for (JRDesignParameter p : this.dirty) {
            if (ds.getParametersMap().containsKey(p.getName())) {
                ds.removeParameter(p.getName());
            }
            try {
                ds.addParameter((JRParameter)p);
            }
            catch (JRException e) {
                UIUtils.showError((Throwable)e);
            }
        }
        this.designer.setParameters(ds.getParametersList());
    }

    protected void getCompatibleParameters() {
        if (this.dataset != null) {
            ArrayList<String> prms = new ArrayList<String>();
            JRParameter[] jRParameterArray = this.dataset.getParameters();
            int n = jRParameterArray.length;
            int n2 = 0;
            while (n2 < n) {
                JRParameter p = jRParameterArray[n2];
                if (p.getName().equals(this.pname)) {
                    this.prm = (JRDesignParameter)p;
                    prms.add(p.getName());
                    this.parameters.put(p.getName(), (JRDesignParameter)p);
                }
                if (this.isParameterCompatible(p) && !prms.contains(p.getName())) {
                    prms.add(p.getName());
                    this.parameters.put(p.getName(), (JRDesignParameter)p);
                }
                ++n2;
            }
            this.cmb.setItems(prms.toArray(new String[prms.size()]));
        }
        if (Misc.isNullOrEmpty((String)this.pname)) {
            this.cmb.select(0);
            this.pname = this.cmb.getText();
            if (this.dataset != null) {
                this.prm = (JRDesignParameter)this.dataset.getParametersMap().get(this.pname);
            }
        } else {
            this.cmb.setText(Misc.nvl((String)this.pname));
        }
    }

    protected boolean isParameterCompatible(JRParameter p) {
        return true;
    }

    protected String getDefaultParameterType() {
        if (this.prm != null) {
            return this.prm.getValueClassName();
        }
        return String.class.getName();
    }

    protected Control createDialogArea(Composite parent) {
        Composite cmp = (Composite)super.createDialogArea(parent);
        cmp.setLayout((Layout)new GridLayout(3, false));
        new Label(cmp, 0).setText(Messages.SelectParameterDialog_1);
        this.cmb = new Combo(cmp, 8);
        this.getCompatibleParameters();
        this.cmb.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectParameterDialog.this.prm = SelectParameterDialog.this.parameters.get(SelectParameterDialog.this.cmb.getText());
                SelectParameterDialog.this.getButton(0).setEnabled(SelectParameterDialog.this.prm != null);
                SelectParameterDialog.this.wdef.setExpression((JRDesignExpression)SelectParameterDialog.this.prm.getDefaultValueExpression());
                JaspersoftStudioPlugin.getExtensionManager().refreshICUI(SelectParameterDialog.this.prm);
            }
        });
        this.prm = this.parameters.get(this.cmb.getText());
        GridData gd = new GridData(768);
        gd.widthHint = 300;
        this.cmb.setLayoutData((Object)gd);
        Button bnew = new Button(cmp, 8);
        bnew.setText(Messages.SelectParameterDialog_2);
        bnew.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParameterDialog d = new ParameterDialog(SelectParameterDialog.this.cmb.getShell());
                if (d.open() == 0) {
                    String type = SelectParameterDialog.this.getDefaultParameterType();
                    SelectParameterDialog.this.prm = new JRDesignParameter();
                    SelectParameterDialog.this.prm.setName(d.getPname());
                    SelectParameterDialog.this.prm.setValueClassName(type);
                    SelectParameterDialog.this.cmb.add(SelectParameterDialog.this.prm.getName());
                    SelectParameterDialog.this.cmb.setText(SelectParameterDialog.this.prm.getName());
                    SelectParameterDialog.this.parameters.put(SelectParameterDialog.this.prm.getName(), SelectParameterDialog.this.prm);
                    SelectParameterDialog.this.addParameter();
                    SelectParameterDialog.this.wdef.setExpression((JRDesignExpression)SelectParameterDialog.this.prm.getDefaultValueExpression());
                    SelectParameterDialog.this.getButton(0).setEnabled(SelectParameterDialog.this.prm != null);
                    JaspersoftStudioPlugin.getExtensionManager().refreshICUI(SelectParameterDialog.this.prm);
                }
            }
        });
        new Label(cmp, 0).setText(Messages.SelectParameterDialog_5);
        this.wdef = new WTextExpression(cmp, 0);
        if (this.prm != null) {
            this.wdef.setExpression((JRDesignExpression)this.prm.getDefaultValueExpression());
        }
        ExpressionContext exprContext = new ExpressionContext(this.dataset, this.designer.getjConfig());
        this.wdef.addModifyListener(event -> {
            this.prm.setDefaultValueExpression((JRExpression)this.wdef.getExpression());
            this.dirty.add(this.prm);
        });
        this.wdef.setExpressionContext(exprContext);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.wdef.setLayoutData(gd);
        Label sep = new Label(cmp, 258);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        sep.setLayoutData((Object)gd);
        UIUtils.getDisplay().asyncExec(() -> {
            if (this.prm == null) {
                this.getButton(0).setEnabled(false);
            }
        });
        JaspersoftStudioPlugin.getExtensionManager().createParameterICUI(cmp, this.prm, this, this.fq);
        return cmp;
    }

    public void setDirty(JRDesignParameter p) {
        this.dirty.add(p);
    }

    protected String getNewParameterName() {
        return "Parameter";
    }

    class ParameterDialog
    extends ATitledDialog {
        private String pname;

        protected ParameterDialog(Shell parentShell) {
            super(parentShell);
            this.setTitle(Messages.SelectParameterDialog_3);
        }

        public String getPname() {
            return this.pname;
        }

        protected Control createDialogArea(Composite parent) {
            this.pname = SelectParameterDialog.this.getNewParameterName();
            Composite cmp = (Composite)super.createDialogArea(parent);
            cmp.setLayout((Layout)new GridLayout(2, false));
            new Label(cmp, 0).setText(Messages.SelectParameterDialog_4);
            Text txt = new Text(cmp, 2048);
            txt.setText(this.pname);
            GridData gd = new GridData(768);
            gd.widthHint = 300;
            txt.setLayoutData((Object)gd);
            txt.addModifyListener(e -> {
                String t = txt.getText();
                if (t.isEmpty()) {
                    this.setError(Messages.SelectParameterDialog_6);
                    this.getButton(0).setEnabled(false);
                    return;
                }
                for (JRParameter item : SelectParameterDialog.this.dataset.getParametersList()) {
                    if (!t.equals(item.getName())) continue;
                    this.setError(Messages.SelectParameterDialog_7);
                    this.getButton(0).setEnabled(false);
                    return;
                }
                this.setError(null);
                this.getButton(0).setEnabled(true);
                this.pname = t;
            });
            UIUtils.getDisplay().asyncExec(() -> {
                for (JRParameter item : SelectParameterDialog.this.dataset.getParametersList()) {
                    if (!txt.getText().equals(item.getName())) continue;
                    this.setError(Messages.SelectParameterDialog_7);
                    this.getButton(0).setEnabled(false);
                }
            });
            return cmp;
        }
    }
}

