/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.reader;

import com.jaspersoft.studio.data.reader.DataPreviewInterruptedException;
import com.jaspersoft.studio.data.reader.DatasetReaderListener;
import com.jaspersoft.studio.messages.Messages;
import java.util.List;
import net.sf.jasperreports.engine.JRDefaultScriptlet;
import net.sf.jasperreports.engine.JRResultSetDataSource;
import net.sf.jasperreports.engine.JRScriptletException;
import net.sf.jasperreports.engine.JRSortField;
import net.sf.jasperreports.engine.JasperReport;

public class DataPreviewScriptlet
extends JRDefaultScriptlet {
    public static final String PREVIEW_REPORT_PATH = "/resources/data.jrxml";
    public static final String PARAM_COLUMNS = "jss.datapreview.columns";
    public static final String PARAM_LISTENERS = "jss.datapreview.listeners";
    private List<String> columns;
    private List<DatasetReaderListener> listeners;
    private boolean isSorted = false;
    private JasperReport ds = null;

    private boolean isSorted() throws JRScriptletException {
        Object obj;
        if (this.ds == null && (obj = this.getParameterValue("JASPER_REPORT")) instanceof JasperReport) {
            this.ds = (JasperReport)obj;
            JRSortField[] sf = this.ds.getSortFields();
            if (sf != null && sf.length > 0) {
                this.isSorted = true;
            }
        }
        return this.isSorted;
    }

    public void afterDetailEval() throws JRScriptletException {
        Object obj;
        if (this.isSorted() && (obj = this.getParameterValue("REPORT_DATA_SOURCE")) instanceof JRResultSetDataSource) {
            return;
        }
        if (this.columns == null) {
            this.columns = (List)this.getParameterValue(PARAM_COLUMNS);
        }
        if (this.listeners == null) {
            this.listeners = (List)this.getParameterValue(PARAM_LISTENERS);
        }
        Object[] record = new Object[this.columns.size()];
        int i = 0;
        for (String col : this.columns) {
            record[i++] = this.getFieldValue(col);
        }
        for (DatasetReaderListener l : this.listeners) {
            if (!l.isValidStatus()) {
                throw new DataPreviewInterruptedException(Messages.DataPreviewScriptlet_InterruptErrorMsg);
            }
            l.newRecord(record);
        }
        super.afterDetailEval();
    }
}

