/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.storage;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.data.DataAdapterDescriptor;
import com.jaspersoft.studio.data.DataAdapterFactory;
import com.jaspersoft.studio.data.DataAdapterManager;
import com.jaspersoft.studio.data.storage.FileDataAdapterStorage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sf.jasperreports.engine.design.JRDesignDataset;

public abstract class ADataAdapterStorage {
    public static final String PROP_DATAADAPTERS = "DATAADAPTERS";
    private PropertyChangeSupport propChangeSupport = new PropertyChangeSupport((Object)JaspersoftStudioPlugin.getInstance());
    protected Map<String, DataAdapterDescriptor> daDescriptors;

    public abstract String getStorageName();

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propChangeSupport.removePropertyChangeListener(listener);
    }

    public Collection<DataAdapterDescriptor> getDataAdapterDescriptors(JRDesignDataset dataset) {
        if (this.daDescriptors == null) {
            this.daDescriptors = new LinkedHashMap<String, DataAdapterDescriptor>();
            this.findAll();
        }
        return this.daDescriptors.values();
    }

    public Collection<DataAdapterDescriptor> getDataAdapterDescriptors() {
        return this.getDataAdapterDescriptors(null);
    }

    protected String generateDataAdapterName(DataAdapterDescriptor adapter) {
        String adapterName = adapter.getName();
        int counter = 1;
        while (this.daDescriptors.containsKey(adapterName)) {
            adapterName = String.valueOf(adapter.getName()) + "_" + counter;
            ++counter;
        }
        return adapterName;
    }

    protected void forceAddDataAdapter(DataAdapterDescriptor adapter) {
        String adapterName = this.generateDataAdapterName(adapter);
        this.daDescriptors.put(adapterName, adapter);
        this.propChangeSupport.firePropertyChange(PROP_DATAADAPTERS, null, adapter);
    }

    public boolean addDataAdapter(DataAdapterDescriptor adapter) {
        if (!this.daDescriptors.containsKey(adapter.getName())) {
            this.daDescriptors.put(adapter.getName(), adapter);
            this.propChangeSupport.firePropertyChange(PROP_DATAADAPTERS, null, adapter);
            return true;
        }
        return false;
    }

    public boolean removeDataAdapter(DataAdapterDescriptor da) {
        if (da == null) {
            return false;
        }
        if (this.daDescriptors.containsKey(da.getName())) {
            this.daDescriptors.remove(da.getName());
            this.propChangeSupport.firePropertyChange(PROP_DATAADAPTERS, da, null);
            return true;
        }
        String key = this.getUrl(da);
        if (key != null) {
            this.daDescriptors.remove(key);
            this.propChangeSupport.firePropertyChange(PROP_DATAADAPTERS, da, null);
            return true;
        }
        return false;
    }

    public boolean editDataAdapter(String oldName, DataAdapterDescriptor adapter) {
        if (this.daDescriptors.containsKey(oldName) && (adapter.getName().equals(oldName) || !this.daDescriptors.containsKey(adapter.getName()))) {
            this.daDescriptors.remove(oldName);
            this.daDescriptors.put(adapter.getName(), adapter);
            this.propChangeSupport.firePropertyChange(PROP_DATAADAPTERS, null, adapter);
            return true;
        }
        String key = this.getUrl(adapter);
        if (key != null) {
            this.daDescriptors.put(key, adapter);
            this.propChangeSupport.firePropertyChange(PROP_DATAADAPTERS, null, adapter);
            return true;
        }
        return false;
    }

    public String getUrl(DataAdapterDescriptor da) {
        for (Map.Entry<String, DataAdapterDescriptor> desc : this.daDescriptors.entrySet()) {
            if (desc.getValue() != da) continue;
            return desc.getKey();
        }
        return null;
    }

    public boolean isDataAdapterNameValid(String dataAdapterName) {
        if (dataAdapterName == null || "".equals(dataAdapterName.trim())) {
            return false;
        }
        for (DataAdapterDescriptor dataAdapter : this.daDescriptors.values()) {
            if (!dataAdapter.getName().equals(dataAdapterName)) continue;
            return false;
        }
        return true;
    }

    public DataAdapterDescriptor findDataAdapter(String name) {
        if (this.daDescriptors != null) {
            for (DataAdapterDescriptor dataAdapter : this.daDescriptors.values()) {
                if (!dataAdapter.getName().equals(name)) continue;
                return dataAdapter;
            }
        }
        return null;
    }

    public String getLabel(DataAdapterDescriptor d) {
        String label = d.getTitle();
        DataAdapterFactory factory = DataAdapterManager.findFactoryByDataAdapterClass(d.getDataAdapter().getClass().getCanonicalName());
        if (this instanceof FileDataAdapterStorage) {
            label = String.valueOf(label) + " - [" + this.getUrl(d) + "]";
        } else if (factory != null) {
            label = String.valueOf(label) + " - " + factory.getLabel();
        }
        return label;
    }

    public Map<String, DataAdapterDescriptor> getDescriptors() {
        if (this.daDescriptors == null) {
            this.getDataAdapterDescriptors();
        }
        return new HashMap<String, DataAdapterDescriptor>(this.daDescriptors);
    }

    public abstract void findAll();
}

