/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.storage;

import com.jaspersoft.studio.data.DataAdapterDescriptor;
import com.jaspersoft.studio.data.storage.FileDataAdapterStorage;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.repo.RepositoryContext;
import net.sf.jasperreports.repo.RepositoryResourceContext;
import net.sf.jasperreports.repo.RepositoryUtil;
import net.sf.jasperreports.repo.SimpleRepositoryContext;
import net.sf.jasperreports.repo.SimpleRepositoryResourceContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class DataAdapterLocationResolver {
    private String location;
    private JasperReportsConfiguration jConfig;
    private IFile report;
    private DataAdapterDescriptor loadedAdapter = null;
    private String absoluteLocation = null;
    private long lastModfiedDate = -1L;
    private long lastUnsuccessfulSearch = -1L;
    protected static final Long WAIT_TIME_TO_RESCAN = 10000L;

    public DataAdapterLocationResolver(String location, JasperReportsConfiguration jConfig, IFile report) {
        this.location = location;
        this.report = report;
        this.jConfig = jConfig;
    }

    public DataAdapterDescriptor getDataAdapter() {
        if ((this.loadedAdapter == null || this.isObsolete()) && !this.wasAlreadySearched(this.location)) {
            InputStream datasetStream = this.getJRDataAdapterStream(this.location);
            if (datasetStream != null) {
                this.loadedAdapter = FileDataAdapterStorage.readDataADapter(datasetStream, this.report, this.jConfig);
                FileUtils.closeStream((Closeable)datasetStream);
                String absolutePath = this.getAbsoluteLocation(this.location);
                if (absolutePath != null) {
                    this.lastModfiedDate = new File(absolutePath).lastModified();
                }
            } else {
                this.loadedAdapter = null;
                this.lastUnsuccessfulSearch = System.currentTimeMillis();
            }
        }
        return this.loadedAdapter;
    }

    protected InputStream getJRDataAdapterStream(String location) {
        InputStream stream = null;
        if (location != null && !location.isEmpty()) {
            try {
                String parentPath = this.report.getParent().getLocation().toFile().getAbsolutePath();
                SimpleRepositoryResourceContext context = SimpleRepositoryResourceContext.of((String)parentPath);
                SimpleRepositoryContext repoContext = SimpleRepositoryContext.of((JasperReportsContext)this.jConfig, (RepositoryResourceContext)context);
                stream = RepositoryUtil.getInstance((RepositoryContext)repoContext).getInputStreamFromLocation(location);
            }
            catch (Exception exception) {}
        }
        return stream;
    }

    private boolean wasAlreadySearched(String location) {
        if (this.lastUnsuccessfulSearch != -1L) {
            long timePast = System.currentTimeMillis() - this.lastUnsuccessfulSearch;
            if (timePast > WAIT_TIME_TO_RESCAN) {
                this.lastUnsuccessfulSearch = -1L;
                return false;
            }
            return true;
        }
        return false;
    }

    private String getAbsoluteLocation(String location) {
        if (location != null) {
            IFile folderFile;
            if (this.absoluteLocation != null) {
                return this.absoluteLocation;
            }
            File file = new File(location);
            if (file.exists()) {
                this.absoluteLocation = location;
                return location;
            }
            Path path = new Path(location);
            try {
                folderFile = this.report.getParent().getFile((IPath)path);
                if (folderFile.exists()) {
                    String absolutePath;
                    this.absoluteLocation = absolutePath = new File(folderFile.getLocationURI()).getAbsolutePath();
                    return absolutePath;
                }
            }
            catch (Exception exception) {}
            try {
                folderFile = this.report.getProject().getFile((IPath)path);
                if (folderFile.exists()) {
                    String absolutePath;
                    this.absoluteLocation = absolutePath = new File(folderFile.getLocationURI()).getAbsolutePath();
                    return absolutePath;
                }
            }
            catch (Exception exception) {}
            if (FileUtils.isValidURL((String)location)) {
                try {
                    file = new File(new URI(location));
                    if (file.exists()) {
                        String absolutePath;
                        this.absoluteLocation = absolutePath = file.getAbsolutePath();
                        return absolutePath;
                    }
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }

    private boolean isObsolete() {
        String absolutePath = this.getAbsoluteLocation(this.location);
        if (absolutePath != null) {
            File file = new File(absolutePath);
            if (this.lastModfiedDate == file.lastModified()) {
                return false;
            }
            this.lastModfiedDate = file.lastModified();
            return true;
        }
        return false;
    }

    public String getAdapterURL() {
        if (FileUtils.isValidURL((String)this.location)) {
            return this.location;
        }
        try {
            File resource = FileUtils.findFile((IFile)this.report, (String)this.location, (JasperReportsContext)this.jConfig);
            if (resource != null && resource.exists()) {
                return resource.toURI().toURL().toExternalForm();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }
}

