/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.storage;

import com.jaspersoft.studio.ConfigurationManager;
import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.data.DataAdapterDescriptor;
import com.jaspersoft.studio.data.DataAdapterFactory;
import com.jaspersoft.studio.data.DataAdapterManager;
import com.jaspersoft.studio.data.storage.ADataAdapterStorage;
import com.jaspersoft.studio.data.storage.DataAdapterNameConverter;
import com.jaspersoft.studio.data.storage.FileDataAdapterStorage;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.jasperreports.data.DataAdapter;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.util.JRXmlUtils;
import net.sf.jasperreports.util.CastorUtil;
import net.sf.jasperreports.util.JacksonRuntimException;
import net.sf.jasperreports.util.JacksonUtil;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class PreferencesDataAdapterStorage
extends ADataAdapterStorage {
    private HashMap<DataAdapterDescriptor, String> fileAdapterMap = new HashMap();
    public static final String PREF_KEYS_DATA_ADAPTERS = "dataAdapters";
    private static DataAdapterNameConverter convertDataAdapterName = new DataAdapterNameConverter();

    @Override
    public void findAll() {
        ConfigurationManager.convertPropertyToStorage(PREF_KEYS_DATA_ADAPTERS, PREF_KEYS_DATA_ADAPTERS, convertDataAdapterName);
        File[] storageContent = ConfigurationManager.getStorageContent(PREF_KEYS_DATA_ADAPTERS);
        JasperReportsConfiguration jConf = JasperReportsConfiguration.getDefaultInstance();
        File[] fileArray = storageContent;
        int n = storageContent.length;
        int n2 = 0;
        while (n2 < n) {
            block19: {
                FileInputStream inputStream;
                block17: {
                    DataAdapterFactory factory;
                    File storageElement;
                    block18: {
                        Node namedItem;
                        NamedNodeMap attributes;
                        storageElement = fileArray[n2];
                        inputStream = null;
                        inputStream = new FileInputStream(storageElement);
                        InputStreamReader reader = new InputStreamReader((InputStream)inputStream, "UTF-8");
                        InputSource is = new InputSource(reader);
                        is.setEncoding("UTF-8");
                        Document document = JRXmlUtils.parse((InputSource)is);
                        Element adapterNode = document.getDocumentElement();
                        if (adapterNode == null || (attributes = adapterNode.getAttributes()) == null || (namedItem = attributes.getNamedItem("class")) == null) break block17;
                        String adapterClassName = namedItem.getNodeValue();
                        factory = DataAdapterManager.findFactoryByDataAdapterClass(adapterClassName);
                        if (factory != null) break block18;
                        JaspersoftStudioPlugin.getInstance().getLog().log((IStatus)new Status(2, JaspersoftStudioPlugin.getUniqueIdentifier(), 0, String.valueOf(Messages.DataAdapterManager_nodataadapterfound) + adapterClassName, null));
                        FileUtils.closeStream((Closeable)inputStream);
                        break block19;
                    }
                    try {
                        try {
                            DataAdapterDescriptor dataAdapterDescriptor = factory.createDataAdapter();
                            DataAdapter dataAdapter = dataAdapterDescriptor.getDataAdapter();
                            ((InputStream)inputStream).close();
                            inputStream = new FileInputStream(storageElement);
                            try {
                                dataAdapter = (DataAdapter)JacksonUtil.getInstance((JasperReportsContext)jConf).loadXml((InputStream)inputStream, DataAdapter.class);
                            }
                            catch (JacksonRuntimException jacksonRuntimException) {
                                ((InputStream)inputStream).close();
                                inputStream = new FileInputStream(storageElement);
                                dataAdapter = (DataAdapter)CastorUtil.getInstance((JasperReportsContext)jConf).read((InputStream)inputStream);
                            }
                            dataAdapterDescriptor.setDataAdapter(dataAdapter);
                            super.forceAddDataAdapter(dataAdapterDescriptor);
                            this.fileAdapterMap.put(dataAdapterDescriptor, storageElement.getName());
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            FileUtils.closeStream((Closeable)inputStream);
                            break block19;
                        }
                    }
                    catch (Throwable throwable) {
                        FileUtils.closeStream(inputStream);
                        throw throwable;
                    }
                }
                FileUtils.closeStream((Closeable)inputStream);
            }
            ++n2;
        }
        if (this.daDescriptors.size() == 0) {
            Bundle bundle = JaspersoftStudioPlugin.getInstance().getBundle();
            Enumeration urls = bundle.findEntries("defaults/dataadapter/prefs/", "*.xml", true);
            while (urls.hasMoreElements()) {
                InputStream in = null;
                try {
                    try {
                        in = ((URL)urls.nextElement()).openStream();
                        DataAdapterDescriptor dad = FileDataAdapterStorage.readDataADapter(in, null, jConf);
                        if (dad != null) {
                            this.addDataAdapter(dad);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        FileUtils.closeStream((Closeable)in);
                        continue;
                    }
                }
                catch (Throwable inputStream) {
                    FileUtils.closeStream(in);
                    throw inputStream;
                }
                FileUtils.closeStream((Closeable)in);
            }
        }
        for (DataAdapterDescriptor dad : JaspersoftStudioPlugin.getDefaultDAManager().getDefaultDAs()) {
            DataAdapter adapter;
            String adapterClassName;
            DataAdapterFactory factory;
            DataAdapterDescriptor oldDa = (DataAdapterDescriptor)this.daDescriptors.get(dad.getName());
            if (oldDa != null && !oldDa.getClass().getCanonicalName().equals(dad.getClass().getCanonicalName())) {
                this.removeDataAdapter(oldDa);
            }
            if ((factory = DataAdapterManager.findFactoryByDataAdapterClass(adapterClassName = (adapter = dad.getDataAdapter()).getClass().getName())) == null) continue;
            this.addDataAdapter(dad);
        }
    }

    protected void save(DataAdapterDescriptor adapter) {
        String fileName = convertDataAdapterName.getFileName(null);
        this.save(adapter, fileName);
    }

    protected void save(DataAdapterDescriptor adapter, String fileName) {
        block5: {
            FileOutputStream stream = null;
            try {
                try {
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    Document doc = builder.parse(new InputSource(new StringReader(adapter.toXml((JasperReportsContext)JasperReportsConfiguration.getDefaultInstance()))));
                    TransformerFactory transformerFactory = TransformerFactory.newInstance();
                    Transformer transformer = transformerFactory.newTransformer();
                    DOMSource source = new DOMSource(doc);
                    File storage = ConfigurationManager.getStorage(PREF_KEYS_DATA_ADAPTERS);
                    File destination = new File(storage, fileName);
                    stream = new FileOutputStream(destination);
                    StreamResult result = new StreamResult(stream);
                    transformer.transform(source, result);
                    this.fileAdapterMap.put(adapter, fileName);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    FileUtils.closeStream(stream);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                FileUtils.closeStream(stream);
                throw throwable;
            }
            FileUtils.closeStream((Closeable)stream);
        }
    }

    @Override
    public boolean removeDataAdapter(DataAdapterDescriptor da) {
        boolean result = super.removeDataAdapter(da);
        if (result) {
            ConfigurationManager.removeStoregeResource(PREF_KEYS_DATA_ADAPTERS, this.fileAdapterMap.get(da));
            return true;
        }
        return false;
    }

    @Override
    public boolean addDataAdapter(DataAdapterDescriptor adapter) {
        boolean result = super.addDataAdapter(adapter);
        if (result) {
            this.save(adapter);
            return true;
        }
        return false;
    }

    @Override
    public boolean editDataAdapter(String oldName, DataAdapterDescriptor adapter) {
        boolean result = super.editDataAdapter(oldName, adapter);
        if (result) {
            String fileName = this.fileAdapterMap.get(adapter);
            ConfigurationManager.removeStoregeResource(PREF_KEYS_DATA_ADAPTERS, fileName);
            this.save(adapter, fileName);
            return true;
        }
        return false;
    }

    @Override
    public String getStorageName() {
        return Messages.PreferencesDataAdapterStorage_3;
    }
}

