/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.storage;

import com.jaspersoft.studio.ConfigurationManager;
import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.data.storage.TemplateNameConverter;
import com.jaspersoft.studio.editor.style.TemplateStyle;
import com.jaspersoft.studio.preferences.util.PropertiesHelper;
import com.jaspersoft.studio.style.view.TemplateViewProvider;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.engine.util.JRXmlUtils;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class PreferencesTemplateStylesStorage {
    private static final String PREF_KEYS_STYLES = "templateStyles";
    public static final String PROPERTY_CHANGE_NAME = "TEMPLATESTYLES";
    protected Map<String, List<TemplateStyle>> styleDescriptors;
    private static Map<String, TemplateStyle> availableStyles = null;
    private PropertyChangeSupport propChangeSupport = new PropertyChangeSupport((Object)JaspersoftStudioPlugin.getInstance());
    private static final String STYLE_ID = "STYLE_ID6358649593550007203L";

    private TemplateStyle getBuilder(String className) {
        this.initAvailableStyles();
        return availableStyles.get(className);
    }

    private void initAvailableStyles() {
        if (availableStyles == null) {
            availableStyles = new HashMap<String, TemplateStyle>();
            for (TemplateViewProvider e : JaspersoftStudioPlugin.getExtensionManager().getStylesViewProvider()) {
                TemplateStyle builder = e.getBuilder();
                availableStyles.put(builder.getTemplateName(), builder);
            }
        }
    }

    private String[] getAvailableStylesType() {
        this.initAvailableStyles();
        Set<String> types = availableStyles.keySet();
        return types.toArray(new String[types.size()]);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propChangeSupport.removePropertyChangeListener(listener);
    }

    public void addStyle(TemplateStyle style) {
        File nodeStorage = ConfigurationManager.getStorage(style.getTemplateName());
        TemplateNameConverter converter = TemplateNameConverter.getConverter(style.getTemplateName());
        File xmlTargetFile = new File(nodeStorage, converter.getFileName(null));
        while (xmlTargetFile.exists()) {
            xmlTargetFile = new File(nodeStorage, converter.getFileName(null));
        }
        style.storePropertiy(STYLE_ID, xmlTargetFile.getName());
        List<TemplateStyle> styles = this.styleDescriptors.get(style.getTemplateName());
        if (styles == null) {
            styles = new ArrayList<TemplateStyle>();
            this.styleDescriptors.put(style.getTemplateName(), styles);
        }
        styles.add(style);
        this.save(style, xmlTargetFile);
        this.propChangeSupport.firePropertyChange(PROPERTY_CHANGE_NAME, "ADD", style);
    }

    private int getStyleIndex(List<TemplateStyle> searchSet, TemplateStyle searchedStyle) {
        String id = (String)searchedStyle.getProperty(STYLE_ID);
        if (id != null) {
            int currentIndex = 0;
            for (TemplateStyle style : searchSet) {
                String currentId = (String)style.getProperty(STYLE_ID);
                if (id.equals(currentId)) {
                    return currentIndex;
                }
                ++currentIndex;
            }
        }
        return -1;
    }

    public void editStyle(TemplateStyle oldStyle, TemplateStyle newStyle) {
        String id = (String)oldStyle.getProperty(STYLE_ID);
        if (id != null) {
            int oldIndex;
            List<TemplateStyle> styles = this.styleDescriptors.get(oldStyle.getTemplateName());
            if (styles == null) {
                styles = new ArrayList<TemplateStyle>();
                this.styleDescriptors.put(oldStyle.getTemplateName(), styles);
            }
            if ((oldIndex = this.getStyleIndex(styles, oldStyle)) != -1) {
                styles.set(oldIndex, newStyle);
            } else {
                styles.add(newStyle);
            }
            newStyle.storePropertiy(STYLE_ID, id);
            ConfigurationManager.removeStoregeResource(oldStyle.getTemplateName(), id);
            File replacement = new File(ConfigurationManager.getStorage(oldStyle.getTemplateName()), id);
            this.save(newStyle, replacement);
            this.propChangeSupport.firePropertyChange(PROPERTY_CHANGE_NAME, "EDIT", newStyle);
        }
    }

    public void removeStyle(TemplateStyle style) {
        String id = (String)style.getProperty(STYLE_ID);
        if (id != null) {
            int oldIndex;
            List<TemplateStyle> styles = this.styleDescriptors.get(style.getTemplateName());
            if (styles == null) {
                styles = new ArrayList<TemplateStyle>();
                this.styleDescriptors.put(style.getTemplateName(), styles);
            }
            if ((oldIndex = this.getStyleIndex(styles, style)) != -1) {
                styles.remove(oldIndex);
            }
            ConfigurationManager.removeStoregeResource(style.getTemplateName(), id);
            this.propChangeSupport.firePropertyChange(PROPERTY_CHANGE_NAME, "DELETE", style);
        }
    }

    private void findAll() {
        this.doSilentConversion();
        String[] stringArray = this.getAvailableStylesType();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String templateType = stringArray[n2];
            File[] storageContent = ConfigurationManager.getStorageContent(templateType);
            TemplateStyle factory = this.getBuilder(templateType);
            List<TemplateStyle> foundTemplates = this.styleDescriptors.get(templateType);
            if (foundTemplates == null) {
                foundTemplates = new ArrayList<TemplateStyle>();
                this.styleDescriptors.put(templateType, foundTemplates);
            }
            if (factory != null) {
                File[] fileArray = storageContent;
                int n3 = storageContent.length;
                int n4 = 0;
                while (n4 < n3) {
                    File storageElement = fileArray[n4];
                    try {
                        FileInputStream inputStream = new FileInputStream(storageElement);
                        InputStreamReader reader = new InputStreamReader((InputStream)inputStream, "UTF-8");
                        InputSource is = new InputSource(reader);
                        is.setEncoding("UTF-8");
                        Document document = JRXmlUtils.parse((InputSource)is);
                        TemplateStyle readStyle = factory.buildFromXML(document.getDocumentElement());
                        readStyle.storePropertiy(STYLE_ID, storageElement.getName());
                        foundTemplates.add(readStyle);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private void doSilentConversion() {
        try {
            IEclipsePreferences prefs = PropertiesHelper.INSTANCE_SCOPE.getNode(JaspersoftStudioPlugin.getUniqueIdentifier());
            String xml = prefs.get(PREF_KEYS_STYLES, null);
            if (xml != null) {
                Document document = JRXmlUtils.parse((InputSource)new InputSource(new StringReader(xml)));
                NodeList adapterNodes = document.getDocumentElement().getChildNodes();
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                int i = 0;
                while (i < adapterNodes.getLength()) {
                    Node adapterNode = adapterNodes.item(i);
                    if (adapterNode.getNodeType() == 1) {
                        String type = adapterNode.getAttributes().getNamedItem("type").getNodeValue();
                        File nodeStorage = ConfigurationManager.getStorage(type);
                        DOMSource source = new DOMSource(adapterNode);
                        TemplateNameConverter converter = TemplateNameConverter.getConverter(type);
                        File xmlTargetFile = new File(nodeStorage, converter.getFileName(adapterNode));
                        while (xmlTargetFile.exists()) {
                            xmlTargetFile = new File(nodeStorage, converter.getFileName(adapterNode));
                        }
                        StreamResult result = new StreamResult(xmlTargetFile);
                        transformer.transform(source, result);
                    }
                    ++i;
                }
                prefs.remove(PREF_KEYS_STYLES);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getUniqueId(TemplateStyle style) {
        String type = style.getTemplateName();
        File nodeStorage = ConfigurationManager.getStorage(type);
        TemplateNameConverter converter = TemplateNameConverter.getConverter(type);
        File xmlTargetFile = new File(nodeStorage, converter.getFileName(null));
        while (xmlTargetFile.exists()) {
            xmlTargetFile = new File(nodeStorage, converter.getFileName(null));
        }
        return xmlTargetFile.getName();
    }

    public List<TemplateStyle> readTemplateFromFile(String xml) {
        ArrayList<TemplateStyle> result;
        block8: {
            result = new ArrayList<TemplateStyle>();
            if (xml != null) {
                ByteArrayInputStream inputStream = null;
                try {
                    try {
                        inputStream = new ByteArrayInputStream(xml.getBytes());
                        DocumentBuilderFactory documentFactory = DocumentBuilderFactory.newInstance();
                        DocumentBuilder builder = documentFactory.newDocumentBuilder();
                        Document document = builder.parse(inputStream);
                        NodeList adapterNodes = document.getDocumentElement().getChildNodes();
                        int i = 0;
                        while (i < adapterNodes.getLength()) {
                            String className;
                            TemplateStyle factory;
                            Node adapterNode = adapterNodes.item(i);
                            if (adapterNode.getNodeType() == 1 && adapterNode.getAttributes().getNamedItem("type") != null && (factory = this.getBuilder(className = adapterNode.getAttributes().getNamedItem("type").getNodeValue())) != null) {
                                TemplateStyle readStyle = factory.buildFromXML(adapterNode);
                                readStyle.storePropertiy(STYLE_ID, this.getUniqueId(readStyle));
                                result.add(readStyle);
                            }
                            ++i;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        FileUtils.closeStream((Closeable)inputStream);
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    FileUtils.closeStream(inputStream);
                    throw throwable;
                }
                FileUtils.closeStream((Closeable)inputStream);
            }
        }
        return result;
    }

    public Collection<TemplateStyle> getStylesDescriptors(String templateType) {
        if (this.styleDescriptors == null) {
            this.styleDescriptors = new LinkedHashMap<String, List<TemplateStyle>>();
            this.findAll();
        }
        return this.styleDescriptors.get(templateType);
    }

    private void save(TemplateStyle template, File destination) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(new StringReader(template.getXMLData())));
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            FileOutputStream stream = new FileOutputStream(destination);
            StreamResult result = new StreamResult(stream);
            transformer.transform(source, result);
            stream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

