/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.ui;

import com.jaspersoft.studio.data.AWizardDataEditorComposite;
import com.jaspersoft.studio.data.DataAdapterDescriptor;
import com.jaspersoft.studio.data.designer.UndoRedoImpl;
import com.jaspersoft.studio.data.fields.IFieldsProvider;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.preferences.fonts.utils.FontUtils;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.wizards.JSSWizardRunnablePage;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.data.DataAdapterService;
import net.sf.jasperreports.data.DataAdapterServiceUtil;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.ParameterContributorContext;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import net.sf.jasperreports.engine.design.JRDesignQuery;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class SimpleQueryWizardDataEditorComposite
extends AWizardDataEditorComposite {
    protected String[] langs;
    private int questionReturnCode = 32;
    private DataAdapterDescriptor dataAdapterDescriptor;
    protected JRDesignDataset dataset = null;
    private String queryString = "";
    private Label lblTitle = null;
    private String queryLanguage = null;
    protected StyledText styledText = null;
    private String title = null;
    private DataAdapterService das;

    public SimpleQueryWizardDataEditorComposite(Composite parent, WizardPage page, String lang) {
        this(parent, page, null, lang, new String[]{lang});
    }

    public SimpleQueryWizardDataEditorComposite(Composite parent, WizardPage page, DataAdapterDescriptor dataAdapterDescriptor) {
        this(parent, page, dataAdapterDescriptor, "", new String[0]);
    }

    public SimpleQueryWizardDataEditorComposite(Composite parent, WizardPage page, DataAdapterDescriptor dataAdapterDescriptor, String lang) {
        this(parent, page, dataAdapterDescriptor, lang, new String[]{lang});
    }

    public SimpleQueryWizardDataEditorComposite(Composite parent, WizardPage page, DataAdapterDescriptor dataAdapterDescriptor, String lang, String[] langs) {
        super(parent, page);
        this.langs = langs;
        this.setQueryLanguage(lang);
        this.dataAdapterDescriptor = dataAdapterDescriptor;
        this.init();
        this.createCompositeContent();
    }

    protected void init() {
    }

    protected void createCompositeContent() {
        this.setLayout((Layout)new FormLayout());
        this.lblTitle = new Label((Composite)this, 0);
        FormData fdTitle = new FormData();
        fdTitle.top = new FormAttachment(0);
        fdTitle.left = new FormAttachment(0);
        fdTitle.right = new FormAttachment(100);
        this.lblTitle.setLayoutData((Object)fdTitle);
        if (this.getTitle() != null) {
            this.lblTitle.setText(this.getTitle());
        }
        this.styledText = new StyledText((Composite)this, 2048);
        new UndoRedoImpl(this.styledText);
        FormData fdSt = new FormData();
        fdSt.bottom = new FormAttachment(100);
        fdSt.right = new FormAttachment(100);
        fdSt.top = new FormAttachment((Control)this.lblTitle, 6);
        fdSt.left = new FormAttachment((Control)this.lblTitle, 0, 16384);
        this.styledText.setLayoutData((Object)fdSt);
        this.styledText.setFont(FontUtils.getEditorsFont(this.getJasperReportsConfiguration()));
        this.styledText.addModifyListener(e -> {
            String string = this.queryString = this.styledText.getText().trim();
        });
        this.queryString = this.styledText.getText().trim();
    }

    @Override
    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String querystring) {
        this.queryString = querystring;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        if (this.lblTitle != null) {
            this.lblTitle.setText(title);
        }
    }

    @Override
    public String getQueryLanguage() {
        return this.queryLanguage;
    }

    public void setQueryLanguage(String queryLanguage) {
        this.queryLanguage = queryLanguage;
    }

    @Override
    public List<JRDesignField> readFields() throws Exception {
        List<JRDesignField> fields;
        block10: {
            fields = null;
            DataAdapterDescriptor dad = this.getDataAdapterDescriptor();
            if (dad != null && dad instanceof IFieldsProvider) {
                this.questionReturnCode = 32;
                JasperReportsConfiguration jContext = this.getJasperReportsConfiguration();
                this.das = DataAdapterServiceUtil.getInstance((ParameterContributorContext)new ParameterContributorContext((JasperReportsContext)jContext, null, null)).getService(dad.getDataAdapter());
                try {
                    try {
                        JRDesignDataset tmpDataset = this.getDataset();
                        if (tmpDataset.getQuery().getText() == null || tmpDataset.getQuery().getText().trim().length() == 0) {
                            Display.getDefault().syncExec(() -> {
                                MessageBox dialog = new MessageBox(UIUtils.getShell(), 292);
                                dialog.setText(Messages.SimpleQueryWizardDataEditorComposite_noQueryProvidedTitle);
                                dialog.setMessage(Messages.SimpleQueryWizardDataEditorComposite_noQueryProvidedText);
                                this.questionReturnCode = dialog.open();
                            });
                            if (this.questionReturnCode != 32) {
                                throw JSSWizardRunnablePage.USER_CANCEL_EXCEPTION;
                            }
                        } else {
                            fields = ((IFieldsProvider)((Object)dad)).getFields(this.das, jContext, (JRDataset)this.dataset);
                        }
                    }
                    catch (JRException ex) {
                        Display.getDefault().syncExec(() -> {
                            String errorMsg = ex.getMessage();
                            if (ex.getCause() != null && ex.getCause() instanceof Exception) {
                                errorMsg = ex.getCause().getMessage();
                            }
                            this.getPage().setErrorMessage(errorMsg);
                            boolean answer = MessageDialog.openQuestion((Shell)UIUtils.getShell(), (String)Messages.SimpleQueryWizardDataEditorComposite_QueryErrorTitle, (String)NLS.bind((String)Messages.SimpleQueryWizardDataEditorComposite_QueryErrorMsg, (Object)errorMsg));
                            this.questionReturnCode = answer ? 32 : 256;
                        });
                        if (this.questionReturnCode != 32) {
                            throw JSSWizardRunnablePage.USER_CANCEL_EXCEPTION;
                        }
                        this.das.dispose();
                        this.das = null;
                        break block10;
                    }
                }
                catch (Throwable throwable) {
                    this.das.dispose();
                    this.das = null;
                    throw throwable;
                }
                this.das.dispose();
                this.das = null;
            }
        }
        return (List)Misc.nvl(fields, new ArrayList());
    }

    @Override
    public void abortOperationOccured() {
        if (this.das != null) {
            this.das.dispose();
        }
    }

    public JRDesignDataset getDataset() {
        if (this.dataset == null) {
            this.dataset = new JRDesignDataset((JasperReportsContext)this.getJasperReportsConfiguration(), true);
            JRDesignQuery query = new JRDesignQuery();
            query.setLanguage(this.getQueryLanguage());
            this.dataset.setQuery(query);
        }
        ((JRDesignQuery)this.dataset.getQuery()).setText(this.getQueryString());
        return this.dataset;
    }

    public DataAdapterDescriptor getDataAdapterDescriptor() {
        return this.dataAdapterDescriptor;
    }

    public void setDataAdapterDescriptor(DataAdapterDescriptor dataAdapterDescriptor) {
        this.dataAdapterDescriptor = dataAdapterDescriptor;
    }

    @Override
    public List<JRDesignParameter> readParameters() throws Exception {
        if (this.dataset != null) {
            ArrayList<JRDesignParameter> prms = new ArrayList<JRDesignParameter>();
            for (JRParameter p : this.dataset.getParametersList()) {
                if (p.isSystemDefined()) continue;
                prms.add((JRDesignParameter)p);
            }
            return prms;
        }
        return null;
    }
}

