/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.wizard;

import com.jaspersoft.studio.data.DataAdapterDescriptor;
import com.jaspersoft.studio.data.DataAdapterManager;
import com.jaspersoft.studio.data.storage.ADataAdapterStorage;
import com.jaspersoft.studio.data.wizard.AbstractDataAdapterWizard;
import com.jaspersoft.studio.data.wizard.pages.DataAdapterEditorPage;
import com.jaspersoft.studio.data.wizard.pages.DataAdaptersListPage;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import net.sf.jasperreports.engine.JasperReportsContext;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;

public class DataAdapterWizard
extends AbstractDataAdapterWizard
implements SelectionListener {
    public DataAdapterWizard(ADataAdapterStorage storage) {
        this.setWindowTitle(Messages.DataAdapterWizard_windowtitle);
        this.storage = storage;
        this.setConfig(JasperReportsConfiguration.getDefaultInstance(), false);
    }

    public DataAdapterWizard(DataAdapterDescriptor dataAdapter, ADataAdapterStorage storage) {
        this(storage);
        this.dataAdapter = dataAdapter;
    }

    @Override
    public void addPages() {
        if (this.dataAdapter == null) {
            this.dataAdapterListPage = new DataAdaptersListPage();
            this.addPage((IWizardPage)this.dataAdapterListPage);
        }
        this.dataAdapterEditorPage = new DataAdapterEditorPage();
        this.dataAdapterEditorPage.setStorage(this.storage);
        if (this.dataAdapter != null) {
            this.dataAdapterEditorPage.setEditMode(true);
        }
        this.addPage((IWizardPage)this.dataAdapterEditorPage);
    }

    @Override
    public IWizardPage getNextPage(IWizardPage page) {
        if (page instanceof DataAdapterEditorPage) {
            ((DataAdapterEditorPage)page).setJrContext((JasperReportsContext)this.getConfig());
        }
        return super.getNextPage(page);
    }

    @Override
    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        if (this.dataAdapter != null) {
            DataAdapterDescriptor editedDataAdapter = DataAdapterManager.cloneDataAdapter(this.dataAdapter, (JasperReportsContext)this.getConfig());
            this.dataAdapterEditorPage.setDataAdapter(editedDataAdapter);
        }
    }

    @Override
    public boolean performFinish() {
        DataAdapterDescriptor editedDataAdapter = this.dataAdapterEditorPage.getDataAdapter();
        this.dataAdapterEditorPage.performFinishInvoked();
        if (this.dataAdapter == null) {
            this.dataAdapter = editedDataAdapter;
        } else {
            String oldName = this.dataAdapter.getName();
            this.dataAdapter.setDataAdapter(editedDataAdapter.getDataAdapter());
            if (!oldName.equals(editedDataAdapter.getName()) && !this.storage.isDataAdapterNameValid(editedDataAdapter.getName())) {
                this.dataAdapter.getDataAdapter().setName(editedDataAdapter.getName());
            }
        }
        return true;
    }
}

