/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.wizard;

import com.jaspersoft.studio.data.adapter.IReportDescriptor;
import com.jaspersoft.studio.data.adapter.ImportUtility;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.wizards.ContextHelpIDs;
import com.jaspersoft.studio.wizards.JSSHelpWizardPage;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ListInstallationPage
extends JSSHelpWizardPage {
    private IReportDescriptor selectedElement = null;
    private Button lastRadioSelected = null;
    protected Button customRadio;

    private void updateRadio(Button actualySelected) {
        if (this.lastRadioSelected != null && this.lastRadioSelected != actualySelected) {
            this.lastRadioSelected.setSelection(false);
        }
        this.lastRadioSelected = actualySelected;
    }

    public ListInstallationPage() {
        super("IReportInstallationsList");
        this.setTitle(Messages.ListInstallationPage_title);
        this.setDescription(Messages.ListInstallationPage_description);
        this.setPageComplete(false);
    }

    protected List<IReportDescriptor> getFoundedConfiguration() {
        return ImportUtility.getIReportConfigurationFolder();
    }

    public void createControl(Composite parent) {
        List<IReportDescriptor> list = this.getFoundedConfiguration();
        Composite mainComposite = new Composite(parent, 0);
        mainComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        Label titleLabel = new Label(mainComposite, 0);
        titleLabel.setText(Messages.ListInstallationPage_label);
        GridData labelData = new GridData(4, 0x1000000, true, false);
        labelData.heightHint = 25;
        titleLabel.setLayoutData((Object)labelData);
        ScrolledComposite scrollComp = new ScrolledComposite(mainComposite, 768);
        scrollComp.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).hint(-1, 200).create());
        scrollComp.setLayout((Layout)new GridLayout(1, false));
        scrollComp.setExpandHorizontal(true);
        scrollComp.setExpandVertical(true);
        Composite content = new Composite((Composite)scrollComp, 0);
        scrollComp.setContent((Control)content);
        content.setLayout((Layout)new GridLayout(1, false));
        content.setLayoutData((Object)new GridData(4, 16384, true, false));
        RadioSelection selectionListener = new RadioSelection();
        for (IReportDescriptor desc : list) {
            Button radio = new Button(content, 16);
            radio.setText(String.valueOf(desc.getName()) + "  (" + desc.getFile().getAbsolutePath() + ")");
            radio.setData((Object)desc);
            radio.addSelectionListener((SelectionListener)selectionListener);
        }
        this.createCustomPathPanel(content);
        scrollComp.setMinSize(content.computeSize(-1, -1));
        if (list.size() == 0) {
            this.customRadio.setSelection(true);
            this.customRadio.setVisible(false);
            GridData excludeLayout = new GridData(4, 16384, true, false);
            excludeLayout.exclude = true;
            this.customRadio.setLayoutData((Object)excludeLayout);
            this.customRadio.getParent().layout();
        }
        this.setControl((Control)mainComposite);
    }

    protected String getPath() {
        FileDialog fd = new FileDialog(UIUtils.getShell(), 4096);
        fd.setText(Messages.ListInstallationPage_openDialog);
        String[] filterExt = new String[]{"ireport.properties"};
        fd.setFileName("ireport.properties");
        fd.setFilterExtensions(filterExt);
        return fd.open();
    }

    protected IReportDescriptor getDescriptor(String path) {
        return ImportUtility.GetDescriptor(path);
    }

    private void createCustomPathPanel(Composite mainComposite) {
        final Composite customLocComposite = new Composite(mainComposite, 0);
        GridLayout customLocLayout = new GridLayout(3, false);
        customLocLayout.marginWidth = 0;
        customLocLayout.horizontalSpacing = 2;
        customLocComposite.setLayout((Layout)customLocLayout);
        customLocComposite.setLayoutData((Object)new GridData(4, 16384, true, false));
        this.customRadio = new Button(customLocComposite, 16);
        final Label radioLabel = new Label(customLocComposite, 0);
        radioLabel.setText(Messages.ListInstallationPage_customLocation);
        Button browse = new Button(customLocComposite, 0);
        browse.setText(Messages.ListInstallationPage_browse);
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IReportDescriptor desc;
                String selected = ListInstallationPage.this.getPath();
                if (selected != null && (desc = ListInstallationPage.this.getDescriptor(selected)) != null) {
                    ListInstallationPage.this.customRadio.setData((Object)desc);
                    ListInstallationPage.this.customRadio.setToolTipText(selected);
                    if (selected.length() > 60) {
                        selected = String.valueOf(selected.substring(0, 10)) + "...." + selected.substring(selected.length() - 60);
                    }
                    radioLabel.setText(selected);
                    customLocComposite.layout();
                    if (ListInstallationPage.this.customRadio.getSelection()) {
                        ListInstallationPage.this.setPageComplete(true);
                    }
                }
            }
        });
        this.customRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ListInstallationPage.this.customRadio.getData() != null) {
                    ListInstallationPage.this.selectedElement = (IReportDescriptor)e.widget.getData();
                    ListInstallationPage.this.setPageComplete(true);
                } else {
                    ListInstallationPage.this.setPageComplete(false);
                }
                ListInstallationPage.this.updateRadio(ListInstallationPage.this.customRadio);
            }
        });
    }

    public IReportDescriptor getSelection() {
        return this.selectedElement;
    }

    @Override
    protected String getContextName() {
        return ContextHelpIDs.WIZARD_IMPORT_SELECT_IREPORT;
    }

    private class RadioSelection
    extends SelectionAdapter {
        private RadioSelection() {
        }

        public void widgetSelected(SelectionEvent e) {
            ListInstallationPage.this.selectedElement = (IReportDescriptor)e.widget.getData();
            ListInstallationPage.this.setPageComplete(true);
            ListInstallationPage.this.updateRadio((Button)e.widget);
        }
    }
}

