/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.wizard;

import com.jaspersoft.studio.data.adapter.IReportDescriptor;
import com.jaspersoft.studio.data.adapter.ImportUtility;
import com.jaspersoft.studio.data.wizard.ListInstallationPage;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.wizards.ContextHelpIDs;
import com.jaspersoft.studio.wizards.JSSHelpWizardPage;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.util.JRXmlUtils;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.xml.sax.InputSource;

public class ShowAdaptersPage
extends JSSHelpWizardPage {
    protected IReportDescriptor selectedInstallation;
    protected List<Button> selectedElements = new ArrayList<Button>();
    protected Composite content;
    protected Label noElementLabel = null;

    protected ShowAdaptersPage() {
        super("IReportDatasourceList");
        this.setTitle(Messages.ShowAdaptersPage_title);
        this.setDescription(Messages.ShowAdaptersPage_description);
    }

    protected void createCheckboxes(Properties prop) {
        Integer connectionIndex = 0;
        String connectionXML = prop.getProperty("connection." + connectionIndex);
        while (connectionXML != null) {
            try {
                Document document = JRXmlUtils.parse((InputSource)new InputSource(new StringReader(connectionXML)));
                NamedNodeMap rootAttributes = document.getChildNodes().item(0).getAttributes();
                String connectionName = rootAttributes.getNamedItem("name").getTextContent();
                String connectionClass = rootAttributes.getNamedItem("connectionClass").getTextContent();
                if (ImportUtility.hasAdapter(connectionClass)) {
                    Button checkButton = new Button(this.content, 32);
                    String type = connectionClass.substring(connectionClass.lastIndexOf(".") + 1);
                    checkButton.setText(String.valueOf(connectionName) + " (" + type + ")");
                    checkButton.setData((Object)document);
                    this.selectedElements.add(checkButton);
                }
            }
            catch (JRException jRException) {}
            connectionIndex = connectionIndex + 1;
            connectionXML = prop.getProperty("connection." + connectionIndex);
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.selectedInstallation = ((ListInstallationPage)this.getPreviousPage()).getSelection();
            for (Button button : this.selectedElements) {
                button.dispose();
            }
            this.selectedElements.clear();
            if (this.noElementLabel != null) {
                this.noElementLabel.dispose();
            }
            this.content.layout();
            Properties prop = this.selectedInstallation.getConfiguration();
            if (prop != null) {
                this.createCheckboxes(prop);
            }
            if (this.selectedElements.isEmpty()) {
                this.noElementLabel = new Label(this.content, 0);
                this.noElementLabel.setText(Messages.ShowAdaptersPage_noElementLabel);
            }
            this.content.layout();
            ((ScrolledComposite)this.content.getParent()).setMinSize(this.content.computeSize(-1, -1));
        }
    }

    public List<?> getSelectedAdapter() {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Button element : this.selectedElements) {
            if (!element.getSelection()) continue;
            result.add(element.getData());
        }
        return result;
    }

    public void createControl(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        mainComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        Label titleLabel = new Label(mainComposite, 0);
        titleLabel.setText(Messages.ShowAdaptersPage_label);
        ScrolledComposite scrollComp = new ScrolledComposite(mainComposite, 768);
        scrollComp.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).hint(-1, 200).create());
        scrollComp.setLayout((Layout)new GridLayout(1, false));
        scrollComp.setExpandHorizontal(true);
        scrollComp.setExpandVertical(true);
        this.content = new Composite((Composite)scrollComp, 0);
        scrollComp.setContent((Control)this.content);
        this.content.setLayout((Layout)new GridLayout(1, false));
        this.content.setLayoutData((Object)new GridData(4, 4, true, true));
        this.setControl((Control)mainComposite);
    }

    @Override
    protected String getContextName() {
        return ContextHelpIDs.WIZARD_IMPORT_SELECT_ADAPTERS;
    }
}

