/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.wizard;

import com.jaspersoft.studio.data.adapter.IReportDescriptor;
import com.jaspersoft.studio.data.wizard.ImportDataAdapterWizard;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.swt.widgets.table.ListContentProvider;
import com.jaspersoft.studio.wizards.ContextHelpIDs;
import com.jaspersoft.studio.wizards.JSSWizardPage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class ShowPropertiesPage
extends JSSWizardPage {
    protected List<String> propertiesSelected = new ArrayList<String>();
    protected Table table;
    protected TableViewer leftTView;
    protected Label informationLabel;
    protected Composite buttonPanel;
    protected Properties prop = null;

    protected ShowPropertiesPage() {
        super("addcategories");
        this.setTitle(Messages.PropertiesPage_title);
        this.setDescription(Messages.PropertiesPage_description);
        this.setPageComplete(true);
    }

    public void createControl(Composite parent) {
        Composite panel = new Composite(parent, 0);
        panel.setLayout((Layout)new GridLayout(1, false));
        this.setControl((Control)panel);
        Composite composite = new Composite(panel, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.informationLabel = new Label(composite, 64);
        this.informationLabel.setLayoutData((Object)new GridData(4, 4, true, false));
        this.table = new Table(composite, 2596);
        this.table.setHeaderVisible(true);
        TableColumn[] col = new TableColumn[2];
        col[0] = new TableColumn(this.table, 0);
        col[0].setText("Attributes Names");
        col[0].pack();
        col[1] = new TableColumn(this.table, 0);
        col[1].setText("Values");
        col[1].pack();
        TableLayout tlayout = new TableLayout();
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(82, true));
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(15, true));
        this.table.setLayout((Layout)tlayout);
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ShowPropertiesPage.this.storeSettings();
            }
        });
        GridData tableData = new GridData(4, 4, true, true);
        tableData.minimumWidth = 400;
        tableData.minimumHeight = 300;
        this.table.setLayoutData((Object)tableData);
        this.leftTView = new TableViewer(this.table);
        this.leftTView.setContentProvider((IContentProvider)new ListContentProvider());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.leftTView, (int)2);
        this.setLabelProvider(this.leftTView);
        this.buttonPanel = new Composite(composite, 0);
        this.buttonPanel.setLayout((Layout)new GridLayout(2, true));
        GridData buttonData = new GridData(4, -1, true, false);
        buttonData.minimumHeight = 50;
        buttonData.heightHint = 60;
        this.buttonPanel.setLayoutData((Object)buttonData);
        Button selectAllButton = new Button(this.buttonPanel, 0);
        selectAllButton.setText("Select All");
        selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ShowPropertiesPage.this.selectAllAction(true);
            }
        });
        selectAllButton.setLayoutData((Object)new GridData(4, -1, false, false));
        Button deselectAllButton = new Button(this.buttonPanel, 0);
        deselectAllButton.setText("Deselect All");
        deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ShowPropertiesPage.this.selectAllAction(false);
            }
        });
        deselectAllButton.setLayoutData((Object)new GridData(4, -1, false, false));
    }

    private void selectAllAction(boolean selectionValue) {
        TableItem[] tableItemArray = this.table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            item.setChecked(selectionValue);
            ++n2;
        }
        this.storeSettings();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.leftTView.setInput(this.getInFields());
            this.informationLabel.setText("ATTENTION: Some properties may be dependent by the execution environment, i.e. they may require specific jars being in the classpath or point to paths in the filesystem that may not be longer valid.");
            this.buttonPanel.layout();
            this.informationLabel.getParent().layout();
        }
    }

    protected Collection<Object> getInFields() {
        ArrayList<Object> readKeys = new ArrayList<Object>();
        IReportDescriptor selectedConfig = ((ImportDataAdapterWizard)this.getWizard()).getSelectedConfiguration();
        this.prop = selectedConfig.getConfiguration();
        for (Map.Entry<Object, Object> entry : this.prop.entrySet()) {
            String key = entry.getKey().toString();
            if (!key.startsWith("net.sf.jasperreports")) continue;
            readKeys.add(key);
        }
        return readKeys;
    }

    public void storeSettings() {
        this.propertiesSelected.clear();
        TableItem[] tableItemArray = this.table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getChecked()) {
                this.propertiesSelected.add(item.getData().toString());
            }
            ++n2;
        }
    }

    public List<String> getProperties() {
        return this.propertiesSelected;
    }

    protected void setLabelProvider(TableViewer tableViewer) {
        tableViewer.setLabelProvider((IBaseLabelProvider)new CellLabelProvider(){

            public void update(ViewerCell cell) {
                if (cell.getColumnIndex() == 0) {
                    cell.setText(cell.getElement().toString());
                } else {
                    cell.setText(ShowPropertiesPage.this.prop.getProperty(cell.getElement().toString()).toString());
                }
            }

            public String getToolTipText(Object element) {
                return element.toString().concat("=").concat(ShowPropertiesPage.this.prop.getProperty(element.toString()));
            }

            public Point getToolTipShift(Object object) {
                return new Point(5, 5);
            }

            public int getToolTipDisplayDelayTime(Object object) {
                return 100;
            }

            public int getToolTipTimeDisplayed(Object object) {
                return 5000;
            }
        });
    }

    @Override
    protected String getContextName() {
        return ContextHelpIDs.WIZARD_IMPORT_SELECT_PROPERTIES;
    }
}

