/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.wizard.imp;

import com.jaspersoft.studio.data.DataAdapterDescriptor;
import com.jaspersoft.studio.data.DataAdapterManager;
import com.jaspersoft.studio.data.MDataAdapters;
import com.jaspersoft.studio.data.storage.ADataAdapterStorage;
import com.jaspersoft.studio.data.wizard.imp.ImportDAPage;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.JasperReportsContext;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class ImportDAWizard
extends Wizard
implements IImportWizard {
    private ImportDAPage page0;
    private MDataAdapters das;

    public ImportDAWizard(MDataAdapters das) {
        this.setNeedsProgressMonitor(true);
        this.setHelpAvailable(true);
        this.setWindowTitle(Messages.ImportDAWizard_0);
        this.das = das;
    }

    public void addPages() {
        this.page0 = new ImportDAPage();
        this.addPage((IWizardPage)this.page0);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public boolean performFinish() {
        final boolean overwrite = this.page0.isOverwrite();
        final List<DataAdapterDescriptor> adapters = this.page0.getDataAdapterDescriptors();
        try {
            this.getContainer().run(false, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(Messages.ImportDAWizard_1, adapters.size());
                    ADataAdapterStorage storage = ImportDAWizard.this.das.getValue();
                    for (DataAdapterDescriptor da : adapters) {
                        DataAdapterDescriptor sda;
                        monitor.subTask(da.getName());
                        if (overwrite && (sda = storage.findDataAdapter(da.getDataAdapter().getName())) != null) {
                            storage.removeDataAdapter(sda);
                        }
                        DataAdapterDescriptor cloneDataAdapter = DataAdapterManager.cloneDataAdapter(da, (JasperReportsContext)JasperReportsConfiguration.getDefaultInstance());
                        cloneDataAdapter.setName(null);
                        storage.addDataAdapter(cloneDataAdapter);
                        monitor.internalWorked(1.0);
                        if (monitor.isCanceled()) break;
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            UIUtils.showError((Throwable)e);
        }
        catch (InterruptedException e) {
            UIUtils.showError((Throwable)e);
        }
        return true;
    }
}

