/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.dnd;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.dnd.NodeTransfer;
import com.jaspersoft.studio.model.ANode;
import java.util.List;
import org.eclipse.gef.dnd.TemplateTransfer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.ui.part.PluginTransfer;
import org.eclipse.ui.part.PluginTransferData;

public class NodeDragListener
extends DragSourceAdapter {
    protected StructuredViewer viewer;

    public NodeDragListener(StructuredViewer viewer) {
        this.viewer = viewer;
    }

    public void dragFinished(DragSourceEvent event) {
        if (!event.doit) {
            return;
        }
        if (event.detail == 2) {
            IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
            for (Object obj : selection) {
                ANode n;
                if (!(obj instanceof ANode) || !(n = (ANode)obj).isCut()) continue;
                ((ANode)obj).setParent(null, -1);
            }
            this.viewer.refresh();
        }
    }

    public void dragSetData(DragSourceEvent event) {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        List list = selection.toList();
        if (NodeTransfer.getInstance().isSupportedType(event.dataType)) {
            event.data = list.toArray();
        } else if (PluginTransfer.getInstance().isSupportedType(event.dataType)) {
            Object[] gadgets = list.toArray(new ANode[selection.size()]);
            byte[] data = NodeTransfer.getInstance().toByteArray(gadgets);
            event.data = new PluginTransferData(JaspersoftStudioPlugin.getUniqueIdentifier(), data);
        } else {
            event.data = TemplateTransfer.getInstance().isSupportedType(event.dataType) ? list.toArray() : list.toArray();
        }
    }

    public void dragStart(DragSourceEvent event) {
        event.doit = !this.viewer.getSelection().isEmpty();
    }
}

