/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor;

import com.jaspersoft.studio.ExternalStylesManager;
import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.compatibility.JRXmlWriterHelper;
import com.jaspersoft.studio.data.DataAdapterDescriptor;
import com.jaspersoft.studio.editor.DeltaVisitor;
import com.jaspersoft.studio.editor.IMultiEditor;
import com.jaspersoft.studio.editor.JRXMLEditorZoomListener;
import com.jaspersoft.studio.editor.context.EditorContextUtil;
import com.jaspersoft.studio.editor.defaults.DefaultManager;
import com.jaspersoft.studio.editor.outline.page.EmptyOutlinePage;
import com.jaspersoft.studio.editor.outline.page.MultiOutlineView;
import com.jaspersoft.studio.editor.preview.PreviewContainer;
import com.jaspersoft.studio.editor.xml.XMLEditor;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.MReport;
import com.jaspersoft.studio.utils.Console;
import com.jaspersoft.studio.utils.JRXMLUtils;
import com.jaspersoft.studio.utils.SyncDatasetRunParameters;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashMap;
import net.sf.jasperreports.eclipse.JasperReportsPlugin;
import net.sf.jasperreports.eclipse.builder.JasperReportsBuilder;
import net.sf.jasperreports.eclipse.builder.Markers;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.SimpleJasperReportsContext;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.xml.JRXmlDigesterFactory;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import org.apache.commons.digester.Digester;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.editors.text.IStorageDocumentProvider;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IElementStateListener;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.xml.sax.InputSource;

public abstract class AbstractJRXMLEditor
extends MultiPageEditorPart
implements IResourceChangeListener,
IMultiEditor,
IGotoMarker {
    public static final int PAGE_DESIGNER = 0;
    public static final int PAGE_SOURCEEDITOR = 1;
    public static final int PAGE_PREVIEW = 2;
    private static Listener mouseWheelListener = new JRXMLEditorZoomListener();
    protected INode model = null;
    protected JasperReportsConfiguration jrContext;
    protected MultiOutlineView outlinePage;
    protected boolean xmlFresh = true;
    protected boolean toXML = false;
    protected boolean isRefreshing = false;
    protected boolean closing = false;
    protected int activePage = 0;
    protected ISelection tmpselection;
    protected String version = "last";
    protected XMLEditor xmlEditor;
    protected PreviewEditor previewEditor;
    protected boolean partActivated = true;
    protected IDocumentListener sourceEditorModified = new IDocumentListener(){

        public void documentChanged(DocumentEvent event) {
            if (!AbstractJRXMLEditor.this.isRefreshing) {
                AbstractJRXMLEditor.this.xmlFresh = false;
                AbstractJRXMLEditor.this.firePropertyChange(257);
            }
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }
    };
    protected IContextActivation context;

    public AbstractJRXMLEditor() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 7);
        ExternalStylesManager.initListeners();
        JasperReportsPlugin.initializeKeyListener();
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        if (this.closing) {
            return;
        }
        NullProgressMonitor monitor = new NullProgressMonitor();
        editorInput = FileUtils.checkAndConvertEditorInput((IEditorInput)editorInput, (IProgressMonitor)monitor);
        super.init(site, editorInput);
        this.setPartName(editorInput.getName());
        InputStream in = null;
        IFile file = null;
        try {
            if (editorInput instanceof IFileEditorInput) {
                file = ((IFileEditorInput)editorInput).getFile();
                if (!file.getProject().isOpen()) {
                    file.getProject().open((IProgressMonitor)monitor);
                }
                file.refreshLocal(0, (IProgressMonitor)monitor);
                if (!file.exists()) {
                    this.closeEditorOnErrors();
                    return;
                }
                in = file.getContents();
            } else if (editorInput instanceof IStorageEditorInput) {
                in = ((IStorageEditorInput)editorInput).getStorage().getContents();
            } else {
                throw new PartInitException("Invalid Input: Must be IFileEditorInput or FileStoreEditorInput");
            }
            this.getJrContext(file);
            if (!this.isRefreshing) {
                InputStream inp = in;
                IFile ifile = file;
                this.doInitModel((IProgressMonitor)monitor, this.getEditorInput(), inp, ifile);
            }
        }
        catch (Exception e) {
            this.setModel(null);
            this.handleJRException(editorInput, e, false);
        }
    }

    public void changeContext(String c, boolean reset) {
        this.jrContext.changeContext(c, reset);
        if (this.previewEditor != null) {
            this.previewEditor.setMode(this.jrContext.getEditorContext().getDefaultRunMode());
            if (this.activePage == 2) {
                this.previewEditor.runReport();
            }
        }
    }

    public JasperReportsConfiguration getJrContext(IFile file) {
        if (this.jrContext == null) {
            this.jrContext = JasperReportsConfiguration.getDefaultJRConfig(file);
            this.jrContext.put("thecurrenteditor", this);
            this.jrContext.setJRParameters(new HashMap<String, Object>());
        }
        return this.jrContext;
    }

    public JasperReportsConfiguration getJrContext() {
        return this.jrContext;
    }

    protected abstract INode createEditorModel();

    protected void doInitModel(IProgressMonitor monitor, IEditorInput editorInput, InputStream in, IFile file) {
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        try {
            try {
                Thread.currentThread().setContextClassLoader(this.jrContext.getClassLoader());
                String charset = "UTF-8";
                if (file != null) {
                    charset = file.getCharset(true);
                }
                in = JRXMLUtils.getXML(this.jrContext, editorInput, charset, in, this.version);
                JasperDesign jd = new JRXmlLoader((JasperReportsContext)this.jrContext, (Digester)JRXmlDigesterFactory.createDigester((JasperReportsContext)this.jrContext)).loadXML(new InputSource(in));
                JaspersoftStudioPlugin.getExtensionManager().onLoad(jd, (EditorPart)this);
                this.jrContext.setJasperDesign(jd);
                UIUtils.getDisplay().syncExec(() -> {
                    this.setModel(this.createEditorModel());
                    MReport report = this.getMReport();
                    if (report != null) {
                        SyncDatasetRunParameters.sync(report);
                    }
                });
            }
            catch (CoreException e) {
                if (e.getMessage().startsWith("File not found")) {
                    this.closeEditorOnErrors();
                } else {
                    this.setModel(null);
                    this.handleJRException(editorInput, (Exception)((Object)e), false);
                }
                FileUtils.closeStream((Closeable)in);
                Thread.currentThread().setContextClassLoader(oldCL);
            }
            catch (Exception e) {
                this.setModel(null);
                this.handleJRException(editorInput, e, false);
                FileUtils.closeStream((Closeable)in);
                Thread.currentThread().setContextClassLoader(oldCL);
            }
        }
        finally {
            FileUtils.closeStream((Closeable)in);
            Thread.currentThread().setContextClassLoader(oldCL);
        }
    }

    public void resourceChanged(final IResourceChangeEvent event) {
        if (this.isRefreshing) {
            return;
        }
        Job job = new Job("Post file change"){

            protected IStatus run(IProgressMonitor monitor) {
                switch (event.getType()) {
                    case 2: {
                        Display.getDefault().asyncExec(() -> {
                            IWorkbenchPage[] pages = AbstractJRXMLEditor.this.getSite().getWorkbenchWindow().getPages();
                            int i = 0;
                            while (i < pages.length) {
                                if (((FileEditorInput)AbstractJRXMLEditor.this.xmlEditor.getEditorInput()).getFile().getProject().equals((Object)event.getResource())) {
                                    IEditorPart editorPart = pages[i].findEditor(AbstractJRXMLEditor.this.xmlEditor.getEditorInput());
                                    pages[i].closeEditor(editorPart, true);
                                }
                                ++i;
                            }
                        });
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 1: {
                        try {
                            IFile newf;
                            IFile old;
                            DeltaVisitor visitor = new DeltaVisitor((EditorPart)AbstractJRXMLEditor.this);
                            event.getDelta().accept((IResourceDeltaVisitor)visitor);
                            if (AbstractJRXMLEditor.this.jrContext == null || AbstractJRXMLEditor.this.getEditorInput() == null || (old = AbstractJRXMLEditor.this.jrContext.getAssociatedReportFile()).equals((Object)(newf = ((IFileEditorInput)AbstractJRXMLEditor.this.getEditorInput()).getFile()))) break;
                            AbstractJRXMLEditor.this.jrContext.init(newf);
                            JaspersoftStudioPlugin.getExtensionManager().onRename(old, newf, (JasperReportsContext)AbstractJRXMLEditor.this.jrContext, (IProgressMonitor)new NullProgressMonitor());
                        }
                        catch (CoreException e) {
                            UIUtils.showError((Throwable)e);
                        }
                        break;
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.setPriority(30);
        job.schedule();
    }

    protected void createPages() {
        CTabFolder c = (CTabFolder)this.getContainer();
        c.setTopRight(EditorContextUtil.createSwitch((Composite)c, this), 131072);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getContainer(), this.getEditorHelpID());
        if (this.jrContext != null) {
            try {
                this.createDesignEditorPage();
                this.createSourceEditorPage();
                Display.getDefault().asyncExec(() -> {
                    try {
                        this.createPreviewEditorPage();
                        this.bindActionToKeys();
                    }
                    catch (PartInitException partInitException) {
                        UIUtils.showError((Throwable)new Exception(Messages.common_error_creating_nested_visual_editor));
                    }
                });
            }
            catch (PartInitException partInitException) {
                UIUtils.showError((Throwable)new Exception(Messages.common_error_creating_nested_visual_editor));
            }
            catch (Throwable e) {
                this.closeEditorOnErrors();
                JaspersoftStudioPlugin.getInstance().logError(e);
            }
        }
        IPartListener2 pl = new IPartListener2(){

            public void partActivated(IWorkbenchPartReference partRef) {
                if (partRef.getPart(false) == AbstractJRXMLEditor.this.getSite().getPart()) {
                    AbstractJRXMLEditor.this.editorActivated();
                }
            }

            public void partBroughtToTop(IWorkbenchPartReference partRef) {
            }

            public void partClosed(IWorkbenchPartReference partRef) {
            }

            public void partDeactivated(IWorkbenchPartReference partRef) {
                if (partRef.getPart(false) == AbstractJRXMLEditor.this.getSite().getPart()) {
                    AbstractJRXMLEditor.this.editorDeactivated();
                }
            }

            public void partOpened(IWorkbenchPartReference partRef) {
            }

            public void partHidden(IWorkbenchPartReference partRef) {
                if (partRef.getPart(false) == AbstractJRXMLEditor.this.getSite().getPart()) {
                    AbstractJRXMLEditor.this.editorHidden();
                }
            }

            public void partVisible(IWorkbenchPartReference partRef) {
                if (partRef.getPart(false) == AbstractJRXMLEditor.this.getSite().getPart()) {
                    AbstractJRXMLEditor.this.editorVisible();
                }
            }

            public void partInputChanged(IWorkbenchPartReference partRef) {
            }
        };
        this.getSite().getPage().addPartListener(pl);
    }

    public boolean isPartActivated() {
        return this.partActivated;
    }

    public void setPartActivated(boolean partActivated) {
        this.partActivated = partActivated;
    }

    protected void editorActivated() {
        this.partActivated = true;
    }

    protected void editorDeactivated() {
        this.partActivated = false;
    }

    protected void editorVisible() {
    }

    protected void editorHidden() {
    }

    protected void closeEditorOnErrors() {
        IWorkbenchPage apage;
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null && (apage = activeWorkbenchWindow.getActivePage()) != null) {
            Display.getDefault().asyncExec(() -> {
                this.closing = true;
                apage.closeEditor((IEditorPart)this, false);
            });
        }
    }

    public void handleJRException(IEditorInput editorInput, Exception exception, boolean mute) {
        if (!mute) {
            UIUtils.showError((Throwable)exception);
        }
        try {
            this.isRefreshing = true;
            if (editorInput instanceof IFileEditorInput) {
                IFile resource = ((IFileEditorInput)editorInput).getFile();
                if (!resource.exists()) {
                    return;
                }
                Markers.deleteMarkers((IResource)resource);
                final IMarker marker = Markers.addMarker((IResource)resource, (Throwable)exception);
                marker.setAttribute("transient", true);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        AbstractJRXMLEditor.this.gotoMarker(marker);
                        AbstractJRXMLEditor.this.toXML = true;
                        AbstractJRXMLEditor.this.setActivePage(1);
                        AbstractJRXMLEditor.this.isRefreshing = false;
                    }
                });
            }
        }
        catch (CoreException e1) {
            JaspersoftStudioPlugin.getInstance().logError(e1);
        }
    }

    public void gotoMarker(IMarker marker) {
        this.setActivePage(1);
        IDE.gotoMarker((IEditorPart)this.xmlEditor, (IMarker)marker);
    }

    protected void createSourceEditorPage() throws PartInitException {
        this.xmlEditor = new XMLEditor(this.jrContext);
        int index = this.addPage((IEditorPart)this.xmlEditor, this.getEditorInput());
        this.setPageText(index, Messages.common_source);
        IDocument doc = this.xmlEditor.getDocumentProvider().getDocument((Object)this.xmlEditor.getEditorInput());
        doc.addDocumentListener(this.sourceEditorModified);
    }

    protected void createPreviewEditorPage() throws PartInitException {
        this.previewEditor = new PreviewEditor(false, this.jrContext);
        int index = this.addPage((IEditorPart)this.previewEditor, this.getEditorInput());
        this.setPageText(index, Messages.JrxmlEditor_preview);
        this.xmlEditor.getDocumentProvider().addElementStateListener((IElementStateListener)new StateListener());
        ((CTabFolder)this.getContainer()).addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                AbstractJRXMLEditor.this.previewEditor.setRunWhenInitilizing((e.stateMask & 0x20000) == 0);
            }
        });
    }

    private void bindActionToKeys() {
        this.getContainer().getDisplay().removeFilter(37, mouseWheelListener);
        this.getContainer().getDisplay().removeFilter(1, mouseWheelListener);
        this.getContainer().getDisplay().addFilter(37, mouseWheelListener);
        this.getContainer().getDisplay().addFilter(1, mouseWheelListener);
    }

    protected abstract String getEditorHelpID();

    public void doSave(IProgressMonitor monitor) {
        try {
            this.isRefreshing = true;
            IFile resource = this.getCurrentFile();
            if (resource == null) {
                MessageDialog.openError((Shell)UIUtils.getShell(), (String)Messages.AbstractJRXMLEditor_1, (String)(String.valueOf(Messages.AbstractJRXMLEditor_2) + Messages.AbstractJRXMLEditor_3));
                return;
            }
            try {
                if (!resource.exists()) {
                    resource.create((InputStream)new ByteArrayInputStream("".getBytes("UTF-8")), true, monitor);
                }
                resource.setCharset("UTF-8", monitor);
                ((IStorageDocumentProvider)this.xmlEditor.getDocumentProvider()).setEncoding((Object)this.getEditorInput(), "UTF-8");
            }
            catch (CoreException e) {
                UIUtils.showError((Throwable)e);
            }
            catch (UnsupportedEncodingException e) {
                UIUtils.showError((Throwable)e);
            }
            this.version = JRXmlWriterHelper.getVersion((IResource)resource, this.jrContext, true);
            if (!this.xmlEditor.isDirty() && this.getDesignEditor().isDirty() || this.getActiveEditor() != this.xmlEditor) {
                this.model2xml(this.version);
            } else {
                IDocumentProvider dp = this.xmlEditor.getDocumentProvider();
                IDocument doc = dp.getDocument((Object)this.xmlEditor.getEditorInput());
                try {
                    this.xml2model();
                }
                catch (Throwable e) {
                    Markers.addMarker((IResource)resource, (Throwable)e);
                    this.doSaveEditors(monitor);
                    resource.setContents((InputStream)new ByteArrayInputStream(doc.get().getBytes("UTF-8")), 3, monitor);
                    this.finishSave(resource);
                    return;
                }
            }
            if (Misc.isNullOrEmpty((String)JRXMLUtils.getFileExtension(this.getEditorInput()))) {
                try {
                    new JasperReportsBuilder().compileJRXML((IResource)resource, monitor, (SimpleJasperReportsContext)this.getJrContext());
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            UIUtils.getDisplay().syncExec(() -> {
                if (this.isDirty()) {
                    JaspersoftStudioPlugin.getExtensionManager().onSave(this.jrContext, monitor);
                }
                try {
                    String xml = this.model2xml(this.version);
                    this.doSaveEditors(monitor);
                    Markers.deleteMarkers((IResource)resource);
                    resource.setContents((InputStream)new ByteArrayInputStream(xml.getBytes("UTF-8")), 3, monitor);
                    this.finishSave(resource);
                }
                catch (Throwable e) {
                    try {
                        Markers.addMarker((IResource)resource, (Throwable)e);
                    }
                    catch (CoreException e1) {
                        e1.printStackTrace();
                    }
                    UIUtils.showError((Throwable)e);
                }
            });
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    protected void doSaveEditors(IProgressMonitor monitor) {
        this.xmlEditor.doSave(monitor);
        this.getDesignEditor().doSave(monitor);
        this.previewEditor.doSave(monitor);
        this.xmlEditor.isDirty();
        this.getDesignEditor().isDirty();
        this.previewEditor.isDirty();
        this.xmlFresh = true;
    }

    protected void finishSave(IFile resource) {
        String resourceAbsolutePath = resource.getRawLocation().toOSString();
        if (DefaultManager.INSTANCE.isCurrentDefault(resourceAbsolutePath)) {
            DefaultManager.INSTANCE.reloadCurrentDefault();
        }
        UIUtils.getDisplay().asyncExec(() -> {
            this.isRefreshing = false;
            this.firePropertyChange(257);
        });
    }

    public void doSaveAs() {
        IFile file;
        IPath path;
        SaveAsDialog saveAsDialog = new SaveAsDialog(this.getSite().getShell());
        IFile oldFile = ((FileEditorInput)this.getEditorInput()).getFile();
        saveAsDialog.setOriginalFile(oldFile);
        if (saveAsDialog.open() == 0 && (path = saveAsDialog.getResult()) != null && (file = ResourcesPlugin.getWorkspace().getRoot().getFile(path)) != null) {
            IProgressMonitor monitor = this.getActiveEditor().getEditorSite().getActionBars().getStatusLineManager().getProgressMonitor();
            JaspersoftStudioPlugin.getExtensionManager().onSaveAs(oldFile, file, this.jrContext, monitor);
            try {
                if (this.getActiveEditor() == this.xmlEditor) {
                    IDocumentProvider dp = this.xmlEditor.getDocumentProvider();
                    IDocument doc = dp.getDocument((Object)this.xmlEditor.getEditorInput());
                    ByteArrayInputStream in = new ByteArrayInputStream(doc.get().getBytes("UTF-8"));
                    if (!file.exists()) {
                        file.create((InputStream)in, true, monitor);
                    } else {
                        file.setContents((InputStream)in, true, true, monitor);
                    }
                } else if (!file.exists()) {
                    file.create((InputStream)new ByteArrayInputStream("".getBytes("UTF-8")), true, monitor);
                }
                FileEditorInput modelFile = new FileEditorInput(file);
                this.setInputWithNotify((IEditorInput)modelFile);
                this.xmlEditor.setInput((IEditorInput)modelFile);
                this.setPartName(file.getName());
                this.jrContext.init(file);
                this.doSave(monitor);
            }
            catch (CoreException e) {
                UIUtils.showError((Throwable)e);
            }
            catch (UnsupportedEncodingException e) {
                UIUtils.showError((Throwable)e);
            }
        }
    }

    protected void handlePropertyChange(int propertyId) {
        if (!this.isRefreshing) {
            if (propertyId == 257 && this.previewEditor != null) {
                this.setPreviewDirty(true);
            }
            UIUtils.getDisplay().syncExec(() -> AbstractJRXMLEditor.super.handlePropertyChange(propertyId));
        }
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    protected void pageChange(final int newPageIndex) {
        if (newPageIndex == 0 || newPageIndex == 1 || newPageIndex == 2) {
            if (this.activePage == 0) {
                this.tmpselection = this.outlinePage != null ? this.outlinePage.getSite().getSelectionProvider().getSelection() : this.getDesignerPageSelection();
            }
            String ver = JRXmlWriterHelper.getVersion((IResource)this.getCurrentFile(), this.jrContext, false);
            IContextService service = (IContextService)PlatformUI.getWorkbench().getService(IContextService.class);
            switch (newPageIndex) {
                case 0: {
                    if (this.activePage == 1 && !this.xmlFresh) {
                        try {
                            this.xml2model();
                        }
                        catch (Exception e) {
                            this.toXML = true;
                            this.handleJRException(this.getEditorInput(), e, false);
                        }
                        this.updateVisualView();
                    } else if (this.activePage == 0) {
                        this.updateVisualView();
                    } else {
                        this.previewEditor.getReportControler().stop();
                    }
                    Display.getDefault().syncExec(() -> {
                        if (this.outlinePage != null) {
                            this.outlinePage.getSite().getSelectionProvider().setSelection(this.tmpselection);
                        } else {
                            this.setDesignerPageSelection(this.tmpselection);
                        }
                    });
                    if (this.context != null) break;
                    this.context = service.activateContext("com.jaspersoft.studio.context");
                    break;
                }
                case 1: {
                    if (this.toXML) {
                        this.toXML = false;
                    } else {
                        this.isRefreshing = true;
                        this.model2xml(ver);
                        this.isRefreshing = false;
                    }
                    if (this.context == null) break;
                    int i = 0;
                    while (i < 10) {
                        service.deactivateContext(this.context);
                        ++i;
                    }
                    break;
                }
                case 2: {
                    if (this.activePage == 1 && !this.xmlFresh) {
                        try {
                            this.xml2model();
                            this.setPreviewDirty(true);
                        }
                        catch (Exception e) {
                            this.handleJRException(this.getEditorInput(), e, false);
                        }
                    } else if (this.isDesignerDirty()) {
                        this.isRefreshing = true;
                        this.model2xml(ver);
                        this.isRefreshing = false;
                    }
                    Job job = new Job(Messages.AbstractJRXMLEditor_8){

                        protected IStatus run(IProgressMonitor monitor) {
                            monitor.beginTask(Messages.AbstractJRXMLEditor_9, -1);
                            if (AbstractJRXMLEditor.this.jrContext.getEditorContext().saveOnPreview() || AbstractJRXMLEditor.this.jrContext.getPropertyBoolean("saveOnPreview", Boolean.FALSE).booleanValue()) {
                                monitor.subTask(Messages.AbstractJRXMLEditor_10);
                                if (AbstractJRXMLEditor.this.isDirty()) {
                                    UIUtils.getDisplay().syncExec(() -> AbstractJRXMLEditor.this.doSave(monitor));
                                }
                            }
                            UIUtils.getDisplay().syncExec(() -> {
                                AbstractJRXMLEditor.this.model2preview();
                                AbstractJRXMLEditor.super.pageChange(newPageIndex);
                                AbstractJRXMLEditor.this.updateContentOutline(AbstractJRXMLEditor.this.getActivePage());
                                AbstractJRXMLEditor.this.activePage = newPageIndex;
                            });
                            return Status.OK_STATUS;
                        }
                    };
                    job.setSystem(true);
                    job.schedule();
                    return;
                }
            }
        }
        super.pageChange(newPageIndex);
        this.updateContentOutline(this.getActivePage());
        this.activePage = newPageIndex;
    }

    public Object getAdapter(Class type) {
        if (type == JasperReportsContext.class) {
            return this.jrContext;
        }
        if (type == IContentOutlinePage.class) {
            if (this.outlinePage == null) {
                this.outlinePage = new MultiOutlineView((EditorPart)this);
            }
            Display.getDefault().syncExec(new Runnable(){
                private boolean isUpdateOutline = false;

                @Override
                public void run() {
                    if (this.isUpdateOutline) {
                        this.isUpdateOutline = true;
                        AbstractJRXMLEditor.this.updateContentOutline(AbstractJRXMLEditor.this.getActivePage());
                        this.isUpdateOutline = false;
                    }
                }
            });
            return this.outlinePage;
        }
        return super.getAdapter(type);
    }

    protected void updateContentOutline(int page) {
        if (this.outlinePage == null) {
            return;
        }
        Object outline = (IContentOutlinePage)this.getEditor(page).getAdapter(IContentOutlinePage.class);
        if (outline == null) {
            outline = new EmptyOutlinePage();
        }
        this.outlinePage.setPageActive((IContentOutlinePage)outline);
    }

    protected void xml2model() throws Exception {
        ByteArrayInputStream in = null;
        try {
            Markers.deleteMarkers((IResource)this.getCurrentFile());
            IDocumentProvider dp = this.xmlEditor.getDocumentProvider();
            IDocument doc = dp.getDocument((Object)this.xmlEditor.getEditorInput());
            in = new ByteArrayInputStream(doc.get().getBytes("UTF-8"));
            JasperDesign jd = new JRXmlLoader((JasperReportsContext)this.jrContext, (Digester)JRXmlDigesterFactory.createDigester((JasperReportsContext)this.jrContext)).loadXML((InputStream)in);
            this.jrContext.setJasperDesign(jd);
            JaspersoftStudioPlugin.getExtensionManager().onLoad(jd, (EditorPart)this);
            this.setModel(this.createEditorModel());
        }
        catch (Throwable throwable) {
            FileUtils.closeStream(in);
            throw throwable;
        }
        FileUtils.closeStream((Closeable)in);
    }

    protected String model2xml(String version) {
        String xml = null;
        try {
            Object obj;
            JasperDesign report = null;
            MReport mReport = this.getMReport();
            if (mReport != null && (report = mReport.getJasperDesign()).getProperty("com.jaspersoft.studio.data.defaultdataadapter") == null && (obj = mReport.getParameter("com.jaspersoft.studio.data.defaultdataadapter")) != null && obj instanceof DataAdapterDescriptor) {
                String dataAdapterDesc = this.previewEditor.getDataAdapterDesc().getName();
                report.removeProperty("com.jaspersoft.studio.data.defaultdataadapter");
                report.setProperty("com.jaspersoft.studio.data.defaultdataadapter", dataAdapterDesc);
            }
            xml = JRXmlWriterHelper.writeReport((JasperReportsContext)this.jrContext, (JRReport)report, "UTF-8", version);
            IDocumentProvider dp = this.xmlEditor.getDocumentProvider();
            IDocument doc = dp.getDocument((Object)this.xmlEditor.getEditorInput());
            this.xmlFresh = true;
            if (xml != null && !Arrays.equals(doc.get().getBytes(), xml.getBytes())) {
                doc.set(xml);
            }
        }
        catch (Throwable e) {
            UIUtils.showError((Throwable)e);
        }
        return xml;
    }

    public boolean isDirty() {
        boolean previewDirty;
        boolean designDirty;
        boolean bl = designDirty = this.getDesignEditor() != null && this.getDesignEditor().isDirty();
        if (designDirty) {
            return true;
        }
        boolean bl2 = previewDirty = this.previewEditor != null && this.previewEditor.isDirty();
        if (previewDirty) {
            return true;
        }
        return !this.xmlFresh;
    }

    protected void model2xml() {
        this.model2xml("last");
    }

    protected void model2preview() {
        this.previewEditor.setJasperDesign(this.jrContext);
    }

    public abstract void updateVisualView();

    @Override
    public INode getModel() {
        return this.model;
    }

    public void setModel(INode model) {
        this.model = model;
        this.updateVisualView();
        if (this.jrContext != null) {
            this.jrContext.setJasperDesign(this.getJasperDesign());
        }
    }

    protected MReport getMReport() {
        if (this.model != null) {
            return (MReport)this.model.getChildren().get(0);
        }
        return null;
    }

    protected JasperDesign getJasperDesign() {
        MReport mreport = this.getMReport();
        if (mreport != null) {
            return mreport.getValue();
        }
        return null;
    }

    public Console getConsole() {
        if (this.previewEditor != null) {
            return this.previewEditor.getConsole();
        }
        return null;
    }

    @Override
    public IEditorPart getActiveEditor() {
        return super.getActiveEditor();
    }

    public IEditorPart getActiveInnerEditor() {
        return this.getActiveEditor();
    }

    public IEditorPart getEditor(int pageIndex) {
        if (this.getContainer().isDisposed() || this.getPageCount() <= pageIndex) {
            return null;
        }
        return super.getEditor(pageIndex);
    }

    protected IFile getCurrentFile() {
        if (this.getEditorInput() instanceof IFileEditorInput) {
            return ((IFileEditorInput)this.getEditorInput()).getFile();
        }
        return null;
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        this.setModel(null);
        if (this.jrContext != null) {
            this.jrContext.dispose();
        }
        super.dispose();
        if (this.context != null) {
            IContextService service = (IContextService)this.getSite().getService(IContextService.class);
            service.deactivateContext(this.context);
        }
    }

    public void setPreviewOutput(String key, boolean refresh) {
        this.previewEditor.setCurrentViewer(key, refresh);
    }

    public String getDefaultViewerKey() {
        return this.previewEditor.getDefaultViewerKey();
    }

    public void setPreviewDirty(boolean dirty) {
        this.previewEditor.setDirty(dirty);
    }

    public String getTitleToolTip() {
        return JaspersoftStudioPlugin.getExtensionManager().getTitleToolTip(this.jrContext, super.getTitleToolTip());
    }

    protected abstract boolean isDesignerDirty();

    protected abstract ISelection getDesignerPageSelection();

    protected abstract void setDesignerPageSelection(ISelection var1);

    protected abstract void createDesignEditorPage() throws PartInitException;

    protected abstract EditorPart getDesignEditor();

    protected final class PreviewEditor
    extends PreviewContainer {
        private boolean saving;

        public PreviewEditor(boolean listenResource, JasperReportsConfiguration jrContext) {
            super(listenResource, jrContext);
            this.saving = false;
        }

        @Override
        public boolean runReport(DataAdapterDescriptor myDataAdapterDesc, boolean prmDirty, boolean daAction) {
            Boolean set = this.jrContext.getEditorContext().setDataAdapter(myDataAdapterDesc, AbstractJRXMLEditor.this.getMReport(), daAction);
            if (set == null) {
                return false;
            }
            if (set.booleanValue()) {
                this.setDirty(set);
            }
            super.runReport(myDataAdapterDesc, prmDirty, daAction);
            return true;
        }

        @Override
        public void doSave(IProgressMonitor monitor) {
            if (this.saving) {
                return;
            }
            this.saving = true;
            try {
                super.doSave(monitor);
                if (!AbstractJRXMLEditor.this.isRefreshing) {
                    AbstractJRXMLEditor.this.doSave(monitor);
                }
            }
            finally {
                this.saving = false;
            }
        }

        @Override
        public void setDirty(boolean dirty) {
            if (!AbstractJRXMLEditor.this.isRefreshing) {
                super.setDirty(dirty);
            }
        }
    }

    protected class StateListener
    implements IElementStateListener {
        protected StateListener() {
        }

        public void elementDirtyStateChanged(Object element, boolean isDirty) {
        }

        public void elementContentAboutToBeReplaced(Object element) {
        }

        public void elementContentReplaced(Object element) {
        }

        public void elementDeleted(Object element) {
            IFile resource = AbstractJRXMLEditor.this.getCurrentFile();
            String path = resource.getRawLocation().toOSString();
            DefaultManager.INSTANCE.removeDefaultFile(path);
            Display.getDefault().asyncExec(() -> {
                boolean bl = AbstractJRXMLEditor.this.getSite().getPage().closeEditor((IEditorPart)AbstractJRXMLEditor.this, false);
            });
        }

        public void elementMoved(Object originalElement, Object movedElement) {
        }
    }
}

