/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.compatibility.JRXmlWriterHelper;
import com.jaspersoft.studio.editor.AbstractJRXMLEditor;
import com.jaspersoft.studio.editor.IJROBjectEditor;
import com.jaspersoft.studio.editor.preview.view.control.VErrorPreview;
import com.jaspersoft.studio.editor.report.CachedSelectionProvider;
import com.jaspersoft.studio.editor.report.CommonSelectionCacheProvider;
import com.jaspersoft.studio.editor.report.ReportContainer;
import com.jaspersoft.studio.editor.report.ReportEditor;
import com.jaspersoft.studio.editor.report.SimpleReportEditor;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.MReport;
import com.jaspersoft.studio.model.util.ReportFactory;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.util.Arrays;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.dialogs.IPageChangeProvider;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.MultiPageEditorActionBarContributor;
import org.eclipse.ui.part.MultiPageSelectionProvider;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class SimpleJRXMLEditor
extends AbstractJRXMLEditor
implements IJROBjectEditor,
CachedSelectionProvider {
    public static final String ID = "com.jaspersoft.studio.editor.SimpleJRXMLEditor";
    protected ReportContainer reportContainer;
    protected ListenerList pageChangeListeners = new ListenerList(1);

    @Override
    protected void createPages() {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getContainer(), this.getEditorHelpID());
        if (this.jrContext != null) {
            try {
                this.createDesignEditorPage();
                this.createSourceEditorPage();
            }
            catch (PartInitException partInitException) {
                UIUtils.showError((Throwable)new Exception(Messages.common_error_creating_nested_visual_editor));
            }
            catch (Throwable e) {
                this.closeEditorOnErrors();
                JaspersoftStudioPlugin.getInstance().logError(e);
            }
        }
        IPartListener2 pl = new IPartListener2(){

            public void partActivated(IWorkbenchPartReference partRef) {
                if (partRef.getPart(false) == SimpleJRXMLEditor.this.getSite().getPart()) {
                    SimpleJRXMLEditor.this.partActivated = true;
                }
            }

            public void partBroughtToTop(IWorkbenchPartReference partRef) {
            }

            public void partClosed(IWorkbenchPartReference partRef) {
            }

            public void partDeactivated(IWorkbenchPartReference partRef) {
                if (partRef.getPart(false) == SimpleJRXMLEditor.this.getSite().getPart()) {
                    SimpleJRXMLEditor.this.partActivated = false;
                }
            }

            public void partOpened(IWorkbenchPartReference partRef) {
            }

            public void partHidden(IWorkbenchPartReference partRef) {
            }

            public void partVisible(IWorkbenchPartReference partRef) {
            }

            public void partInputChanged(IWorkbenchPartReference partRef) {
            }
        };
        this.getSite().getPage().addPartListener(pl);
    }

    @Override
    protected void doSaveEditors(IProgressMonitor monitor) {
        this.xmlEditor.doSave(monitor);
        this.getDesignEditor().doSave(monitor);
        this.xmlEditor.isDirty();
        this.getDesignEditor().isDirty();
        this.xmlFresh = true;
    }

    @Override
    protected void handlePropertyChange(final int propertyId) {
        if (!this.isRefreshing) {
            if (propertyId == 257) {
                this.xmlFresh = false;
            }
            UIUtils.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    SimpleJRXMLEditor.super.handlePropertyChange(propertyId);
                }
            });
        }
    }

    @Override
    protected void pageChange(int newPageIndex) {
        if (newPageIndex == 0 || newPageIndex == 1) {
            if (this.activePage == 0) {
                this.tmpselection = this.outlinePage != null ? this.outlinePage.getSite().getSelectionProvider().getSelection() : this.getDesignerPageSelection();
            }
            String ver = JRXmlWriterHelper.getVersion((IResource)this.getCurrentFile(), this.jrContext, false);
            switch (newPageIndex) {
                case 0: {
                    if (this.activePage == 1 && !this.xmlFresh) {
                        try {
                            this.xml2model();
                        }
                        catch (Exception e) {
                            this.toXML = true;
                            this.handleJRException(this.getEditorInput(), e, false);
                        }
                        this.updateVisualView();
                    } else {
                        this.updateVisualView();
                    }
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (SimpleJRXMLEditor.this.outlinePage != null) {
                                SimpleJRXMLEditor.this.outlinePage.getSite().getSelectionProvider().setSelection(SimpleJRXMLEditor.this.tmpselection);
                            } else {
                                SimpleJRXMLEditor.this.setDesignerPageSelection(SimpleJRXMLEditor.this.tmpselection);
                            }
                        }
                    });
                    break;
                }
                case 1: {
                    if (this.toXML) {
                        this.toXML = false;
                        break;
                    }
                    this.isRefreshing = true;
                    this.model2xml(ver);
                    this.isRefreshing = false;
                }
            }
        }
        this.notify(newPageIndex);
        this.updateContentOutline(this.getActivePage());
        this.activePage = newPageIndex;
    }

    protected void notify(int newPageIndex) {
        ISelectionProvider outerProvider;
        ISelectionProvider selectionProvider;
        this.deactivateSite(false, false);
        IPartService partService = (IPartService)this.getSite().getService(IPartService.class);
        if (partService.getActivePart() == this) {
            this.setFocus();
        }
        IEditorPart activeEditor = this.getEditor(newPageIndex);
        IEditorActionBarContributor contributor = this.getEditorSite().getActionBarContributor();
        if (contributor != null && contributor instanceof MultiPageEditorActionBarContributor) {
            ((MultiPageEditorActionBarContributor)contributor).setActivePage(activeEditor);
        }
        if (activeEditor != null && (selectionProvider = activeEditor.getSite().getSelectionProvider()) != null && (outerProvider = this.getSite().getSelectionProvider()) instanceof MultiPageSelectionProvider) {
            SelectionChangedEvent event = new SelectionChangedEvent(selectionProvider, selectionProvider.getSelection());
            MultiPageSelectionProvider provider = (MultiPageSelectionProvider)outerProvider;
            provider.fireSelectionChanged(event);
            provider.firePostSelectionChanged(event);
        }
        this.activateSite();
        Object selectedPage = this.getSelectedPage();
        if (selectedPage != null) {
            this.firePageChanged(new PageChangedEvent((IPageChangeProvider)this, selectedPage));
        }
    }

    protected void firePageChanged(final PageChangedEvent event) {
        Object[] listeners = this.pageChangeListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final IPageChangedListener l = (IPageChangedListener)listeners[i];
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.pageChanged(event);
                }
            });
            ++i;
        }
    }

    public void addPageChangedListener(IPageChangedListener listener) {
        this.pageChangeListeners.add((Object)listener);
    }

    public void removePageChangedListener(IPageChangedListener listener) {
        this.pageChangeListeners.remove((Object)listener);
    }

    @Override
    protected String getEditorHelpID() {
        return "com.jaspersoft.studio.doc.editor_simple_jrxml";
    }

    @Override
    protected String model2xml(String version) {
        String xml = null;
        try {
            MReport mReport = this.getMReport();
            if (mReport != null) {
                JasperDesign report = mReport.getJasperDesign();
                xml = JRXmlWriterHelper.writeReport((JasperReportsContext)this.jrContext, (JRReport)report, "UTF-8", version);
                IDocumentProvider dp = this.xmlEditor.getDocumentProvider();
                IDocument doc = dp.getDocument((Object)this.xmlEditor.getEditorInput());
                this.xmlFresh = true;
                if (xml != null && !Arrays.equals(doc.get().getBytes(), xml.getBytes())) {
                    doc.set(xml);
                }
            }
        }
        catch (Throwable e) {
            UIUtils.showError((Throwable)e);
        }
        return xml;
    }

    @Override
    public boolean isDirty() {
        boolean designDirty;
        boolean bl = designDirty = this.getDesignEditor() != null && this.getDesignEditor().isDirty();
        if (designDirty) {
            return true;
        }
        return !this.xmlFresh;
    }

    @Override
    protected void createDesignEditorPage() throws PartInitException {
        this.reportContainer = new ReportContainer((EditorPart)this, this.jrContext){

            @Override
            protected ReportEditor createReportEditor(JasperReportsConfiguration context) {
                return new SimpleReportEditor(context);
            }
        };
        this.reportContainer.addPageChangedListener(new IPageChangedListener(){

            public void pageChanged(PageChangedEvent event) {
                SimpleJRXMLEditor.this.updateContentOutline(SimpleJRXMLEditor.this.getActivePage());
            }
        });
        int index = this.addPage((IEditorPart)this.reportContainer, this.getEditorInput());
        this.setPageText(index, Messages.JrxmlEditor_design);
    }

    @Override
    public void updateVisualView() {
        if (this.reportContainer != null) {
            this.reportContainer.setModel(this.getModel());
        }
    }

    @Override
    public void gotoMarker(IMarker marker) {
        if (this.activePage == 0) {
            try {
                Object expr = marker.getAttribute("MARKER_ERROR_JREXPRESSION");
                if (expr != null && expr instanceof String) {
                    JRDesignExpression expression = new JRDesignExpression();
                    expression.setId(new Integer((String)expr).intValue());
                    JasperDesign jd = this.getJasperDesign();
                    JRExpressionCollector rc = JRExpressionCollector.collector((JasperReportsContext)this.jrContext, (JRReport)jd);
                    if (!VErrorPreview.openExpressionEditor(this.jrContext, rc, (JRDesignDataset)jd.getMainDataset(), expression)) {
                        for (JRDataset d : jd.getDatasetsList()) {
                            if (!VErrorPreview.openExpressionEditor(this.jrContext, rc, (JRDesignDataset)d, expression)) continue;
                            return;
                        }
                    }
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        this.setActivePage(1);
        IDE.gotoMarker((IEditorPart)this.xmlEditor, (IMarker)marker);
    }

    @Override
    public CommonSelectionCacheProvider getSelectionCache() {
        return this.reportContainer.getSelectionCache();
    }

    @Override
    protected boolean isDesignerDirty() {
        return this.reportContainer.isDirty();
    }

    @Override
    protected ISelection getDesignerPageSelection() {
        return this.reportContainer.getActiveEditor().getSite().getSelectionProvider().getSelection();
    }

    @Override
    protected void setDesignerPageSelection(ISelection newSelection) {
        this.reportContainer.getActiveEditor().getSite().getSelectionProvider().setSelection(newSelection);
    }

    @Override
    protected EditorPart getDesignEditor() {
        return this.reportContainer;
    }

    @Override
    protected INode createEditorModel() {
        return ReportFactory.createToolReport(this.jrContext);
    }

    @Override
    public void openEditor(Object obj, ANode node) {
        this.reportContainer.openEditor(obj, node);
    }

    @Override
    public void dispose() {
        this.pageChangeListeners.clear();
        super.dispose();
    }

    @Override
    public String getTitleToolTip() {
        return JaspersoftStudioPlugin.getExtensionManager().getTitleToolTip(this.jrContext, super.getTitleToolTip());
    }

    public ReportContainer getReportContainer() {
        return this.reportContainer;
    }

    @Override
    public IEditorPart getActiveInnerEditor() {
        IEditorPart iep = this.getActiveEditor();
        if (iep instanceof ReportContainer) {
            return ((ReportContainer)iep).getActiveEditor();
        }
        return iep;
    }
}

