/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.action;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.editor.action.SetWorkbenchAction;
import com.jaspersoft.studio.editor.report.CachedSelectionProvider;
import com.jaspersoft.studio.editor.report.CommonSelectionCacheProvider;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.property.SetValueCommand;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRChild;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchPart;

public abstract class ACachedSelectionAction
extends SetWorkbenchAction {
    protected boolean fresh = false;
    protected boolean freshChecked = false;
    protected Command command;
    protected boolean ischecked = false;
    protected CachedSelectionProvider editor = null;

    public ACachedSelectionAction(IWorkbenchPart part) {
        super(part);
        this.editor = (CachedSelectionProvider)part;
    }

    public ACachedSelectionAction(IWorkbenchPart part, int style) {
        super(part, style);
        this.editor = (CachedSelectionProvider)part;
    }

    protected void handleSelectionChanged() {
        this.fresh = false;
        this.freshChecked = false;
        if (this.editor != null) {
            this.editor.getSelectionCache().selectionChanged(this.getSelection());
        }
        super.handleSelectionChanged();
    }

    public void run() {
        if (!this.fresh) {
            this.command = this.createCommand();
        }
        this.fresh = true;
        if (this.fresh && this.command != null) {
            this.execute(this.command);
        }
    }

    protected boolean calculateEnabled() {
        if (!this.fresh) {
            this.command = this.createCommand();
        }
        this.fresh = true;
        return this.command != null && this.command.canExecute();
    }

    protected Command createCommand() {
        List<Object> mGraphElements = this.editor.getSelectionCache().getSelectionModelForType(MGraphicElement.class);
        Iterator<Object> iterator = mGraphElements.iterator();
        if (iterator.hasNext()) {
            Object obj = iterator.next();
            JSSCompoundCommand cmd = new JSSCompoundCommand((ANode)obj);
            cmd.add(new SetValueCommand());
            return cmd;
        }
        return null;
    }

    public boolean checkSingleSelectedObject(Class<?> ... classes) {
        if (this.getSelectedObjects().size() != 1) {
            return false;
        }
        CommonSelectionCacheProvider cache = this.editor.getSelectionCache();
        Class<?>[] classArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> clazz = classArray[n2];
            if (!cache.getSelectionModelForType(clazz).isEmpty()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean checkAllSelectedObjects(Class<?> ... classes) {
        ArrayList<Object> elements = new ArrayList<Object>();
        Class<?>[] classArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> clazz = classArray[n2];
            List<Object> lst = this.editor.getSelectionCache().getSelectionModelForType(clazz);
            if (!Misc.isNullOrEmpty(lst)) {
                elements.addAll(lst);
            }
            ++n2;
        }
        return !elements.isEmpty() && elements.size() == this.getSelectedObjects().size();
    }

    @Override
    public void setWorkbenchPart(IWorkbenchPart part) {
        super.setWorkbenchPart(part);
        if (part instanceof CachedSelectionProvider) {
            this.fresh = false;
            this.editor = (CachedSelectionProvider)part;
        }
    }

    protected void setSelectionOnLastSibling() {
        EditPart editPart;
        EditPart parentPart;
        List children;
        Object obj;
        ISelection s = this.getSelection();
        if (s instanceof StructuredSelection && (obj = ((StructuredSelection)s).getFirstElement()) instanceof EditPart && (children = (parentPart = (editPart = (EditPart)obj).getParent()).getChildren()) != null && !children.isEmpty()) {
            int last = children.size() - 1;
            StructuredSelection newselection = new StructuredSelection(children.get(last));
            this.setSelection((ISelection)newselection);
            this.getWorkbenchPart().getSite().getSelectionProvider().setSelection((ISelection)newselection);
        }
    }

    protected void setSelectionOnSiblingElement(JRChild element) {
        EditPart editPart;
        EditPart parentPart;
        List children;
        Object obj;
        ISelection s = this.getSelection();
        if (s instanceof StructuredSelection && (obj = ((StructuredSelection)s).getFirstElement()) instanceof EditPart && (children = (parentPart = (editPart = (EditPart)obj).getParent()).getChildren()) != null) {
            for (Object child : children) {
                EditPart childPart = (EditPart)child;
                if (childPart.getModel() == null || ((INode)childPart.getModel()).getValue() != element) continue;
                StructuredSelection newselection = new StructuredSelection((Object)childPart);
                this.setSelection((ISelection)newselection);
                this.getWorkbenchPart().getSite().getSelectionProvider().setSelection((ISelection)newselection);
                break;
            }
        }
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isDynamic() {
        return false;
    }
}

