/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.action;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.action.ACachedSelectionAction;
import com.jaspersoft.studio.editor.action.IGlobalAction;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.MReport;
import com.jaspersoft.studio.model.band.MBand;
import com.jaspersoft.studio.model.band.MBandGroup;
import com.jaspersoft.studio.model.band.command.ReorderBandCommandByRelativeIndex;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.sf.jasperreports.eclipse.util.Pair;
import net.sf.jasperreports.engine.type.BandTypeEnum;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;

public class MoveDetailUpAction
extends ACachedSelectionAction
implements IGlobalAction {
    public static final String ID = "move_detail_up";
    private Comparator<Pair<Integer, MBand>> increasingComparator = new Comparator<Pair<Integer, MBand>>(){

        @Override
        public int compare(Pair<Integer, MBand> o1, Pair<Integer, MBand> o2) {
            return (Integer)o1.getKey() - (Integer)o2.getKey();
        }
    };

    public MoveDetailUpAction(IWorkbenchPart part) {
        super(part);
    }

    @Override
    protected Command createCommand() {
        List<Object> bands = this.editor.getSelectionCache().getSelectionModelForType(MBand.class);
        if (bands.isEmpty()) {
            return null;
        }
        MBand firstBand = (MBand)bands.get(0);
        if (!this.checkSameType(firstBand, bands)) {
            return null;
        }
        JSSCompoundCommand cmd = new JSSCompoundCommand(firstBand);
        cmd.enableSelectionRestore(true);
        ArrayList<Pair> bandsToMove = new ArrayList<Pair>();
        for (Object obj : bands) {
            MBand bandNode = (MBand)obj;
            ANode parent = bandNode.getParent();
            if (parent == null) continue;
            int index = parent.getChildren().indexOf(bandNode);
            if (index == 0) {
                return null;
            }
            INode previousItem = parent.getChildren().get(index - 1);
            if (previousItem instanceof MBand && bandNode.isSameBandType((MBand)previousItem)) {
                bandsToMove.add(new Pair((Object)index, (Object)bandNode));
                continue;
            }
            return null;
        }
        if (bandsToMove.size() > 0) {
            final EditPartViewer currentViewer = firstBand.getFigureEditPart().getViewer();
            Collections.sort(bandsToMove, this.increasingComparator);
            for (Pair band : bandsToMove) {
                MBand bandNode = (MBand)band.getValue();
                if (bandNode.getBandType() == BandTypeEnum.GROUP_FOOTER || bandNode.getBandType() == BandTypeEnum.GROUP_HEADER) {
                    cmd.add(new ReorderBandCommandByRelativeIndex((MBandGroup)bandNode, -1));
                    continue;
                }
                if (bandNode.getBandType() != BandTypeEnum.DETAIL) continue;
                cmd.add(new ReorderBandCommandByRelativeIndex(bandNode, (MReport)bandNode.getParent(), -1));
            }
            if (!cmd.isEmpty()) {
                cmd.add(new Command(){

                    public void execute() {
                        ISelection currentSelection = currentViewer.getSelection();
                        currentViewer.deselectAll();
                        currentViewer.setSelection(currentSelection);
                    }
                });
            }
        }
        return cmd.isEmpty() ? null : cmd;
    }

    protected boolean checkSameType(MBand firstBand, List<?> bands) {
        for (Object band : bands) {
            MBand node = (MBand)band;
            if (firstBand.isSameBandType(node)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean calculateEnabled() {
        return super.calculateEnabled();
    }

    protected void init() {
        super.init();
        this.setText(Messages.MoveDetailUpAction_actionName);
        this.setToolTipText(Messages.MoveDetailUpAction_actionDescription);
        this.setId(ID);
        this.setImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/resources/arrow-band-up.png"));
        this.setEnabled(false);
    }
}

