/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.action;

import com.jaspersoft.studio.editor.AbstractJRXMLEditor;
import com.jaspersoft.studio.editor.preview.PreviewContainer;
import com.jaspersoft.studio.editor.preview.view.AViewsFactory;
import com.jaspersoft.studio.editor.preview.view.ViewsFactory;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class PreviewFormatDropDownAction
extends Action
implements IMenuCreator {
    public static final String ID = "SettingOutputAction";
    private Menu menu;
    private JasperReportsConfiguration jConfig;
    private AViewsFactory viewFactory;

    public PreviewFormatDropDownAction(JasperReportsConfiguration jConfig) {
        this.setText(Messages.ViewSettingsDropDownAction_settingsName);
        this.setMenuCreator(this);
        this.setId(ID);
        this.jConfig = jConfig;
    }

    private AbstractJRXMLEditor getEditor() {
        return (AbstractJRXMLEditor)this.jConfig.get("thecurrenteditor");
    }

    public void dispose() {
        if (this.menu != null) {
            this.menu.dispose();
            this.menu = null;
        }
    }

    public Menu getMenu(Menu parent) {
        this.createOutputMenu(parent);
        return this.menu;
    }

    public Menu getMenu(Control parent) {
        Menu rootMenu = new Menu(parent);
        this.createOutputMenu(rootMenu);
        this.menu = rootMenu;
        return this.menu;
    }

    private void creteItem(String key, final AbstractJRXMLEditor editor) {
        final MenuItem item = new MenuItem(this.menu, 32);
        item.setText(this.viewFactory.getLabel(key));
        item.setData("KEY", (Object)key);
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                editor.setPreviewOutput((String)item.getData("KEY"), false);
                editor.setPreviewDirty(true);
            }
        });
    }

    private void createOutputMenu(Menu parent) {
        AbstractJRXMLEditor editor = this.getEditor();
        PreviewContainer preview = (PreviewContainer)editor.getEditor(2);
        if (preview != null) {
            MenuItem root = new MenuItem(parent, 64);
            this.menu = new Menu(parent);
            root.setMenu(this.menu);
            root.setText(Messages.ViewSettingsDropDownAction_previewFormatMenu);
            this.viewFactory = preview.getViewFactory();
            for (String key : this.viewFactory.getKeys()) {
                if (this.viewFactory.isSeparator(key)) {
                    if (key.equals(ViewsFactory.HTML_NO_INTERACTIVITY) && !this.jConfig.getPropertyBoolean("com.jaspersoft.studio.exporter.show.html", false).booleanValue()) continue;
                    new MenuItem(this.menu, 2);
                    continue;
                }
                this.creteItem(key, editor);
            }
            this.menu.addMenuListener((MenuListener)new MenuAdapter(){

                public void menuShown(MenuEvent e) {
                    String actualPreview = PreviewFormatDropDownAction.this.getEditor().getDefaultViewerKey();
                    MenuItem[] menuItemArray = PreviewFormatDropDownAction.this.menu.getItems();
                    int n = menuItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        MenuItem item = menuItemArray[n2];
                        item.setSelection(item.getText().equals(actualPreview));
                        ++n2;
                    }
                }
            });
        }
    }
}

