/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.action;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.net.URI;
import java.net.URISyntaxException;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.HashPrintServiceAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.PrintServiceAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.Destination;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PageRanges;
import javax.print.attribute.standard.PrinterName;
import javax.print.attribute.standard.SheetCollate;
import javax.print.attribute.standard.Sides;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.JRGraphics2DExporter;
import net.sf.jasperreports.engine.export.JRPrintServiceExporter;
import net.sf.jasperreports.engine.type.OrientationEnum;
import net.sf.jasperreports.export.ExporterConfiguration;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.ReportExportConfiguration;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleGraphics2DExporterOutput;
import net.sf.jasperreports.export.SimpleGraphics2DReportConfiguration;
import net.sf.jasperreports.export.SimplePrintServiceExporterConfiguration;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PrintFigureOperation;
import org.eclipse.draw2d.PrinterGraphics;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.ui.actions.WorkbenchPartAction;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;

public class PrintAction
extends WorkbenchPartAction {
    private static final PaletteData palette = new PaletteData(0xFF0000, 65280, 255);

    public PrintAction(IWorkbenchPart part) {
        super(part);
    }

    protected boolean calculateEnabled() {
        PrinterData[] printers = Printer.getPrinterList();
        return printers != null && printers.length > 0;
    }

    protected void init() {
        super.init();
        this.setText("&Print");
        this.setToolTipText("Print");
        this.setId(ActionFactory.PRINT.getId());
    }

    public void run() {
        IWorkbenchPart workbenchPart = this.getWorkbenchPart();
        final JasperReportsContext jrContext = (JasperReportsContext)workbenchPart.getAdapter(JasperReportsContext.class);
        final JasperPrint jrPrint = (JasperPrint)workbenchPart.getAdapter(JasperPrint.class);
        if (jrPrint != null) {
            PrintDialog dialog = new PrintDialog(UIUtils.getShell(), 0);
            final PrinterData data = dialog.open();
            if (data != null) {
                Job job = new Job("Printing the Report"){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            PrintAction.this.printUsingSWT(monitor, jrContext, jrPrint, data);
                        }
                        finally {
                            monitor.done();
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.setUser(true);
                job.setPriority(30);
                job.schedule();
            }
        } else {
            UIUtils.showInformation((String)"Printing", (String)"There is no Report to Print, or report has not finished to execute.");
        }
    }

    protected void printUsingSWT(final IProgressMonitor monitor, final JasperReportsContext jrContext, final JasperPrint jrPrint, final PrinterData data) {
        PrintFigureOperation pfo = new PrintFigureOperation(new Printer(data), (IFigure)new RectangleFigure()){
            private GC gc;
            private Image imgPage;
            private BufferedImage awtImage;
            private ImageData imageData;

            protected void printPages() {
                PrinterGraphics graphics = this.getFreshPrinterGraphics();
                UIUtils.getDisplay().syncExec(new Runnable((Graphics)graphics){
                    private final /* synthetic */ Graphics val$graphics;
                    {
                        this.val$graphics = graphics;
                    }

                    @Override
                    public void run() {
                        IFigure figure = this.getPrintSource();
                        figure.setFont(UIUtils.getShell().getFont());
                        this.setupPrinterGraphicsFor(this.val$graphics, figure);
                        Rectangle bounds = this.getPrintRegion();
                        imgPage = new Image(null, bounds.width, bounds.height);
                        gc = new GC((Drawable)imgPage);
                        SWTGraphics g = new SWTGraphics(gc);
                        g.translate(bounds.x, bounds.y);
                        figure.paint((Graphics)g);
                    }
                });
                int nrpages = jrPrint.getPages().size();
                block0 : switch (data.scope) {
                    case 0: {
                        monitor.beginTask("Printing the Report", nrpages);
                        int j = 0;
                        while (j < nrpages) {
                            this.printPage(monitor, jrContext, jrPrint, (Graphics)graphics, j);
                            if (monitor.isCanceled()) break block0;
                            monitor.internalWorked(1.0);
                            ++j;
                        }
                        break;
                    }
                    case 1: {
                        monitor.beginTask("Printing the Report", data.endPage - data.startPage);
                        int j = data.startPage - 1;
                        while (j < data.endPage && j < nrpages) {
                            this.printPage(monitor, jrContext, jrPrint, (Graphics)graphics, j);
                            if (monitor.isCanceled()) break block0;
                            monitor.internalWorked(1.0);
                            ++j;
                        }
                        break;
                    }
                    case 2: {
                        monitor.beginTask("Printing the Report", 1);
                        this.printPage(monitor, jrContext, jrPrint, (Graphics)graphics, 0);
                    }
                }
                this.gc.dispose();
                this.gc.dispose();
                this.imgPage.dispose();
            }

            protected void printPage(IProgressMonitor monitor2, JasperReportsContext jrContext2, JasperPrint jrPrint2, final Graphics graphics, int j) {
                monitor2.subTask("Page:" + (j + 1));
                graphics.pushState();
                this.getPrinter().startPage();
                final Image srcImage = new Image(null, this.getNewImageData(jrContext2, jrPrint2, j));
                graphics.drawImage(srcImage, 0, 0);
                this.getPrinter().endPage();
                UIUtils.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        graphics.popState();
                        srcImage.dispose();
                    }
                });
            }

            protected ImageData getNewImageData(JasperReportsContext jrContext2, JasperPrint jrPrint2, int page) {
                if (this.awtImage == null) {
                    int imgW = jrPrint2.getPageWidth();
                    int imgH = jrPrint2.getPageHeight();
                    if (jrPrint2.getOrientationValue() == OrientationEnum.LANDSCAPE) {
                        imgW = jrPrint2.getPageHeight();
                        imgH = jrPrint2.getPageWidth();
                    }
                    this.awtImage = new BufferedImage(imgW, imgH, 1);
                    this.imageData = new ImageData(this.awtImage.getWidth(), this.awtImage.getHeight(), 32, palette);
                }
                Graphics2D g2d = (Graphics2D)this.awtImage.getGraphics();
                try {
                    try {
                        JRGraphics2DExporter exporter = new JRGraphics2DExporter(jrContext2);
                        exporter.setExporterInput((ExporterInput)new SimpleExporterInput(jrPrint2));
                        SimpleGraphics2DReportConfiguration grxConfiguration = new SimpleGraphics2DReportConfiguration();
                        SimpleGraphics2DExporterOutput output = new SimpleGraphics2DExporterOutput();
                        output.setGraphics2D(g2d);
                        exporter.setExporterOutput((ExporterOutput)output);
                        grxConfiguration.setPageIndex(Integer.valueOf(page));
                        exporter.setConfiguration((ReportExportConfiguration)grxConfiguration);
                        exporter.exportReport();
                        int[] data2 = ((DataBufferInt)this.awtImage.getData().getDataBuffer()).getData();
                        this.imageData.setPixels(0, 0, data2.length, data2, 0);
                    }
                    catch (JRException e) {
                        e.printStackTrace();
                        g2d.dispose();
                    }
                }
                finally {
                    g2d.dispose();
                }
                return this.imageData;
            }
        };
        pfo.run(jrPrint.getName());
    }

    protected void printUsingJR(JasperReportsContext jrContext, JasperPrint jrPrint, PrinterData data) {
        try {
            JRPrintServiceExporter pexp = new JRPrintServiceExporter(jrContext);
            HashPrintRequestAttributeSet printRequestAttributeSet = new HashPrintRequestAttributeSet();
            printRequestAttributeSet.add(new Copies(data.copyCount));
            printRequestAttributeSet.add(data.orientation == 2 ? OrientationRequested.LANDSCAPE : OrientationRequested.PORTRAIT);
            printRequestAttributeSet.add(data.collate ? SheetCollate.COLLATED : SheetCollate.UNCOLLATED);
            switch (data.duplex) {
                case 1: {
                    printRequestAttributeSet.add(Sides.TWO_SIDED_LONG_EDGE);
                    break;
                }
                case 2: {
                    printRequestAttributeSet.add(Sides.TWO_SIDED_SHORT_EDGE);
                    break;
                }
                case 0: {
                    printRequestAttributeSet.add(Sides.ONE_SIDED);
                }
            }
            if (data.printToFile) {
                try {
                    printRequestAttributeSet.add(new Destination(new URI(data.fileName)));
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
            switch (data.scope) {
                case 0: 
                case 2: {
                    break;
                }
                case 1: {
                    printRequestAttributeSet.add(new PageRanges(data.startPage, data.endPage));
                }
            }
            HashPrintServiceAttributeSet printServiceAttributeSet = new HashPrintServiceAttributeSet();
            printServiceAttributeSet.add(new PrinterName(data.name, null));
            SimplePrintServiceExporterConfiguration configuration = new SimplePrintServiceExporterConfiguration();
            configuration.setPrintRequestAttributeSet((PrintRequestAttributeSet)printRequestAttributeSet);
            configuration.setPrintServiceAttributeSet((PrintServiceAttributeSet)printServiceAttributeSet);
            configuration.setDisplayPageDialog(Boolean.valueOf(false));
            configuration.setDisplayPageDialogOnlyOnce(Boolean.valueOf(false));
            configuration.setDisplayPrintDialog(Boolean.valueOf(false));
            PrintService[] service = PrintServiceLookup.lookupPrintServices(DocFlavor.INPUT_STREAM.PDF, printRequestAttributeSet);
            if (service.length > 0) {
                configuration.setPrintService(service[0]);
            }
            pexp.setConfiguration((ExporterConfiguration)configuration);
            pexp.setExporterInput((ExporterInput)new SimpleExporterInput(jrPrint));
            pexp.exportReport();
        }
        catch (JRException e) {
            UIUtils.showError((Throwable)e);
        }
    }
}

