/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.action.align;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.compatibility.ToolUtilitiesCompatibility;
import com.jaspersoft.studio.editor.action.ACachedSelectionAction;
import com.jaspersoft.studio.editor.action.IGlobalAction;
import com.jaspersoft.studio.editor.gef.commands.AlignCommand;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.MGraphicElement;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.ui.IWorkbenchPart;

public class Align2BorderAction
extends ACachedSelectionAction
implements IGlobalAction {
    public static final String ID_ALIGN_BOTTOM = "band_org.eclipse.gef.align_bottom";
    public static final String ID_ALIGN_CENTER = "band_org.eclipse.gef.align_center";
    public static final String ID_ALIGN_LEFT = "band_org.eclipse.gef.align_left";
    public static final String ID_ALIGN_MIDDLE = "band_org.eclipse.gef.align_middle";
    public static final String ID_ALIGN_RIGHT = "band_org.eclipse.gef.align_right";
    public static final String ID_ALIGN_TOP = "band_org.eclipse.gef.align_top";
    private int alignment;

    public Align2BorderAction(IWorkbenchPart part, int align) {
        super(part);
        this.alignment = align;
        this.initUI();
    }

    @Override
    protected Command createCommand() {
        List<Object> editparts = this.editor.getSelectionCache().getSelectionModelPartForType(MGraphicElement.class);
        if (editparts.isEmpty()) {
            return null;
        }
        JSSCompoundCommand command = new JSSCompoundCommand(null);
        editparts = ToolUtilitiesCompatibility.getSelectionWithoutDependants(editparts);
        command.setDebugLabel(this.getText());
        int i = 0;
        while (i < editparts.size()) {
            EditPart editpart = (EditPart)editparts.get(i);
            if (editpart.getModel() instanceof MGraphicElement) {
                command.add(new AlignCommand(this.alignment, editpart));
                command.setReferenceNodeIfNull(editpart.getModel());
            }
            ++i;
        }
        return command;
    }

    protected void initUI() {
        switch (this.alignment) {
            case 1: {
                this.setId(ID_ALIGN_LEFT);
                this.setText(Messages.Align2BorderAction_align_to_left);
                this.setToolTipText(Messages.Align2BorderAction_align_to_left_tool_tip);
                this.setImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/resources/eclipse/align-band-left.gif"));
                this.setDisabledImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/resources/eclipse/disabled/align-band-left.gif"));
                break;
            }
            case 4: {
                this.setId(ID_ALIGN_RIGHT);
                this.setText(Messages.Align2BorderAction_align_to_right);
                this.setToolTipText(Messages.Align2BorderAction_align_to_right_tool_tip);
                this.setImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/resources/eclipse/align-band-right.gif"));
                this.setDisabledImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/resources/eclipse/disabled/align-band-right.gif"));
                break;
            }
            case 8: {
                this.setId(ID_ALIGN_TOP);
                this.setText(Messages.Align2BorderAction_align_to_top);
                this.setToolTipText(Messages.Align2BorderAction_align_to_top_tool_tip);
                this.setImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/resources/eclipse/align-band-top.gif"));
                this.setDisabledImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/resources/eclipse/disabled/align-band-top.gif"));
                break;
            }
            case 32: {
                this.setId(ID_ALIGN_BOTTOM);
                this.setText(Messages.Align2BorderAction_align_to_bottom);
                this.setToolTipText(Messages.Align2BorderAction_align_to_bottom_tool_tip);
                this.setImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/resources/eclipse/align-band-bottom.gif"));
                this.setDisabledImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/resources/eclipse/disabled/align-band-bottom.gif"));
                break;
            }
            case 2: {
                this.setId(ID_ALIGN_CENTER);
                this.setText(Messages.Align2BorderAction_align_to_center);
                this.setToolTipText(Messages.Align2BorderAction_align_to_center_tool_tip);
                this.setImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/resources/eclipse/align-band-center.gif"));
                this.setDisabledImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/resources/eclipse/disabled/align-band-center.gif"));
                break;
            }
            case 16: {
                this.setId(ID_ALIGN_MIDDLE);
                this.setText(Messages.Align2BorderAction_align_to_middle);
                this.setToolTipText(Messages.Align2BorderAction_align_to_middle_tool_tip);
                this.setImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/resources/eclipse/align-band-middle.gif"));
                this.setDisabledImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/resources/eclipse/disabled/align-band-middle.gif"));
            }
        }
    }
}

