/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.action.band;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.IGraphicElement;
import com.jaspersoft.studio.model.IGroupElement;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.MElementGroup;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.model.MPage;
import com.jaspersoft.studio.property.SetValueCommand;
import com.jaspersoft.studio.utils.ModelUtils;
import java.util.List;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignElement;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.ui.IWorkbenchPart;

public class MaximizeContainerAction
extends SelectionAction {
    public static final String ID = "maximizecontainer";

    public MaximizeContainerAction(IWorkbenchPart part) {
        super(part);
        this.setLazyEnablementCalculation(true);
        this.setText(Messages.MaximizeContainerAction_name);
        this.setToolTipText(Messages.MaximizeContainerAction_tooltip);
        this.setId(ID);
        this.setEnabled(false);
    }

    protected boolean calculateEnabled() {
        Command cmd = this.createReorderCommand(this.getSelectedObjects());
        if (cmd == null) {
            return false;
        }
        return cmd.canExecute();
    }

    public Command createReorderCommand(List<?> objects) {
        Object model;
        if (objects == null || objects.isEmpty()) {
            return null;
        }
        Object obj = objects.get(0);
        if (obj instanceof EditPart && (model = ((EditPart)obj).getModel()) instanceof ANode) {
            int bandHeight;
            ANode n = (ANode)model;
            if (n instanceof MPage) {
                for (INode c : n.getChildren()) {
                    if (!(c instanceof MGraphicElement)) continue;
                    n = (ANode)c;
                    break;
                }
            }
            if (!(n instanceof IGraphicElement)) {
                return null;
            }
            JRElementGroup container = this.getContainer(n);
            if (container == null) {
                return null;
            }
            APropertyNode mcontainer = this.getContainerNode(n);
            JSSCompoundCommand cc = new JSSCompoundCommand(this.getText(), (ANode)mcontainer);
            if (container instanceof JRDesignBand && (bandHeight = ModelUtils.getMaxBandHeight((JRDesignBand)container, mcontainer.getJasperDesign())) > 0) {
                SetValueCommand cmd = new SetValueCommand();
                cmd.setTarget(mcontainer);
                cmd.setPropertyId("height");
                cmd.setPropertyValue(bandHeight);
                cc.add(cmd);
            }
            return cc.isEmpty() ? null : cc;
        }
        return null;
    }

    private JRElementGroup getContainer(ANode n) {
        if (n != null) {
            Object val = n.getValue();
            if (n instanceof IGroupElement) {
                return ((IGroupElement)((Object)n)).getJRElementGroup();
            }
            if (val instanceof JRElementGroup) {
                return (JRElementGroup)val;
            }
            if (val instanceof JRDesignElement) {
                return this.getContainer(n.getParent());
            }
        }
        return null;
    }

    private APropertyNode getContainerNode(ANode n) {
        Object val = n.getValue();
        if (n instanceof IGroupElement) {
            return (APropertyNode)n;
        }
        if (val instanceof JRElementGroup) {
            if (n instanceof MElementGroup) {
                return this.getContainerNode(n.getParent());
            }
            return (APropertyNode)n;
        }
        if (val instanceof JRDesignElement) {
            return this.getContainerNode(n.getParent());
        }
        return null;
    }

    public void run() {
        this.execute(this.createReorderCommand(this.getSelectedObjects()));
    }
}

