/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.action.copy;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.action.ACachedSelectionAction;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.utils.AlfaRGB;
import com.jaspersoft.studio.utils.Colors;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sf.jasperreports.engine.JRBoxContainer;
import net.sf.jasperreports.engine.JRCommonElement;
import net.sf.jasperreports.engine.JRCommonImage;
import net.sf.jasperreports.engine.JRCommonRectangle;
import net.sf.jasperreports.engine.JRCommonText;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRImageAlignment;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRStyleContainer;
import net.sf.jasperreports.engine.JRTextAlignment;
import net.sf.jasperreports.engine.JRTextField;
import net.sf.jasperreports.engine.base.JRBoxPen;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignGraphicElement;
import net.sf.jasperreports.engine.type.HorizontalImageAlignEnum;
import net.sf.jasperreports.engine.type.HorizontalTextAlignEnum;
import net.sf.jasperreports.engine.type.LineStyleEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.RotationEnum;
import net.sf.jasperreports.engine.type.ScaleImageEnum;
import net.sf.jasperreports.engine.type.VerticalImageAlignEnum;
import net.sf.jasperreports.engine.type.VerticalTextAlignEnum;
import org.eclipse.ui.IWorkbenchPart;

public class CopyFormatAction
extends ACachedSelectionAction {
    public static final String[] propertyNames = new String[]{"backcolor", "isBlankWhenNull", "isBold", "fontName", "fontSize", "forecolor", "horizontalTextAlignment", "horizontalImageAlignment", "isItalic", "markup", "mode", "pattern", "isPdfEmbedded", "pdfEncoding", "pdfFontName", "radius", "rotation", "scaleImage", "isStrikeThrough", "isUnderline", "verticalTextAlignment", "verticalImageAlignment"};
    private static HashMap<String, Object> copiedValues = null;
    public static final String ID = "CopyFormatAction";

    public CopyFormatAction(IWorkbenchPart part) {
        super(part);
        this.setLazyEnablementCalculation(true);
    }

    protected void init() {
        super.init();
        this.setText(Messages.CopyFormatAction_title);
        this.setId(ID);
        this.setImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/resources/copy_format.png"));
        this.setEnabled(false);
    }

    @Override
    public void run() {
        List<APropertyNode> nodes = this.getNodes();
        if (nodes.size() == 1) {
            copiedValues = new HashMap();
            APropertyNode node = nodes.get(0);
            JRDesignElement element = (JRDesignElement)node.getValue();
            this.readAttribute(element);
        }
    }

    private void readAttribute(JRDesignElement element) {
        JRBoxContainer container;
        JRTextAlignment text;
        copiedValues.put("backcolor", this.getBackcolor((JRCommonElement)element));
        copiedValues.put("forecolor", this.getForecolor((JRCommonElement)element));
        copiedValues.put("mode", this.getMode((JRCommonElement)element));
        if (element instanceof JRFont) {
            JRFont font = (JRFont)element;
            copiedValues.put("isBold", this.isBold(font));
            copiedValues.put("isItalic", this.isItalic(font));
            copiedValues.put("isStrikeThrough", this.isStrikeThrough(font));
            copiedValues.put("isUnderline", this.isUnderline(font));
            copiedValues.put("fontName", this.getFontName(font));
            copiedValues.put("fontSize", this.getFontsize(font));
            copiedValues.put("isPdfEmbedded", this.isPdfEmbedded(font));
            copiedValues.put("pdfEncoding", this.getPdfEncoding(font));
            copiedValues.put("pdfFontName", this.getPdfFontName(font));
        }
        if (element instanceof JRTextAlignment) {
            text = (JRTextAlignment)element;
            copiedValues.put("horizontalTextAlignment", this.getHorizontalTextAlign(text));
            copiedValues.put("verticalTextAlignment", this.getVerticalTextAlign(text));
        }
        if (element instanceof JRImageAlignment) {
            text = (JRImageAlignment)element;
            copiedValues.put("horizontalImageAlignment", this.getHorizontalImageAlign((JRImageAlignment)text));
            copiedValues.put("verticalImageAlignment", this.getVerticalImageAlign((JRImageAlignment)text));
        }
        if (element instanceof JRCommonText) {
            text = (JRCommonText)element;
            copiedValues.put("markup", this.getMarkup((JRCommonText)text));
            copiedValues.put("rotation", this.getRotationValue((JRCommonText)text));
        }
        if (element instanceof JRTextField) {
            text = (JRTextField)element;
            copiedValues.put("isBlankWhenNull", this.isBlankWhenNull((JRTextField)text));
            copiedValues.put("pattern", this.getPattern((JRTextField)text));
        }
        if (element instanceof JRCommonRectangle) {
            JRCommonRectangle rectangle = (JRCommonRectangle)element;
            copiedValues.put("radius", this.getRadius(rectangle));
        }
        if (element instanceof JRCommonImage) {
            JRCommonImage image = (JRCommonImage)element;
            copiedValues.put("scaleImage", this.getScaleImageValue(image));
        }
        if (element instanceof JRBoxContainer) {
            container = (JRBoxContainer)element;
            JRLineBox box = container.getLineBox();
            if (box != null) {
                copiedValues.put("padding", this.getPadding(box));
                copiedValues.put("bottomPadding", this.getBottomPadding(box));
                copiedValues.put("leftPadding", this.getLeftPadding(box));
                copiedValues.put("rightPadding", this.getRightPadding(box));
                copiedValues.put("topPadding", this.getTopPadding(box));
                this.readPen("LinePen", box.getPen());
                this.readPen("LinePen_LEFT", box.getLeftPen());
                this.readPen("LinePen_RIGHT", box.getRightPen());
                this.readPen("LinePen_TOP", box.getTopPen());
                this.readPen("LinePen_BOTTOM", box.getBottomPen());
            }
        } else if (element instanceof JRDesignGraphicElement) {
            container = (JRDesignGraphicElement)element;
            this.readPen("LinePen", container.getLinePen());
        }
    }

    private void readPen(String penPrefix, JRBoxPen currentPen) {
        if (currentPen != null) {
            copiedValues.put(String.valueOf(penPrefix) + "lineWidth", this.getLineWidth(currentPen));
            copiedValues.put(String.valueOf(penPrefix) + "lineColor", this.getLineColor(currentPen));
            copiedValues.put(String.valueOf(penPrefix) + "lineStyle", this.getLineStyleValue(currentPen));
        }
    }

    private void readPen(String penPrefix, JRPen currentPen) {
        if (currentPen != null) {
            copiedValues.put(String.valueOf(penPrefix) + "lineWidth", this.getLineWidth(currentPen));
            copiedValues.put(String.valueOf(penPrefix) + "lineColor", this.getLineColor(currentPen));
            copiedValues.put(String.valueOf(penPrefix) + "lineStyle", this.getLineStyleValue(currentPen));
        }
    }

    protected List<APropertyNode> getNodes() {
        ArrayList<APropertyNode> result = new ArrayList<APropertyNode>();
        List<Object> graphicalElements = this.editor.getSelectionCache().getSelectionModelForType(MGraphicElement.class);
        if (graphicalElements.isEmpty()) {
            return result;
        }
        for (Object it : graphicalElements) {
            result.add((APropertyNode)it);
        }
        return result;
    }

    @Override
    protected boolean calculateEnabled() {
        return this.getNodes().size() == 1;
    }

    public static boolean hasCopiedValues() {
        return copiedValues != null;
    }

    public static Object getCopiedValue(String key) {
        return copiedValues.get(key);
    }

    private JRStyle getBaseStyle(JRStyleContainer styleContainer) {
        if (styleContainer != null) {
            JRStyle style = styleContainer.getStyle();
            if (style != null) {
                return style;
            }
            JRDefaultStyleProvider defaultStyleProvider = styleContainer.getDefaultStyleProvider();
            if (defaultStyleProvider != null) {
                return defaultStyleProvider.getDefaultStyle();
            }
        }
        return null;
    }

    private Boolean getMode(JRCommonElement element) {
        ModeEnum mode;
        ModeEnum ownMode = element.getOwnModeValue();
        if (ownMode != null) {
            return ModeEnum.TRANSPARENT.equals((Object)ownMode);
        }
        JRStyle style = this.getBaseStyle((JRStyleContainer)element);
        if (style != null && (mode = style.getModeValue()) != null) {
            return ModeEnum.TRANSPARENT.equals((Object)mode);
        }
        return null;
    }

    private AlfaRGB getForecolor(JRCommonElement element) {
        Color forecolor;
        Color ownForecolor = element.getOwnForecolor();
        if (ownForecolor != null) {
            return Colors.getSWTRGB4AWTGBColor(ownForecolor);
        }
        JRStyle style = this.getBaseStyle((JRStyleContainer)element);
        if (style != null && (forecolor = style.getForecolor()) != null) {
            return Colors.getSWTRGB4AWTGBColor(forecolor);
        }
        return null;
    }

    private String getPattern(JRTextField element) {
        String ownPattern = element.getOwnPattern();
        if (ownPattern != null) {
            return ownPattern;
        }
        JRStyle baseStyle = this.getBaseStyle((JRStyleContainer)element);
        if (baseStyle != null) {
            return baseStyle.getPattern();
        }
        return null;
    }

    private AlfaRGB getBackcolor(JRCommonElement element) {
        Color backcolor;
        Color ownBackcolor = element.getOwnBackcolor();
        if (ownBackcolor != null) {
            return Colors.getSWTRGB4AWTGBColor(ownBackcolor);
        }
        JRStyle style = this.getBaseStyle((JRStyleContainer)element);
        if (style != null && (backcolor = style.getBackcolor()) != null) {
            return Colors.getSWTRGB4AWTGBColor(backcolor);
        }
        return null;
    }

    private Float getLineWidth(JRPen pen) {
        Float lineWidth;
        Float ownLineWidth = pen.getOwnLineWidth();
        if (ownLineWidth != null) {
            return ownLineWidth;
        }
        JRStyle baseStyle = this.getBaseStyle((JRStyleContainer)pen.getPenContainer());
        if (baseStyle != null && (lineWidth = baseStyle.getLinePen().getLineWidth()) != null) {
            return lineWidth;
        }
        return null;
    }

    private Float getLineWidth(JRBoxPen boxPen) {
        Float lineWidth;
        Float ownLineWidth = boxPen.getOwnLineWidth();
        if (ownLineWidth != null) {
            return ownLineWidth;
        }
        Float penLineWidth = boxPen.getBox().getPen().getOwnLineWidth();
        if (penLineWidth != null) {
            return penLineWidth;
        }
        JRStyle baseStyle = this.getBaseStyle((JRStyleContainer)boxPen.getPenContainer());
        if (baseStyle != null && (lineWidth = boxPen.getPen(baseStyle.getLineBox()).getLineWidth()) != null) {
            return lineWidth;
        }
        return null;
    }

    private LineStyleEnum getLineStyleValue(JRPen pen) {
        LineStyleEnum lineStyle;
        LineStyleEnum ownLineStyle = pen.getOwnLineStyleValue();
        if (ownLineStyle != null) {
            return ownLineStyle;
        }
        JRStyle baseStyle = this.getBaseStyle((JRStyleContainer)pen.getPenContainer());
        if (baseStyle != null && (lineStyle = baseStyle.getLinePen().getLineStyleValue()) != null) {
            return lineStyle;
        }
        return null;
    }

    private LineStyleEnum getLineStyleValue(JRBoxPen boxPen) {
        LineStyleEnum lineStyle;
        LineStyleEnum ownLineStyle = boxPen.getOwnLineStyleValue();
        if (ownLineStyle != null) {
            return ownLineStyle;
        }
        LineStyleEnum penLineStyle = boxPen.getBox().getPen().getOwnLineStyleValue();
        if (penLineStyle != null) {
            return penLineStyle;
        }
        JRStyle baseStyle = this.getBaseStyle((JRStyleContainer)boxPen.getPenContainer());
        if (baseStyle != null && (lineStyle = boxPen.getPen(baseStyle.getLineBox()).getLineStyleValue()) != null) {
            return lineStyle;
        }
        return null;
    }

    private AlfaRGB getLineColor(JRPen pen) {
        Color lineColor;
        Color ownLineColor = pen.getOwnLineColor();
        if (ownLineColor != null) {
            return Colors.getSWTRGB4AWTGBColor(ownLineColor);
        }
        JRStyle baseStyle = this.getBaseStyle((JRStyleContainer)pen.getPenContainer());
        if (baseStyle != null && (lineColor = baseStyle.getLinePen().getLineColor()) != null) {
            return Colors.getSWTRGB4AWTGBColor(lineColor);
        }
        return null;
    }

    private AlfaRGB getLineColor(JRBoxPen boxPen) {
        Color lineColor;
        Color ownLineColor = boxPen.getOwnLineColor();
        if (ownLineColor != null) {
            return Colors.getSWTRGB4AWTGBColor(ownLineColor);
        }
        Color penLineColor = boxPen.getBox().getPen().getOwnLineColor();
        if (penLineColor != null) {
            return Colors.getSWTRGB4AWTGBColor(penLineColor);
        }
        JRStyle baseStyle = this.getBaseStyle((JRStyleContainer)boxPen.getPenContainer());
        if (baseStyle != null && (lineColor = boxPen.getPen(baseStyle.getLineBox()).getLineColor()) != null) {
            return Colors.getSWTRGB4AWTGBColor(lineColor);
        }
        return null;
    }

    private Integer getRadius(JRCommonRectangle rectangle) {
        Integer radius;
        Integer ownRadius = rectangle.getOwnRadius();
        if (ownRadius != null) {
            return (int)ownRadius;
        }
        JRStyle baseStyle = this.getBaseStyle((JRStyleContainer)rectangle);
        if (baseStyle != null && (radius = baseStyle.getRadius()) != null) {
            return (int)radius;
        }
        return null;
    }

    private ScaleImageEnum getScaleImageValue(JRCommonImage image) {
        ScaleImageEnum scaleImage;
        ScaleImageEnum ownScaleImage = image.getOwnScaleImageValue();
        if (ownScaleImage != null) {
            return ownScaleImage;
        }
        JRStyle baseStyle = this.getBaseStyle((JRStyleContainer)image);
        if (baseStyle != null && (scaleImage = baseStyle.getScaleImageValue()) != null) {
            return scaleImage;
        }
        return null;
    }

    private HorizontalTextAlignEnum getHorizontalTextAlign(JRTextAlignment alignment) {
        HorizontalTextAlignEnum horizontalAlignment;
        HorizontalTextAlignEnum ownHorizontalAlignment = alignment.getOwnHorizontalTextAlign();
        if (ownHorizontalAlignment != null) {
            return ownHorizontalAlignment;
        }
        JRStyle baseStyle = this.getBaseStyle((JRStyleContainer)alignment);
        if (baseStyle != null && (horizontalAlignment = baseStyle.getHorizontalTextAlign()) != null) {
            return horizontalAlignment;
        }
        return null;
    }

    private HorizontalImageAlignEnum getHorizontalImageAlign(JRImageAlignment alignment) {
        HorizontalImageAlignEnum horizontalAlignment;
        HorizontalImageAlignEnum ownHorizontalAlignment = alignment.getOwnHorizontalImageAlign();
        if (ownHorizontalAlignment != null) {
            return ownHorizontalAlignment;
        }
        JRStyle baseStyle = this.getBaseStyle((JRStyleContainer)alignment);
        if (baseStyle != null && (horizontalAlignment = baseStyle.getHorizontalImageAlign()) != null) {
            return horizontalAlignment;
        }
        return null;
    }

    private VerticalTextAlignEnum getVerticalTextAlign(JRTextAlignment alignment) {
        VerticalTextAlignEnum verticalAlignment;
        VerticalTextAlignEnum ownVerticalAlignment = alignment.getOwnVerticalTextAlign();
        if (ownVerticalAlignment != null) {
            return ownVerticalAlignment;
        }
        JRStyle baseStyle = this.getBaseStyle((JRStyleContainer)alignment);
        if (baseStyle != null && (verticalAlignment = baseStyle.getVerticalTextAlign()) != null) {
            return verticalAlignment;
        }
        return null;
    }

    private VerticalImageAlignEnum getVerticalImageAlign(JRImageAlignment alignment) {
        VerticalImageAlignEnum verticalAlignment;
        VerticalImageAlignEnum ownVerticalAlignment = alignment.getOwnVerticalImageAlign();
        if (ownVerticalAlignment != null) {
            return ownVerticalAlignment;
        }
        JRStyle baseStyle = this.getBaseStyle((JRStyleContainer)alignment);
        if (baseStyle != null && (verticalAlignment = baseStyle.getVerticalImageAlign()) != null) {
            return verticalAlignment;
        }
        return null;
    }

    private RotationEnum getRotationValue(JRCommonText element) {
        RotationEnum rotation;
        RotationEnum ownRotation = element.getOwnRotationValue();
        if (ownRotation != null) {
            return ownRotation;
        }
        JRStyle style = this.getBaseStyle((JRStyleContainer)element);
        if (style != null && (rotation = style.getRotationValue()) != null) {
            return rotation;
        }
        return null;
    }

    private String getMarkup(JRCommonText element) {
        String markup;
        String ownMarkup = element.getOwnMarkup();
        if (ownMarkup != null) {
            return ownMarkup;
        }
        JRStyle baseStyle = this.getBaseStyle((JRStyleContainer)element);
        if (baseStyle != null && (markup = baseStyle.getMarkup()) != null) {
            return markup;
        }
        return null;
    }

    private Boolean isBlankWhenNull(JRTextField element) {
        Boolean blankWhenNull;
        Boolean ownBlankWhenNull = element.isOwnBlankWhenNull();
        if (ownBlankWhenNull != null) {
            return (boolean)ownBlankWhenNull;
        }
        JRStyle baseStyle = this.getBaseStyle((JRStyleContainer)element);
        if (baseStyle != null && (blankWhenNull = baseStyle.isBlankWhenNull()) != null) {
            return (boolean)blankWhenNull;
        }
        return null;
    }

    private String getFontName(JRFont font) {
        String fontName;
        String ownFontName = font.getOwnFontName();
        if (ownFontName != null) {
            return ownFontName;
        }
        JRStyle baseStyle = this.getBaseStyle((JRStyleContainer)font);
        if (baseStyle != null && (fontName = baseStyle.getFontName()) != null) {
            return fontName;
        }
        return null;
    }

    private Boolean isBold(JRFont font) {
        Boolean bold;
        Boolean ownBold = font.isOwnBold();
        if (ownBold != null) {
            return (boolean)ownBold;
        }
        JRStyle baseStyle = this.getBaseStyle((JRStyleContainer)font);
        if (baseStyle != null && (bold = baseStyle.isBold()) != null) {
            return (boolean)bold;
        }
        return null;
    }

    private Boolean isItalic(JRFont font) {
        Boolean italic;
        Boolean ownItalic = font.isOwnItalic();
        if (ownItalic != null) {
            return (boolean)ownItalic;
        }
        JRStyle baseStyle = this.getBaseStyle((JRStyleContainer)font);
        if (baseStyle != null && (italic = baseStyle.isItalic()) != null) {
            return (boolean)italic;
        }
        return null;
    }

    private Boolean isUnderline(JRFont font) {
        Boolean underline;
        Boolean ownUnderline = font.isOwnUnderline();
        if (ownUnderline != null) {
            return (boolean)ownUnderline;
        }
        JRStyle baseStyle = this.getBaseStyle((JRStyleContainer)font);
        if (baseStyle != null && (underline = baseStyle.isUnderline()) != null) {
            return (boolean)underline;
        }
        return null;
    }

    private Boolean isStrikeThrough(JRFont font) {
        Boolean strikeThrough;
        Boolean ownStrikeThrough = font.isOwnStrikeThrough();
        if (ownStrikeThrough != null) {
            return (boolean)ownStrikeThrough;
        }
        JRStyle baseStyle = this.getBaseStyle((JRStyleContainer)font);
        if (baseStyle != null && (strikeThrough = baseStyle.isStrikeThrough()) != null) {
            return (boolean)strikeThrough;
        }
        return null;
    }

    private String getFontsize(JRFont font) {
        Float fontSize;
        Float ownFontSize = font.getOwnFontsize();
        if (ownFontSize != null) {
            return String.valueOf(ownFontSize);
        }
        JRStyle baseStyle = this.getBaseStyle((JRStyleContainer)font);
        if (baseStyle != null && (fontSize = baseStyle.getFontsize()) != null) {
            return String.valueOf(fontSize);
        }
        return null;
    }

    private String getPdfFontName(JRFont font) {
        String pdfFontName;
        String ownPdfFontName = font.getOwnPdfFontName();
        if (ownPdfFontName != null) {
            return ownPdfFontName;
        }
        JRStyle baseStyle = this.getBaseStyle((JRStyleContainer)font);
        if (baseStyle != null && (pdfFontName = baseStyle.getPdfFontName()) != null) {
            return pdfFontName;
        }
        return null;
    }

    private String getPdfEncoding(JRFont font) {
        String pdfEncoding;
        String ownPdfEncoding = font.getOwnPdfEncoding();
        if (ownPdfEncoding != null) {
            return ownPdfEncoding;
        }
        JRStyle baseStyle = this.getBaseStyle((JRStyleContainer)font);
        if (baseStyle != null && (pdfEncoding = baseStyle.getPdfEncoding()) != null) {
            return pdfEncoding;
        }
        return null;
    }

    private Integer getPadding(JRLineBox box) {
        Integer padding;
        Integer ownPadding = box.getOwnPadding();
        if (ownPadding != null) {
            return ownPadding;
        }
        JRStyle baseStyle = this.getBaseStyle((JRStyleContainer)box);
        if (baseStyle != null && (padding = baseStyle.getLineBox().getPadding()) != null) {
            return padding;
        }
        return null;
    }

    private Integer getTopPadding(JRLineBox box) {
        Integer topPadding;
        Integer ownTopPadding = box.getOwnTopPadding();
        if (ownTopPadding != null) {
            return ownTopPadding;
        }
        Integer ownPadding = box.getOwnPadding();
        if (ownPadding != null) {
            return ownPadding;
        }
        JRStyle style = this.getBaseStyle((JRStyleContainer)box);
        if (style != null && (topPadding = style.getLineBox().getTopPadding()) != null) {
            return topPadding;
        }
        return null;
    }

    private Integer getLeftPadding(JRLineBox box) {
        Integer leftPadding;
        Integer ownLeftPadding = box.getOwnLeftPadding();
        if (ownLeftPadding != null) {
            return ownLeftPadding;
        }
        Integer ownPadding = box.getOwnPadding();
        if (ownPadding != null) {
            return ownPadding;
        }
        JRStyle style = this.getBaseStyle((JRStyleContainer)box);
        if (style != null && (leftPadding = style.getLineBox().getLeftPadding()) != null) {
            return leftPadding;
        }
        return null;
    }

    private Integer getBottomPadding(JRLineBox box) {
        Integer bottomPadding;
        Integer ownBottomPadding = box.getOwnBottomPadding();
        if (ownBottomPadding != null) {
            return ownBottomPadding;
        }
        Integer ownPadding = box.getOwnPadding();
        if (ownPadding != null) {
            return ownPadding;
        }
        JRStyle style = this.getBaseStyle((JRStyleContainer)box);
        if (style != null && (bottomPadding = style.getLineBox().getBottomPadding()) != null) {
            return bottomPadding;
        }
        return null;
    }

    private Integer getRightPadding(JRLineBox box) {
        Integer rightPadding;
        Integer ownRightPadding = box.getOwnRightPadding();
        if (ownRightPadding != null) {
            return ownRightPadding;
        }
        Integer ownPadding = box.getOwnPadding();
        if (ownPadding != null) {
            return ownPadding;
        }
        JRStyle style = this.getBaseStyle((JRStyleContainer)box);
        if (style != null && (rightPadding = style.getLineBox().getRightPadding()) != null) {
            return rightPadding;
        }
        return null;
    }

    private Boolean isPdfEmbedded(JRFont font) {
        Boolean pdfEmbedded;
        Boolean ownPdfEmbedded = font.isOwnPdfEmbedded();
        if (ownPdfEmbedded != null) {
            return (boolean)ownPdfEmbedded;
        }
        JRStyle baseStyle = this.getBaseStyle((JRStyleContainer)font);
        if (baseStyle != null && (pdfEmbedded = baseStyle.isPdfEmbedded()) != null) {
            return (boolean)pdfEmbedded;
        }
        return null;
    }
}

