/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.action.copy;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.editor.action.copy.AbstractPastableObject;
import com.jaspersoft.studio.editor.action.copy.PasteCommand;
import com.jaspersoft.studio.editor.action.copy.PasteElementCommand;
import com.jaspersoft.studio.editor.gef.selection.SelectElementCommand;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.ICopyable;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.IPastable;
import com.jaspersoft.studio.model.MPage;
import com.jaspersoft.studio.model.MReport;
import com.jaspersoft.studio.model.band.MBand;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.design.JRDesignElement;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.viewers.StructuredSelection;

public class PastableElements
extends AbstractPastableObject {
    private HashMap<ICopyable, ANode> parentsMap;
    private ACTION_TYPE actionType;
    private JasperReportsConfiguration jConfig;

    public PastableElements(List<ICopyable> list, HashMap<ICopyable, ANode> parentsMap, ACTION_TYPE actionType) {
        super(list);
        this.parentsMap = parentsMap;
        this.actionType = actionType;
        for (ICopyable node : list) {
            if (!(node instanceof ANode)) continue;
            this.jConfig = ((ANode)((Object)node)).getJasperConfiguration();
        }
    }

    public boolean doSpecialPaste(Collection<?> selectedObjects) {
        Object firstElement;
        Object model;
        for (Object selection : selectedObjects) {
            if (!(selection instanceof EditPart) || !((model = ((EditPart)selection).getModel()) instanceof ANode)) continue;
            JasperReportsConfiguration nodeConfig = ((ANode)model).getJasperConfiguration();
            if (nodeConfig == null || nodeConfig == this.jConfig) break;
            return false;
        }
        if (selectedObjects.size() == 1 && (firstElement = selectedObjects.iterator().next()) instanceof EditPart) {
            boolean result;
            Object modelObj = ((EditPart)firstElement).getModel();
            boolean bl = result = modelObj instanceof MReport || modelObj instanceof MPage;
            if (result) {
                return true;
            }
        }
        if (this.actionType == ACTION_TYPE.COPY && selectedObjects.size() == this.list.size()) {
            for (Object selection : selectedObjects) {
                if (selection instanceof EditPart) {
                    model = ((EditPart)selection).getModel();
                    if (this.list.contains(model)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public Command getPasteCommand(Collection<?> targets) {
        return this.createCommand(targets);
    }

    private void addChildren(INode node, HashSet<INode> children) {
        for (INode child : node.getChildren()) {
            this.addChildren(child, children);
            children.add(child);
        }
    }

    private List<ICopyable> getNotNestedNodes() {
        HashSet<INode> nodesInHierarchy = new HashSet<INode>();
        for (ICopyable node : this.list) {
            if (!(node instanceof INode)) continue;
            this.addChildren((INode)((Object)node), nodesInHierarchy);
        }
        ArrayList<ICopyable> result = new ArrayList<ICopyable>();
        for (ICopyable node : this.list) {
            if (nodesInHierarchy.contains(node)) continue;
            result.add(node);
        }
        return result;
    }

    protected Command createCommand(Collection<?> selectedObjects) {
        if (this.doSpecialPaste(selectedObjects)) {
            CompoundCommand copyAndSelectElementsCommand = new CompoundCommand();
            JSSCompoundCommand copyElementsCommand = new JSSCompoundCommand(null);
            copyAndSelectElementsCommand.add((Command)copyElementsCommand);
            ArrayList<JRChild> elementsToSelect = new ArrayList<JRChild>();
            for (ICopyable node : this.getNotNestedNodes()) {
                ANode parent = this.parentsMap.get(node);
                copyElementsCommand.setReferenceNodeIfNull(parent);
                if (parent == null || !(node instanceof ANode)) continue;
                PasteElementCommand pasteCommand = new PasteElementCommand(parent, (ANode)((Object)node));
                copyElementsCommand.add(pasteCommand);
                if (!(pasteCommand.getPastedJRElement() instanceof JRDesignElement)) continue;
                elementsToSelect.add((JRChild)((JRDesignElement)pasteCommand.getPastedJRElement()));
            }
            SelectElementCommand selectPastedCommands = new SelectElementCommand(elementsToSelect);
            copyAndSelectElementsCommand.add((Command)selectPastedCommands);
            return copyAndSelectElementsCommand;
        }
        for (Object selection : selectedObjects) {
            Command cmd = this.getPasteComand(selection);
            if (cmd != null) {
                return cmd;
            }
            if (!(selection instanceof StructuredSelection)) continue;
            StructuredSelection s = (StructuredSelection)selection;
            for (Object o : s) {
                cmd = this.getPasteComand(o);
                if (cmd == null) continue;
                return cmd;
            }
        }
        return null;
    }

    private IPastable getParent2Paste(ANode n) {
        while (n != null) {
            if (n instanceof IPastable) {
                if (n instanceof MBand && n.getValue() == null) {
                    return null;
                }
                boolean allPastable = true;
                for (ICopyable copyable : this.list) {
                    ICopyable.RESULT result = copyable.isCopyable2(n);
                    if (result == ICopyable.RESULT.CHECK_PARENT) {
                        allPastable = false;
                        break;
                    }
                    if (result != ICopyable.RESULT.NOT_COPYABLE) continue;
                    return null;
                }
                if (allPastable) {
                    return (IPastable)((Object)n);
                }
            }
            n = n.getParent();
        }
        return null;
    }

    private Command getPasteComand(Object selection) {
        IPastable past;
        if (selection instanceof EditPart) {
            IPastable past2;
            Object modelObj = ((EditPart)selection).getModel();
            if (modelObj instanceof ANode && (past2 = this.getParent2Paste((ANode)modelObj)) != null) {
                return new PasteCommand(past2, this.getNotNestedNodes());
            }
        } else if (selection instanceof ANode && (past = this.getParent2Paste((ANode)selection)) != null) {
            return new PasteCommand(past, this.getNotNestedNodes());
        }
        return null;
    }

    public static enum ACTION_TYPE {
        COPY,
        CUT;

    }
}

