/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.action.copy;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.editor.action.copy.AbstractPastableObject;
import com.jaspersoft.studio.editor.action.copy.FixPositionCommand;
import com.jaspersoft.studio.editor.gef.selection.SelectElementCommand;
import com.jaspersoft.studio.editor.outline.OutlineTreeEditPartFactory;
import com.jaspersoft.studio.editor.style.StyleTreeEditPartFactory;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.ICopyable;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.IPastable;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.model.command.CloseSubeditorsCommand;
import com.jaspersoft.studio.model.command.CreateElementCommand;
import com.jaspersoft.studio.model.dataset.MDataset;
import com.jaspersoft.studio.model.dataset.command.CopyDatasetCommand;
import com.jaspersoft.studio.model.style.MConditionalStyle;
import com.jaspersoft.studio.model.style.MStyle;
import com.jaspersoft.studio.model.style.command.CreateConditionalStyleCommand;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRCloneable;
import net.sf.jasperreports.engine.JRConditionalStyle;
import net.sf.jasperreports.engine.design.JRDesignConditionalStyle;
import net.sf.jasperreports.engine.design.JRDesignElement;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.ui.actions.Clipboard;

public class PasteCommand
extends Command {
    protected Map<ANode, Command> list;
    protected IPastable parent;
    protected int createdNodes;
    protected Collection<ICopyable> copiedNodes;
    protected SelectElementCommand selectCommand = null;
    private List<INode> createdElements;

    public PasteCommand(IPastable parent, Collection<ICopyable> copiedNodes) {
        this.parent = parent;
        this.createdNodes = 0;
        this.copiedNodes = copiedNodes;
    }

    public boolean canExecute() {
        if (this.copiedNodes == null || this.copiedNodes.isEmpty()) {
            return false;
        }
        if (this.list == null) {
            Object obj = Clipboard.getDefault().getContents();
            if (obj == null) {
                return false;
            }
            this.list = new LinkedHashMap<ANode, Command>();
            if (obj instanceof AbstractPastableObject) {
                for (ICopyable copyableNode : this.copiedNodes) {
                    ANode node;
                    if (!(copyableNode instanceof ANode) || !this.isPastableNode(node = (ANode)((Object)copyableNode))) continue;
                    this.list.put(node, null);
                }
            } else if (obj instanceof ANode && this.isPastableNode(obj)) {
                this.list.put((ANode)obj, null);
            }
        }
        return !this.list.isEmpty();
    }

    public void execute() {
        if (this.list == null && !this.canExecute()) {
            return;
        }
        this.createdNodes = 0;
        this.createdElements = new ArrayList<INode>();
        ArrayList<JRChild> createdDesignElements = new ArrayList<JRChild>();
        for (ANode node : this.list.keySet()) {
            JSSCompoundCommand cmd = new JSSCompoundCommand(node);
            try {
                Command cmdc;
                Object value = node.getValue();
                if (!(value instanceof JRCloneable)) continue;
                ANode n = (ANode)node.getClass().newInstance();
                Rectangle rect = null;
                n.setJasperConfiguration(node.getJasperConfiguration());
                Object cloneObject = ((JRCloneable)value).clone();
                n.setValue(cloneObject);
                if (cloneObject instanceof JRDesignElement) {
                    createdDesignElements.add((JRChild)((JRDesignElement)cloneObject));
                }
                if (node.isCut() && node.getParent() != null) {
                    ANode parent = node.getParent();
                    Command deleteCommand = OutlineTreeEditPartFactory.getDeleteCommand(parent, node);
                    if (deleteCommand == null) {
                        deleteCommand = StyleTreeEditPartFactory.getDeleteCommand(parent, node);
                    }
                    if (deleteCommand != null) {
                        CloseSubeditorsCommand cmdd = new CloseSubeditorsCommand(deleteCommand, node);
                        cmd.add(cmdd);
                    }
                } else if (n instanceof MGraphicElement) {
                    MGraphicElement mge = (MGraphicElement)n;
                    JRDesignElement de = mge.getValue();
                    rect = mge.getBounds();
                    rect.setLocation(de.getX(), de.getY());
                }
                if (node instanceof MDataset) {
                    CopyDatasetCommand cmdc2 = new CopyDatasetCommand((MDataset)node, ((ANode)((Object)this.parent)).getJasperDesign());
                    cmd.add(cmdc2);
                    ++this.createdNodes;
                    this.list.put(node, (Command)cmd);
                }
                if (node instanceof MConditionalStyle) {
                    MStyle newParent = (MStyle)this.parent;
                    if (this.parent instanceof MConditionalStyle) {
                        newParent = (MStyle)((MConditionalStyle)this.parent).getParent();
                    }
                    cmdc = new CreateConditionalStyleCommand(newParent, (JRConditionalStyle)((JRDesignConditionalStyle)n.getValue()));
                    cmd.add(cmdc);
                    ++this.createdNodes;
                    this.list.put(node, (Command)cmd);
                    continue;
                }
                FixPositionCommand fixPositionCommand = null;
                cmdc = OutlineTreeEditPartFactory.getCreateCommand((ANode)((Object)this.parent), n, rect, -1);
                if (cmdc == null) {
                    cmdc = StyleTreeEditPartFactory.getCreateCommand((ANode)((Object)this.parent), n, rect, -1);
                } else {
                    if (cmdc instanceof CreateElementCommand) {
                        CreateElementCommand createCommand = (CreateElementCommand)cmdc;
                        createCommand.setApplyDefault(false);
                    }
                    if (n instanceof MGraphicElement) {
                        MGraphicElement mge = (MGraphicElement)n;
                        fixPositionCommand = new FixPositionCommand(mge, node.getParent(), (ANode)((Object)this.parent));
                    }
                }
                if (cmdc != null) {
                    this.createdElements.add(n);
                    cmd.add(cmdc);
                    if (fixPositionCommand != null) {
                        cmd.add(fixPositionCommand);
                    }
                    ++this.createdNodes;
                }
                if (cmd.isEmpty()) continue;
                this.list.put(node, (Command)cmd);
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        this.selectCommand = new SelectElementCommand(createdDesignElements);
        this.redo();
    }

    public void redo() {
        for (Command cmd : this.list.values()) {
            if (cmd == null) continue;
            cmd.execute();
        }
        if (this.selectCommand != null) {
            this.selectCommand.execute();
        }
    }

    public int getCreatedNodesNumber() {
        return this.createdNodes;
    }

    public IPastable getPasteParent() {
        return this.parent;
    }

    public boolean canUndo() {
        return !this.list.isEmpty();
    }

    public void undo() {
        for (INode createdElement : this.createdElements) {
            new CloseSubeditorsCommand(createdElement).execute();
        }
        for (Command cmd : this.list.values()) {
            cmd.undo();
        }
        this.createdNodes = 0;
        if (this.selectCommand != null) {
            this.selectCommand.undo();
        }
    }

    public boolean isPastableNode(Object node) {
        return node instanceof MDataset || node instanceof ICopyable && ((ICopyable)node).isCopyable2(this.parent) != ICopyable.RESULT.NOT_COPYABLE;
    }
}

