/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.action.copy;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.editor.action.copy.FixPositionCommand;
import com.jaspersoft.studio.editor.outline.OutlineTreeEditPartFactory;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.ICopyable;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.model.command.CloseSubeditorsCommand;
import com.jaspersoft.studio.model.dataset.MDataset;
import com.jaspersoft.studio.model.dataset.command.CopyDatasetCommand;
import com.jaspersoft.studio.model.style.MConditionalStyle;
import com.jaspersoft.studio.model.style.MStyle;
import com.jaspersoft.studio.model.style.command.CreateConditionalStyleCommand;
import net.sf.jasperreports.engine.JRCloneable;
import net.sf.jasperreports.engine.JRConditionalStyle;
import net.sf.jasperreports.engine.design.JRDesignConditionalStyle;
import net.sf.jasperreports.engine.design.JRDesignElement;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;

public class PasteElementCommand
extends Command {
    protected ANode node;
    protected JSSCompoundCommand cmd;
    protected ANode parent;
    private ANode createdElement;
    private JRCloneable copiedJRElement = null;

    public PasteElementCommand(ANode parent, ANode node) {
        this.parent = parent;
        this.node = node;
        if (node != null && node.getValue() instanceof JRCloneable) {
            this.copiedJRElement = (JRCloneable)((JRCloneable)node.getValue()).clone();
        }
    }

    public boolean canExecute() {
        return this.node instanceof MDataset || this.node instanceof ICopyable && ((ICopyable)((Object)this.node)).isCopyable2(this.parent) != ICopyable.RESULT.NOT_COPYABLE;
    }

    public void execute() {
        this.cmd = new JSSCompoundCommand(this.node);
        this.createdElement = null;
        try {
            Object value = this.node.getValue();
            if (value instanceof JRCloneable) {
                CopyDatasetCommand cmdc;
                ANode parent;
                Command deleteCommand;
                ANode n = (ANode)this.node.getClass().newInstance();
                Rectangle rect = null;
                n.setJasperConfiguration(this.node.getJasperConfiguration());
                n.setValue(this.copiedJRElement);
                if (this.node.isCut() && this.node.getParent() != null && (deleteCommand = OutlineTreeEditPartFactory.getDeleteCommand(parent = this.node.getParent(), this.node)) != null) {
                    CloseSubeditorsCommand cmdd = new CloseSubeditorsCommand(deleteCommand, this.node);
                    this.cmd.add(cmdd);
                }
                if (n instanceof MGraphicElement) {
                    MGraphicElement mge = (MGraphicElement)n;
                    rect = mge.getBounds();
                    JRDesignElement de = mge.getValue();
                    rect.setLocation(de.getX(), de.getY());
                }
                if (this.node instanceof MDataset) {
                    cmdc = new CopyDatasetCommand((MDataset)this.node, this.parent.getJasperDesign());
                    this.cmd.add(cmdc);
                } else if (this.node instanceof MConditionalStyle) {
                    MStyle newParent = (MStyle)this.parent;
                    if (this.parent instanceof MConditionalStyle) {
                        newParent = (MStyle)((MConditionalStyle)this.parent).getParent();
                    }
                    CreateConditionalStyleCommand cmdc2 = new CreateConditionalStyleCommand(newParent, (JRConditionalStyle)((JRDesignConditionalStyle)n.getValue()));
                    this.cmd.add(cmdc2);
                } else {
                    cmdc = OutlineTreeEditPartFactory.getCreateCommand(this.parent, n, rect, -1);
                    if (cmdc != null) {
                        this.createdElement = n;
                        this.cmd.add(cmdc);
                        if (n instanceof MGraphicElement) {
                            MGraphicElement mge = (MGraphicElement)n;
                            FixPositionCommand fixPositionCommand = new FixPositionCommand(mge, this.node.getParent(), this.parent);
                            this.cmd.add(fixPositionCommand);
                        }
                    }
                }
            }
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        this.redo();
    }

    public void redo() {
        if (this.cmd != null) {
            this.cmd.execute();
        }
    }

    public boolean canUndo() {
        return this.cmd != null && this.cmd.canUndo();
    }

    public void undo() {
        new CloseSubeditorsCommand(this.createdElement).execute();
        if (this.cmd != null) {
            this.cmd.undo();
            this.cmd = null;
        }
    }

    public JRCloneable getPastedJRElement() {
        return this.copiedJRElement;
    }
}

