/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.action.copy;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.action.ACachedSelectionAction;
import com.jaspersoft.studio.editor.action.copy.CopyFormatAction;
import com.jaspersoft.studio.editor.action.copy.PasteFormatCommand;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.APropertyNode;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.commands.Command;
import org.eclipse.ui.IWorkbenchPart;

public class PasteFormatAction
extends ACachedSelectionAction {
    public static final String ID = "PasteFormatAction";

    public PasteFormatAction(IWorkbenchPart part) {
        super(part);
        this.setLazyEnablementCalculation(true);
    }

    protected void init() {
        super.init();
        this.setText(Messages.PasteFormatAction_title);
        this.setId(ID);
        this.setImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/resources/paste_format.png"));
        this.setEnabled(false);
    }

    @Override
    public void run() {
        try {
            this.execute(this.createCommand());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JaspersoftStudioPlugin.getInstance().logError(ex);
        }
    }

    @Override
    protected Command createCommand() {
        if (!CopyFormatAction.hasCopiedValues()) {
            return null;
        }
        List<APropertyNode> selectedNodes = this.getNodes();
        if (selectedNodes.isEmpty()) {
            return null;
        }
        PasteFormatCommand command = new PasteFormatCommand(selectedNodes);
        return command;
    }

    protected List<APropertyNode> getNodes() {
        ArrayList<APropertyNode> result = new ArrayList<APropertyNode>();
        List<Object> nodes = this.editor.getSelectionCache().getSelectionModelForType(APropertyNode.class);
        for (Object it : nodes) {
            result.add((APropertyNode)it);
        }
        return result;
    }
}

