/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.action.csv;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.editor.action.CustomSelectionAction;
import com.jaspersoft.studio.editor.action.pdf.PropertiesList;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.model.MReport;
import com.jaspersoft.studio.model.MRoot;
import com.jaspersoft.studio.property.SetValueCommand;
import java.util.List;
import net.sf.jasperreports.engine.JRPropertiesMap;
import org.eclipse.gef.commands.Command;
import org.eclipse.ui.IWorkbenchPart;

public class CSVAction
extends CustomSelectionAction {
    public static String COL_NAME = "net.sf.jasperreports.export.csv.column.name";
    public static String COL_DATA = "net.sf.jasperreports.export.csv.data";
    public static String FIELD_DELIMITER = "net.sf.jasperreports.export.csv.field.delimiter";
    public static String RECORD_DELIMITER = "net.sf.jasperreports.export.csv.record.delimiter";
    public static String COL_NAMES = "net.sf.jasperreports.export.csv.column.names";
    public static String WRITE_HEADER = "net.sf.jasperreports.export.csv.write.header";
    private String[] attributeToRemove;

    public CSVAction(IWorkbenchPart part, String actionId, String actionName) {
        super(part, 2);
        this.setId(actionId);
        PropertiesList.addItem(actionId);
        this.setText(actionName);
        this.attributeToRemove = null;
    }

    public CSVAction(IWorkbenchPart part, String actionId, String actionName, String[] attributeToRemove) {
        this(part, actionId, actionName);
        this.attributeToRemove = attributeToRemove;
    }

    protected APropertyNode getRoot() {
        List<Object> nodes = this.editor.getSelectionCache().getSelectionModelForType(APropertyNode.class);
        return this.getRoot(nodes);
    }

    protected APropertyNode getRoot(List<Object> nodes) {
        if (nodes.isEmpty()) {
            return null;
        }
        APropertyNode columnValue = (APropertyNode)nodes.get(0);
        if (columnValue.getRoot() instanceof MRoot) {
            INode rootChildren = columnValue.getRoot().getChildren().get(0);
            if (rootChildren instanceof APropertyNode) {
                return (APropertyNode)rootChildren;
            }
        } else {
            return (APropertyNode)columnValue.getRoot();
        }
        return null;
    }

    public boolean isChecked() {
        if (!this.freshChecked) {
            this.freshChecked = true;
            this.ischecked = true;
            APropertyNode model = this.getRoot();
            if (model == null) {
                return false;
            }
            if (model instanceof MReport) {
                JRPropertiesMap v = ((MReport)model).getValue().getPropertiesMap();
                if (v == null) {
                    this.ischecked = false;
                } else {
                    String oldValue = v.getProperty(this.getId());
                    if (oldValue == null || oldValue.equals("false")) {
                        this.ischecked = false;
                    }
                }
            } else if (!(model instanceof MGraphicElement)) {
                this.ischecked = false;
            } else {
                JRPropertiesMap v = ((MGraphicElement)model).getPropertiesMap();
                if (v == null) {
                    this.ischecked = false;
                } else {
                    String oldValue = v.getProperty(this.getId());
                    if (oldValue == null || oldValue.equals("false")) {
                        this.ischecked = false;
                    }
                }
            }
        }
        return this.ischecked;
    }

    protected void removeAttributes(JRPropertiesMap map) {
        if (this.attributeToRemove != null) {
            String[] stringArray = this.attributeToRemove;
            int n = this.attributeToRemove.length;
            int n2 = 0;
            while (n2 < n) {
                String attributeName = stringArray[n2];
                map.removeProperty(attributeName);
                ++n2;
            }
        }
    }

    public Command createCommand(APropertyNode model) {
        SetValueCommand cmd = new SetValueCommand();
        cmd.setTarget(model);
        cmd.setPropertyId("PROPERTY_MAP");
        JRPropertiesMap v = (JRPropertiesMap)model.getPropertyValue("PROPERTY_MAP");
        if (v == null) {
            v = new JRPropertiesMap();
        }
        if (v.containsProperty(this.getId())) {
            v.removeProperty(this.getId());
        } else {
            v.setProperty(this.getId(), "true");
            this.removeAttributes(v);
        }
        cmd.setPropertyValue(v);
        return cmd;
    }

    @Override
    public void run() {
        this.execute(this.createCommand());
    }

    protected JSSCompoundCommand createCompoundCommand() {
        APropertyNode root = this.getRoot();
        return root != null ? new JSSCompoundCommand(root) : null;
    }

    @Override
    protected Command createCommand() {
        JSSCompoundCommand command = this.createCompoundCommand();
        if (command != null) {
            command.setDebugLabel(this.getText());
            APropertyNode model = this.getRoot();
            if (model != null) {
                command.add(this.createCommand(model));
            } else {
                return null;
            }
        }
        this.freshChecked = false;
        return command;
    }
}

