/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.action.csv;

import com.jaspersoft.studio.editor.action.csv.CSVAction;
import com.jaspersoft.studio.editor.gef.decorator.csv.NameDataChooserDialog;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.frame.MFrame;
import com.jaspersoft.studio.model.text.MTextElement;
import com.jaspersoft.studio.property.SetValueCommand;
import com.jaspersoft.studio.property.descriptor.propexpr.PropertyExpressionDTO;
import com.jaspersoft.studio.property.descriptor.propexpr.PropertyExpressionsDTO;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRPropertiesMap;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;

public class CSVColDataAction
extends CSVAction {
    private String path;
    private JRExpression data;
    private boolean repeat = false;

    public CSVColDataAction(IWorkbenchPart part, String actionName) {
        super(part, CSVAction.COL_DATA, actionName);
    }

    @Override
    public void run() {
        boolean dialogResult;
        if (this.checkFrameParent() && !(dialogResult = MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)Messages.CSVColDataAction_0, (String)Messages.CSVColDataAction_1))) {
            return;
        }
        MTextElement element = this.getSelectedElement();
        if (element == null) {
            return;
        }
        NameDataChooserDialog dialog = new NameDataChooserDialog(UIUtils.getShell(), element);
        int dialogResult2 = dialog.open();
        if (dialogResult2 == 0) {
            this.path = dialog.getName();
            this.data = dialog.getData();
            this.repeat = dialog.isRepeat();
            this.execute(this.createCommand());
        }
    }

    private MTextElement getSelectedElement() {
        List<Object> textElements = this.editor.getSelectionCache().getSelectionModelForType(MTextElement.class);
        if (textElements.isEmpty() || textElements.size() != this.getSelectedObjects().size()) {
            return null;
        }
        return (MTextElement)textElements.get(0);
    }

    @Override
    public boolean isChecked() {
        List<Object> textElements = this.editor.getSelectionCache().getSelectionModelForType(MTextElement.class);
        if (textElements.isEmpty() || textElements.size() != this.getSelectedObjects().size()) {
            return false;
        }
        for (Object element : textElements) {
            MTextElement model = (MTextElement)element;
            JRPropertiesMap colDataMap = model.getPropertiesMap();
            boolean hasColData = colDataMap.containsProperty(CSVAction.COL_DATA);
            if (hasColData) continue;
            return false;
        }
        return true;
    }

    private boolean checkFrameParent() {
        List<Object> textElements = this.editor.getSelectionCache().getSelectionModelForType(MTextElement.class);
        if (textElements.isEmpty() || this.getSelectedObjects().size() > 1) {
            return false;
        }
        MTextElement element = (MTextElement)textElements.get(0);
        return element.getParent() instanceof MFrame;
    }

    @Override
    protected boolean calculateEnabled() {
        return !this.editor.getSelectionCache().getSelectionModelForType(MTextElement.class).isEmpty();
    }

    @Override
    protected Command createCommand() {
        MTextElement n = this.getSelectedElement();
        if (n == null) {
            return null;
        }
        PropertyExpressionsDTO peDTO = (PropertyExpressionsDTO)n.getPropertyValue("propertyExpressions");
        if (this.path == null) {
            peDTO.removeProperty("net.sf.jasperreports.export.csv.column.name", false);
            peDTO.removeProperty("net.sf.jasperreports.export.csv.repeat.value", false);
            this.removeDataPropertyExpression(peDTO);
        } else {
            peDTO.setProperty("net.sf.jasperreports.export.csv.column.name", this.path, false, false);
            if (this.repeat) {
                peDTO.setProperty("net.sf.jasperreports.export.csv.repeat.value", "true", false, false);
            } else {
                peDTO.removeProperty("net.sf.jasperreports.export.csv.repeat.value", false);
            }
        }
        if (this.data == null) {
            this.removeDataPropertyExpression(peDTO);
        } else {
            PropertyExpressionDTO dpe = peDTO.getProperty("net.sf.jasperreports.export.csv.data", true);
            if (dpe == null) {
                peDTO.addProperty("net.sf.jasperreports.export.csv.data", this.data.getText(), true, false);
            } else {
                dpe.setValue(this.data.getText());
            }
        }
        SetValueCommand cmd = new SetValueCommand();
        cmd.setDebugLabel(this.getText());
        cmd.setTarget(n);
        cmd.setPropertyId("propertyExpressions");
        cmd.setPropertyValue(peDTO);
        return cmd;
    }

    protected void removeDataPropertyExpression(PropertyExpressionsDTO peDTO) {
        peDTO.removeProperty("net.sf.jasperreports.export.csv.data", true);
    }
}

