/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.action.csv;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.editor.action.csv.CSVAction;
import com.jaspersoft.studio.editor.gef.decorator.csv.NameDialog;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.property.SetValueCommand;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.JRPropertiesMap;
import org.eclipse.gef.commands.Command;
import org.eclipse.ui.IWorkbenchPart;

public class CSVRootAction
extends CSVAction {
    private String columnsName;

    public CSVRootAction(IWorkbenchPart part, String actionId, String actionName) {
        super(part, actionId, actionName);
    }

    private String getDialogTitle() {
        if (this.getId() == CSVAction.FIELD_DELIMITER) {
            return Messages.CSVRootAction_FieldDelimiterDialog;
        }
        if (this.getId() == CSVAction.RECORD_DELIMITER) {
            return Messages.CSVRootAction_RecordDelimiterDialog;
        }
        return Messages.CSVRootAction_GeneralDialog;
    }

    @Override
    public boolean isChecked() {
        return false;
    }

    private String getPropertyValue(APropertyNode node, String nullValue) {
        String result;
        JRPropertiesMap v = (JRPropertiesMap)node.getPropertyValue("PROPERTY_MAP");
        if (v == null) {
            v = new JRPropertiesMap();
        }
        return (result = v.getProperty(this.getId())) != null ? result : nullValue;
    }

    @Override
    public void run() {
        APropertyNode root = this.getRoot();
        NameDialog dialog = new NameDialog(UIUtils.getShell(), this.getDialogTitle(), this.getPropertyValue(root, ""));
        int dialogResult = dialog.open();
        if (dialogResult == 0) {
            this.columnsName = dialog.getName();
        }
        this.execute(this.createCommand());
    }

    @Override
    protected Command createCommand() {
        APropertyNode root = this.getRoot();
        JSSCompoundCommand command = new JSSCompoundCommand(root);
        command.setDebugLabel(this.getText());
        if (root != null) {
            command.add(this.createCommand(root, this.columnsName));
        }
        return command;
    }

    public Command createCommand(APropertyNode model, String fieldValue) {
        SetValueCommand cmd = new SetValueCommand();
        cmd.setTarget(model);
        cmd.setPropertyId("PROPERTY_MAP");
        JRPropertiesMap v = (JRPropertiesMap)model.getPropertyValue("PROPERTY_MAP");
        if (v == null) {
            v = new JRPropertiesMap();
        }
        v.setProperty(this.getId(), fieldValue);
        cmd.setPropertyValue(v);
        return cmd;
    }
}

