/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.action.exporter.wizard;

import com.jaspersoft.studio.editor.action.exporter.IExportedResourceHandler;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.plugin.ExtensionManager;
import com.jaspersoft.studio.wizards.JSSHelpWizardPage;
import java.io.File;
import java.util.UUID;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.eclipse.util.ZipUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SourcePage
extends JSSHelpWizardPage {
    private Text pathText = null;
    private String pathString;

    protected SourcePage() {
        super("importresources");
        this.setTitle(Messages.SourcePage_importTitle);
        this.setDescription(Messages.SourcePage_pageDescription);
        this.setErrorMessage(Messages.SourcePage_errorFileNotSelected);
    }

    @Override
    protected String getContextName() {
        return null;
    }

    public String getDestinationPath() {
        return this.pathString;
    }

    public void createControl(Composite parent) {
        Composite pathComposite = new Composite(parent, 0);
        pathComposite.setLayout((Layout)new GridLayout(3, false));
        GridData gd = new GridData(1808);
        pathComposite.setLayoutData((Object)gd);
        new Label(pathComposite, 0).setText(Messages.SourcePage_locatinLabel);
        this.pathText = new Text(pathComposite, 2048);
        this.pathText.setEditable(false);
        gd = new GridData(4, 0x1000000, true, false);
        this.pathText.setLayoutData((Object)gd);
        Button browseButton = new Button(pathComposite, 0);
        browseButton.setText(Messages.ResourcePage_browseButton);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fd = new FileDialog(UIUtils.getShell(), 4096);
                fd.setText(Messages.SourcePage_dialogText);
                String[] filterExt = new String[]{"*.zip"};
                fd.setFilterExtensions(filterExt);
                String zipLocation = fd.open();
                if (zipLocation != null && new File(zipLocation).exists()) {
                    try {
                        if (SourcePage.this.pathString != null) {
                            FileUtils.recursiveDelete((File)new File(SourcePage.this.pathString));
                        }
                        SourcePage.this.pathString = SourcePage.this.extractAndValidateZip(zipLocation);
                        SourcePage.this.pathText.setText(zipLocation);
                        if (!SourcePage.this.hasImportableContent(SourcePage.this.pathString)) {
                            SourcePage.this.setErrorMessage(Messages.SourcePage_errorImprtableEmprty);
                        } else {
                            SourcePage.this.setErrorMessage(null);
                        }
                    }
                    catch (Exception ex) {
                        SourcePage.this.pathString = null;
                        SourcePage.this.pathText.setText("");
                        SourcePage.this.setErrorMessage(Messages.SourcePage_errorFileError);
                        UIUtils.showError((String)Messages.SourcePage_errorFileError, (Throwable)ex);
                    }
                }
                SourcePage.this.getContainer().updateButtons();
            }
        });
        this.setControl((Control)pathComposite);
    }

    public boolean isPageComplete() {
        return super.isPageComplete() && this.getErrorMessage() == null;
    }

    protected boolean hasImportableContent(String path) {
        File contentFolder = new File(path);
        for (IExportedResourceHandler importer : ExtensionManager.getContributedExporters()) {
            if (importer.getRestorableResources(contentFolder).size() <= 0) continue;
            return true;
        }
        return false;
    }

    protected String extractAndValidateZip(String path) {
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        File unzipLocation = new File(tempDir, UUID.randomUUID().toString());
        if (unzipLocation.exists()) {
            FileUtils.recursiveDelete((File)unzipLocation);
        }
        unzipLocation.mkdirs();
        unzipLocation.deleteOnExit();
        ZipUtils zipUtils = new ZipUtils();
        zipUtils.unZipFiles(path, unzipLocation.getAbsolutePath());
        return unzipLocation.getAbsolutePath();
    }
}

