/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.action.json;

import com.jaspersoft.studio.editor.action.json.JSONAction;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.MReport;
import com.jaspersoft.studio.property.SetValueCommand;
import java.util.List;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JasperReportsContext;
import org.eclipse.gef.commands.Command;
import org.eclipse.ui.IWorkbenchPart;

public class JSONEscapeMembersAction
extends JSONAction {
    public JSONEscapeMembersAction(IWorkbenchPart part) {
        super(part, "net.sf.jasperreports.export.json.escape.members", Messages.JSONEscapeMembersAction_0);
    }

    @Override
    public void run() {
        this.execute(this.createCommand());
        this.setChecked(this.ischecked);
    }

    private MReport getSelectedElement() {
        List<Object> textElements = this.editor.getSelectionCache().getSelectionModelForType(MReport.class);
        if (textElements.isEmpty() || textElements.size() != this.getSelectedObjects().size()) {
            return null;
        }
        return (MReport)textElements.get(0);
    }

    @Override
    public boolean isChecked() {
        MReport model = this.getSelectedElement();
        if (model == null) {
            return false;
        }
        boolean escape = JRPropertiesUtil.getInstance((JasperReportsContext)model.getJasperConfiguration()).getBooleanProperty("net.sf.jasperreports.export.json.escape.members", true);
        JRPropertiesMap colDataMap = model.getValue().getPropertiesMap();
        String esc = colDataMap.getProperty("net.sf.jasperreports.export.json.escape.members");
        if (esc != null) {
            escape = (Boolean)Misc.nvl((Object)Boolean.valueOf(esc), (Object)escape);
        }
        return escape;
    }

    @Override
    protected boolean calculateEnabled() {
        return !this.editor.getSelectionCache().getSelectionModelForType(MReport.class).isEmpty();
    }

    @Override
    protected Command createCommand() {
        MReport n = this.getSelectedElement();
        if (n == null) {
            return null;
        }
        JRPropertiesMap map = (JRPropertiesMap)n.getPropertyValue("PROPERTY_MAP");
        if (map == null) {
            map = new JRPropertiesMap();
        }
        if (map.containsProperty("net.sf.jasperreports.export.json.escape.members")) {
            map.removeProperty("net.sf.jasperreports.export.json.escape.members");
        } else {
            map.setProperty("net.sf.jasperreports.export.json.escape.members", "true");
        }
        SetValueCommand cmd = new SetValueCommand();
        cmd.setTarget(n);
        cmd.setPropertyId("PROPERTY_MAP");
        cmd.setPropertyValue(map);
        cmd.setDebugLabel(this.getText());
        return cmd;
    }
}

