/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.action.order;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.action.ACachedSelectionAction;
import com.jaspersoft.studio.editor.action.IGlobalAction;
import com.jaspersoft.studio.editor.action.order.OrderUtil;
import com.jaspersoft.studio.editor.outline.OutlineTreeEditPartFactory;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.MGraphicElement;
import java.util.List;
import org.eclipse.gef.commands.Command;
import org.eclipse.ui.IWorkbenchPart;

public class BringForwardAction
extends ACachedSelectionAction
implements IGlobalAction {
    public static final String ID = "bring_forward";

    public BringForwardAction(IWorkbenchPart part) {
        super(part);
        this.setLazyEnablementCalculation(false);
    }

    @Override
    public Command createCommand() {
        List<Object> graphicalElements = this.editor.getSelectionCache().getSelectionModelForType(MGraphicElement.class);
        if (graphicalElements.isEmpty()) {
            return null;
        }
        OrderUtil.reorderReverseElements(graphicalElements);
        JSSCompoundCommand compoundCmd = new JSSCompoundCommand("Bring Forward", null);
        compoundCmd.enableSelectionRestore(true);
        for (Object model : graphicalElements) {
            Command cmd = null;
            ANode parent = ((MGraphicElement)model).getParent();
            compoundCmd.setReferenceNodeIfNull(parent);
            if (parent == null || parent.getChildren() == null) continue;
            int newIndex = parent.getChildren().indexOf(model) + 1;
            if (newIndex >= parent.getChildren().size()) {
                return null;
            }
            cmd = OutlineTreeEditPartFactory.getReorderCommand((ANode)model, parent, newIndex);
            if (cmd == null) continue;
            compoundCmd.add(cmd);
        }
        return compoundCmd;
    }

    @Override
    public void run() {
        this.execute(this.command);
    }

    protected void init() {
        super.init();
        this.setText(Messages.BringForwardAction_bring_forward);
        this.setToolTipText(Messages.BringForwardAction_bring_forward_tool_tip);
        this.setId(ID);
        this.setImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/eclipseapps/elcl16/bring_forward.gif"));
        this.setDisabledImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/eclipseapps/dlcl16/bring_forward.gif"));
        this.setEnabled(false);
    }
}

