/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.action.order;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.action.ACachedSelectionAction;
import com.jaspersoft.studio.editor.action.IGlobalAction;
import com.jaspersoft.studio.editor.action.order.OrderUtil;
import com.jaspersoft.studio.editor.outline.OutlineTreeEditPartFactory;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.MGraphicElement;
import java.util.List;
import org.eclipse.gef.commands.Command;
import org.eclipse.ui.IWorkbenchPart;

public class BringToBackAction
extends ACachedSelectionAction
implements IGlobalAction {
    public static final String ID = "bring_back";

    public BringToBackAction(IWorkbenchPart part) {
        super(part);
        this.setLazyEnablementCalculation(false);
    }

    @Override
    public Command createCommand() {
        List<Object> graphicalElements = this.editor.getSelectionCache().getSelectionModelForType(MGraphicElement.class);
        if (graphicalElements.isEmpty()) {
            return null;
        }
        OrderUtil.reorderElements(graphicalElements);
        JSSCompoundCommand compoundCmd = new JSSCompoundCommand("Bring To Back", null);
        int j = 0;
        for (Object model : graphicalElements) {
            Command cmd = null;
            ANode parent = ((MGraphicElement)model).getParent();
            compoundCmd.setReferenceNodeIfNull(parent);
            if (parent != null && parent.getChildren().indexOf(model) > 0) {
                cmd = OutlineTreeEditPartFactory.getReorderCommand((ANode)model, parent, j);
                ++j;
            } else {
                return null;
            }
            if (cmd == null) continue;
            compoundCmd.add(cmd);
        }
        return compoundCmd;
    }

    @Override
    public void run() {
        this.execute(this.createCommand());
    }

    protected void init() {
        super.init();
        this.setText(Messages.BringToBackAction_send_to_back);
        this.setToolTipText(Messages.BringToBackAction_send_to_back_tool_tip);
        this.setId(ID);
        this.setImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/eclipseapps/elcl16/send_to_back.gif"));
        this.setDisabledImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/eclipseapps/elcl16/send_to_back.gif"));
        this.setEnabled(false);
    }
}

